/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import io.sentry.DefaultSentryClientFactory;
import io.sentry.SentryClient;
import io.sentry.android.event.helper.AndroidEventBuilderHelper;
import io.sentry.buffer.Buffer;
import io.sentry.buffer.DiskBuffer;
import io.sentry.config.Lookup;
import io.sentry.context.ContextManager;
import io.sentry.context.SingletonContextManager;
import io.sentry.dsn.Dsn;
import io.sentry.event.helper.EventBuilderHelper;
import io.sentry.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class AndroidSentryClientFactory
extends DefaultSentryClientFactory {
    public static final String TAG = AndroidSentryClientFactory.class.getName();
    private static final String DEFAULT_BUFFER_DIR = "sentry-buffered-events";
    private Context ctx;

    public AndroidSentryClientFactory(Application app) {
        Log.d((String)TAG, (String)"Construction of Android Sentry from Android Application.");
        this.ctx = app.getApplicationContext();
    }

    public AndroidSentryClientFactory(Context ctx) {
        Log.d((String)TAG, (String)"Construction of Android Sentry from Android Context.");
        this.ctx = ctx.getApplicationContext();
        if (this.ctx == null) {
            this.ctx = ctx;
        }
    }

    public SentryClient createSentryClient(Dsn dsn) {
        if (!this.checkPermission("android.permission.INTERNET")) {
            Log.e((String)TAG, (String)"android.permission.INTERNET is required to connect to the Sentry server, please add it to your AndroidManifest.xml");
        }
        Log.d((String)TAG, (String)("Sentry init with ctx='" + this.ctx.toString() + "'"));
        String protocol = dsn.getProtocol();
        if (protocol.equalsIgnoreCase("noop")) {
            Log.w((String)TAG, (String)"*** Couldn't find a suitable DSN, Sentry operations will do nothing! See documentation: https://docs.sentry.io/clients/java/modules/android/ ***");
        } else if (!protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            String async = Lookup.lookup((String)"async", (Dsn)dsn);
            if (async != null && async.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("Sentry Android cannot use synchronous connections, remove 'async=false' from your options.");
            }
            throw new IllegalArgumentException("Only 'http' or 'https' connections are supported in Sentry Android, but received: " + protocol);
        }
        SentryClient sentryClient = super.createSentryClient(dsn);
        sentryClient.addBuilderHelper((EventBuilderHelper)new AndroidEventBuilderHelper(this.ctx));
        return sentryClient;
    }

    protected Collection<String> getInAppFrames(Dsn dsn) {
        Collection inAppFrames = super.getInAppFrames(dsn);
        if (inAppFrames.isEmpty()) {
            PackageInfo info = null;
            try {
                info = this.ctx.getPackageManager().getPackageInfo(this.ctx.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)TAG, (String)"Error getting package information.", (Throwable)e);
            }
            if (info != null && !Util.isNullOrEmpty((String)info.packageName)) {
                ArrayList<String> newPackages = new ArrayList<String>(1);
                newPackages.add(info.packageName);
                return newPackages;
            }
        }
        return inAppFrames;
    }

    protected Buffer getBuffer(Dsn dsn) {
        String bufferDirOpt = Lookup.lookup((String)"buffer.dir", (Dsn)dsn);
        File bufferDir = bufferDirOpt != null ? new File(bufferDirOpt) : new File(this.ctx.getCacheDir().getAbsolutePath(), DEFAULT_BUFFER_DIR);
        Log.d((String)TAG, (String)("Using buffer dir: " + bufferDir.getAbsolutePath()));
        return new DiskBuffer(bufferDir, this.getBufferSize(dsn));
    }

    protected ContextManager getContextManager(Dsn dsn) {
        return new SingletonContextManager();
    }

    private boolean checkPermission(String permission) {
        int res = this.ctx.checkCallingOrSelfPermission(permission);
        return res == 0;
    }
}

