/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android;

import android.content.Context;
import android.util.Log;
import io.sentry.DefaultSentryClientFactory;
import io.sentry.SentryClient;
import io.sentry.SentryUncaughtExceptionHandler;
import io.sentry.android.event.helper.AndroidEventBuilderHelper;
import io.sentry.buffer.Buffer;
import io.sentry.buffer.DiskBuffer;
import io.sentry.config.Lookup;
import io.sentry.context.ContextManager;
import io.sentry.context.SingletonContextManager;
import io.sentry.dsn.Dsn;
import io.sentry.event.helper.EventBuilderHelper;
import java.io.File;

public class AndroidSentryClientFactory
extends DefaultSentryClientFactory {
    public static final String TAG = AndroidSentryClientFactory.class.getName();
    private static final String DEFAULT_BUFFER_DIR = "sentry-buffered-events";
    private Context ctx;

    public AndroidSentryClientFactory(Context ctx) {
        Log.d((String)TAG, (String)"Construction of Android Sentry.");
        this.ctx = ctx.getApplicationContext();
    }

    public SentryClient createSentryClient(Dsn dsn) {
        if (!this.checkPermission("android.permission.INTERNET")) {
            Log.e((String)TAG, (String)"android.permission.INTERNET is required to connect to the Sentry server, please add it to your AndroidManifest.xml");
        }
        Log.d((String)TAG, (String)("Sentry init with ctx='" + this.ctx.toString() + "' and dsn='" + dsn + "'"));
        String protocol = dsn.getProtocol();
        if (protocol.equalsIgnoreCase("noop")) {
            Log.w((String)TAG, (String)"*** Couldn't find a suitable DSN, Sentry operations will do nothing! See documentation: https://docs.sentry.io/clients/java/modules/android/ ***");
        } else if (!protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            String async = Lookup.lookup((String)"async", (Dsn)dsn);
            if (async != null && async.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("Sentry Android cannot use synchronous connections, remove 'async=false' from your options.");
            }
            throw new IllegalArgumentException("Only 'http' or 'https' connections are supported in Sentry Android, but received: " + protocol);
        }
        SentryClient sentryClient = super.createSentryClient(dsn);
        sentryClient.addBuilderHelper((EventBuilderHelper)new AndroidEventBuilderHelper(this.ctx));
        SentryUncaughtExceptionHandler.setup();
        return sentryClient;
    }

    protected Buffer getBuffer(Dsn dsn) {
        String bufferDirOpt = Lookup.lookup((String)"buffer.dir", (Dsn)dsn);
        File bufferDir = bufferDirOpt != null ? new File(bufferDirOpt) : new File(this.ctx.getCacheDir().getAbsolutePath(), DEFAULT_BUFFER_DIR);
        Log.d((String)TAG, (String)("Using buffer dir: " + bufferDir.getAbsolutePath()));
        return new DiskBuffer(bufferDir, this.getBufferSize(dsn));
    }

    protected ContextManager getContextManager(Dsn dsn) {
        return new SingletonContextManager();
    }

    private boolean checkPermission(String permission) {
        int res = this.ctx.checkCallingOrSelfPermission(permission);
        return res == 0;
    }
}

