/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.event.helper;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import io.sentry.event.EventBuilder;
import io.sentry.event.helper.EventBuilderHelper;
import io.sentry.event.interfaces.SentryInterface;
import io.sentry.event.interfaces.UserInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AndroidEventBuilderHelper
implements EventBuilderHelper {
    public static final String TAG = AndroidEventBuilderHelper.class.getName();
    private static final Boolean IS_EMULATOR = AndroidEventBuilderHelper.isEmulator();
    private static final String KERNEL_VERSION = AndroidEventBuilderHelper.getKernelVersion();
    private Context ctx;

    public AndroidEventBuilderHelper(Context ctx) {
        this.ctx = ctx;
    }

    public void helpBuildingEvent(EventBuilder eventBuilder) {
        String androidId;
        eventBuilder.withSdkIntegration("android");
        PackageInfo packageInfo = AndroidEventBuilderHelper.getPackageInfo(this.ctx);
        if (packageInfo != null) {
            eventBuilder.withRelease(packageInfo.packageName + "-" + packageInfo.versionName);
            eventBuilder.withDist(Integer.toString(packageInfo.versionCode));
        }
        if ((androidId = Settings.Secure.getString((ContentResolver)this.ctx.getContentResolver(), (String)"android_id")) != null && !androidId.trim().equals("")) {
            UserInterface userInterface = new UserInterface("android:" + androidId, null, null, null);
            eventBuilder.withSentryInterface((SentryInterface)userInterface, false);
        }
        eventBuilder.withContexts(this.getContexts());
    }

    private Map<String, Map<String, Object>> getContexts() {
        ActivityManager.MemoryInfo memInfo;
        HashMap<String, Map<String, Object>> contexts = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> deviceMap = new HashMap<String, Object>();
        HashMap<String, Object> osMap = new HashMap<String, Object>();
        HashMap<String, Object> appMap = new HashMap<String, Object>();
        contexts.put("os", osMap);
        contexts.put("device", deviceMap);
        contexts.put("app", appMap);
        deviceMap.put("manufacturer", Build.MANUFACTURER);
        deviceMap.put("brand", Build.BRAND);
        deviceMap.put("model", Build.MODEL);
        deviceMap.put("family", AndroidEventBuilderHelper.getFamily());
        deviceMap.put("model_id", Build.ID);
        deviceMap.put("battery_level", AndroidEventBuilderHelper.getBatteryLevel(this.ctx));
        deviceMap.put("orientation", AndroidEventBuilderHelper.getOrientation(this.ctx));
        deviceMap.put("simulator", IS_EMULATOR);
        deviceMap.put("arch", Build.CPU_ABI);
        deviceMap.put("storage_size", AndroidEventBuilderHelper.getTotalInternalStorage());
        deviceMap.put("free_storage", AndroidEventBuilderHelper.getUnusedInternalStorage());
        deviceMap.put("external_storage_size", AndroidEventBuilderHelper.getTotalExternalStorage());
        deviceMap.put("external_free_storage", AndroidEventBuilderHelper.getUnusedExternalStorage());
        deviceMap.put("charging", AndroidEventBuilderHelper.isCharging(this.ctx));
        deviceMap.put("online", AndroidEventBuilderHelper.isConnected(this.ctx));
        DisplayMetrics displayMetrics = AndroidEventBuilderHelper.getDisplayMetrics(this.ctx);
        if (displayMetrics != null) {
            int largestSide = Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
            int smallestSide = Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels);
            String resolution = Integer.toString(largestSide) + "x" + Integer.toString(smallestSide);
            deviceMap.put("screen_resolution", resolution);
            deviceMap.put("screen_density", Float.valueOf(displayMetrics.density));
            deviceMap.put("screen_dpi", displayMetrics.densityDpi);
        }
        if ((memInfo = AndroidEventBuilderHelper.getMemInfo(this.ctx)) != null) {
            deviceMap.put("free_memory", memInfo.availMem);
            deviceMap.put("memory_size", memInfo.totalMem);
            deviceMap.put("low_memory", memInfo.lowMemory);
        }
        osMap.put("name", "Android");
        osMap.put("version", Build.VERSION.RELEASE);
        osMap.put("build", Build.DISPLAY);
        osMap.put("kernel_version", KERNEL_VERSION);
        osMap.put("rooted", AndroidEventBuilderHelper.isRooted());
        PackageInfo packageInfo = AndroidEventBuilderHelper.getPackageInfo(this.ctx);
        if (packageInfo != null) {
            appMap.put("app_version", packageInfo.versionName);
            appMap.put("app_build", packageInfo.versionCode);
            appMap.put("app_identifier", packageInfo.packageName);
        }
        appMap.put("app_name", AndroidEventBuilderHelper.getApplicationName(this.ctx));
        appMap.put("app_start_time", AndroidEventBuilderHelper.stringifyDate(new Date()));
        return contexts;
    }

    private static PackageInfo getPackageInfo(Context ctx) {
        try {
            return ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Error getting package info.", (Throwable)e);
            return null;
        }
    }

    private static String getFamily() {
        try {
            return Build.MODEL.split(" ")[0];
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error getting device family.", (Throwable)e);
            return null;
        }
    }

    private static Boolean isEmulator() {
        try {
            return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error checking whether application is running in an emulator.", (Throwable)e);
            return null;
        }
    }

    private static ActivityManager.MemoryInfo getMemInfo(Context ctx) {
        try {
            ActivityManager actManager = (ActivityManager)ctx.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            actManager.getMemoryInfo(memInfo);
            return memInfo;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error getting MemoryInfo.", (Throwable)e);
            return null;
        }
    }

    private static String getOrientation(Context ctx) {
        try {
            String o;
            switch (ctx.getResources().getConfiguration().orientation) {
                case 2: {
                    o = "landscape";
                    break;
                }
                case 1: {
                    o = "portrait";
                    break;
                }
                default: {
                    o = null;
                }
            }
            return o;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error getting device orientation.", (Throwable)e);
            return null;
        }
    }

    private static Float getBatteryLevel(Context ctx) {
        try {
            Intent intent = ctx.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            if (intent == null) {
                return null;
            }
            int level = intent.getIntExtra("level", -1);
            int scale = intent.getIntExtra("scale", -1);
            if (level == -1 || scale == -1) {
                return null;
            }
            float percentMultiplier = 100.0f;
            return Float.valueOf((float)level / (float)scale * percentMultiplier);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error getting device battery level.", (Throwable)e);
            return null;
        }
    }

    private static Boolean isCharging(Context ctx) {
        try {
            Intent intent = ctx.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            if (intent == null) {
                return null;
            }
            int plugged = intent.getIntExtra("plugged", -1);
            return plugged == 1 || plugged == 2;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error getting device charging state.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getKernelVersion() {
        String errorMsg = "Exception while attempting to read kernel information";
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader("/proc/version"));
            String string = br.readLine();
            return string;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)errorMsg, (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    Log.e((String)TAG, (String)errorMsg, (Throwable)ioe);
                }
            }
        }
        return null;
    }

    private static Boolean isRooted() {
        String[] probableRootPaths;
        if (Build.TAGS != null && Build.TAGS.contains("test-keys")) {
            return true;
        }
        for (String probableRootPath : probableRootPaths = new String[]{"/data/local/bin/su", "/data/local/su", "/data/local/xbin/su", "/sbin/su", "/su/bin", "/su/bin/su", "/system/app/SuperSU", "/system/app/SuperSU.apk", "/system/app/Superuser", "/system/app/Superuser.apk", "/system/bin/failsafe/su", "/system/bin/su", "/system/sd/xbin/su", "/system/xbin/daemonsu", "/system/xbin/su"}) {
            try {
                if (!new File(probableRootPath).exists()) continue;
                return true;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception while attempting to detect whether the device is rooted", (Throwable)e);
            }
        }
        return false;
    }

    private static boolean isExternalStorageMounted() {
        return Environment.getExternalStorageState().equals("mounted") && !Environment.isExternalStorageEmulated();
    }

    private static Long getUnusedInternalStorage() {
        try {
            File path = Environment.getDataDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long availableBlocks = stat.getAvailableBlocks();
            return availableBlocks * blockSize;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error getting unused internal storage amount.", (Throwable)e);
            return null;
        }
    }

    private static Long getTotalInternalStorage() {
        try {
            File path = Environment.getDataDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long totalBlocks = stat.getBlockCount();
            return totalBlocks * blockSize;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error getting total internal storage amount.", (Throwable)e);
            return null;
        }
    }

    private static Long getUnusedExternalStorage() {
        try {
            if (AndroidEventBuilderHelper.isExternalStorageMounted()) {
                File path = Environment.getExternalStorageDirectory();
                StatFs stat = new StatFs(path.getPath());
                long blockSize = stat.getBlockSize();
                long availableBlocks = stat.getAvailableBlocks();
                return availableBlocks * blockSize;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error getting unused external storage amount.", (Throwable)e);
        }
        return null;
    }

    private static Long getTotalExternalStorage() {
        try {
            if (AndroidEventBuilderHelper.isExternalStorageMounted()) {
                File path = Environment.getExternalStorageDirectory();
                StatFs stat = new StatFs(path.getPath());
                long blockSize = stat.getBlockSize();
                long totalBlocks = stat.getBlockCount();
                return totalBlocks * blockSize;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error getting total external storage amount.", (Throwable)e);
        }
        return null;
    }

    private static DisplayMetrics getDisplayMetrics(Context ctx) {
        try {
            return ctx.getResources().getDisplayMetrics();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error getting DisplayMetrics.", (Throwable)e);
            return null;
        }
    }

    private static String stringifyDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(date);
    }

    private static String getApplicationName(Context ctx) {
        block4: {
            try {
                ApplicationInfo applicationInfo = ctx.getApplicationInfo();
                int stringId = applicationInfo.labelRes;
                if (stringId == 0) {
                    if (applicationInfo.nonLocalizedLabel != null) {
                        return applicationInfo.nonLocalizedLabel.toString();
                    }
                    break block4;
                }
                return ctx.getString(stringId);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error getting application name.", (Throwable)e);
            }
        }
        return null;
    }

    private static boolean isConnected(Context ctx) {
        ConnectivityManager connectivityManager = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }
}

