/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.timber;

import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.Integration;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.timber.SentryTimberTree;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/sentry/android/timber/SentryTimberIntegration;", "Lio/sentry/Integration;", "Ljava/io/Closeable;", "minEventLevel", "Lio/sentry/SentryLevel;", "minBreadcrumbLevel", "(Lio/sentry/SentryLevel;Lio/sentry/SentryLevel;)V", "logger", "Lio/sentry/ILogger;", "getMinBreadcrumbLevel", "()Lio/sentry/SentryLevel;", "getMinEventLevel", "tree", "Lio/sentry/android/timber/SentryTimberTree;", "close", "", "register", "hub", "Lio/sentry/IHub;", "options", "Lio/sentry/SentryOptions;", "sentry-android-timber_release"})
public final class SentryTimberIntegration
implements Integration,
Closeable {
    private SentryTimberTree tree;
    private ILogger logger;
    @NotNull
    private final SentryLevel minEventLevel;
    @NotNull
    private final SentryLevel minBreadcrumbLevel;

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ILogger iLogger = options.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)iLogger, (String)"options.logger");
        this.logger = iLogger;
        SentryTimberTree sentryTimberTree = this.tree = new SentryTimberTree(hub, this.minEventLevel, this.minBreadcrumbLevel);
        if (sentryTimberTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
        }
        Timber.plant((Timber.Tree)sentryTimberTree);
        ILogger iLogger2 = this.logger;
        if (iLogger2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        iLogger2.log(SentryLevel.DEBUG, "SentryTimberIntegration installed.", new Object[0]);
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-android-timber", "6.17.0");
        this.addIntegrationToSdkVersion();
    }

    @Override
    public void close() {
        if (this.tree != null) {
            SentryTimberTree sentryTimberTree = this.tree;
            if (sentryTimberTree == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
            }
            Timber.uproot((Timber.Tree)sentryTimberTree);
            if (this.logger != null) {
                ILogger iLogger = this.logger;
                if (iLogger == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                }
                iLogger.log(SentryLevel.DEBUG, "SentryTimberIntegration removed.", new Object[0]);
            }
        }
    }

    @NotNull
    public final SentryLevel getMinEventLevel() {
        return this.minEventLevel;
    }

    @NotNull
    public final SentryLevel getMinBreadcrumbLevel() {
        return this.minBreadcrumbLevel;
    }

    public SentryTimberIntegration(@NotNull SentryLevel minEventLevel, @NotNull SentryLevel minBreadcrumbLevel) {
        Intrinsics.checkNotNullParameter((Object)minEventLevel, (String)"minEventLevel");
        Intrinsics.checkNotNullParameter((Object)minBreadcrumbLevel, (String)"minBreadcrumbLevel");
        this.minEventLevel = minEventLevel;
        this.minBreadcrumbLevel = minBreadcrumbLevel;
    }

    public /* synthetic */ SentryTimberIntegration(SentryLevel sentryLevel, SentryLevel sentryLevel2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sentryLevel = SentryLevel.ERROR;
        }
        if ((n & 2) != 0) {
            sentryLevel2 = SentryLevel.INFO;
        }
        this(sentryLevel, sentryLevel2);
    }

    public SentryTimberIntegration() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ SentryTimberTree access$getTree$p(SentryTimberIntegration $this) {
        SentryTimberTree sentryTimberTree = $this.tree;
        if (sentryTimberTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tree");
        }
        return sentryTimberTree;
    }

    public static final /* synthetic */ void access$setTree$p(SentryTimberIntegration $this, SentryTimberTree sentryTimberTree) {
        $this.tree = sentryTimberTree;
    }

    public static final /* synthetic */ ILogger access$getLogger$p(SentryTimberIntegration $this) {
        ILogger iLogger = $this.logger;
        if (iLogger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        return iLogger;
    }

    public static final /* synthetic */ void access$setLogger$p(SentryTimberIntegration $this, ILogger iLogger) {
        $this.logger = iLogger;
    }
}

