/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.ndk;

import io.sentry.IScopeObserver;
import io.sentry.SentryOptions;
import io.sentry.android.core.IDebugImagesLoader;
import io.sentry.android.core.NdkHandlerStrategy;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.ndk.DebugImagesLoader;
import io.sentry.android.ndk.NdkScopeObserver;
import io.sentry.android.ndk.SentryNdkUtil;
import io.sentry.ndk.NativeModuleListLoader;
import io.sentry.ndk.NdkOptions;
import io.sentry.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SentryNdk {
    @NotNull
    private static final CountDownLatch loadLibraryLatch = new CountDownLatch(1);

    private SentryNdk() {
    }

    public static void init(@NotNull SentryAndroidOptions options) {
        SentryNdkUtil.addPackage(options.getSdkVersion());
        try {
            if (loadLibraryLatch.await(2000L, TimeUnit.MILLISECONDS)) {
                @NotNull NdkOptions ndkOptions = new NdkOptions((String)Objects.requireNonNull((Object)options.getDsn(), (String)"DSN is required for sentry-ndk"), options.isDebug(), (String)Objects.requireNonNull((Object)options.getOutboxPath(), (String)"outbox path is required for sentry-ndk"), options.getRelease(), options.getEnvironment(), options.getDist(), options.getMaxBreadcrumbs(), options.getNativeSdkName());
                int handlerStrategy = options.getNdkHandlerStrategy();
                if (handlerStrategy == NdkHandlerStrategy.SENTRY_HANDLER_STRATEGY_DEFAULT.getValue()) {
                    ndkOptions.setNdkHandlerStrategy(io.sentry.ndk.NdkHandlerStrategy.SENTRY_HANDLER_STRATEGY_DEFAULT);
                } else if (handlerStrategy == NdkHandlerStrategy.SENTRY_HANDLER_STRATEGY_CHAIN_AT_START.getValue()) {
                    ndkOptions.setNdkHandlerStrategy(io.sentry.ndk.NdkHandlerStrategy.SENTRY_HANDLER_STRATEGY_CHAIN_AT_START);
                }
                io.sentry.ndk.SentryNdk.init((NdkOptions)ndkOptions);
                if (options.isEnableScopeSync()) {
                    options.addScopeObserver((IScopeObserver)new NdkScopeObserver((SentryOptions)options));
                }
            } else {
                throw new IllegalStateException("Timeout waiting for Sentry NDK library to load");
            }
            options.setDebugImagesLoader((IDebugImagesLoader)new DebugImagesLoader(options, new NativeModuleListLoader()));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Thread interrupted while waiting for NDK libs to be loaded", e);
        }
    }

    public static void close() {
        try {
            if (!loadLibraryLatch.await(2000L, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Timeout waiting for Sentry NDK library to load");
            }
            io.sentry.ndk.SentryNdk.close();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Thread interrupted while waiting for NDK libs to be loaded", e);
        }
    }

    static {
        new Thread(() -> {
            try {
                io.sentry.ndk.SentryNdk.loadNativeLibraries();
            }
            catch (Throwable throwable) {
            }
            finally {
                loadLibraryLatch.countDown();
            }
        }, "SentryNdkLoadLibs").start();
    }
}

