/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.ndk;

import io.sentry.IScopeObserver;
import io.sentry.SentryOptions;
import io.sentry.android.core.IDebugImagesLoader;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.ndk.DebugImagesLoader;
import io.sentry.android.ndk.NativeModuleListLoader;
import io.sentry.android.ndk.NdkScopeObserver;
import io.sentry.android.ndk.SentryNdkUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SentryNdk {
    private SentryNdk() {
    }

    private static native void initSentryNative(@NotNull SentryAndroidOptions var0);

    private static native void shutdown();

    public static void init(@NotNull SentryAndroidOptions options) {
        SentryNdkUtil.addPackage(options.getSdkVersion());
        SentryNdk.initSentryNative(options);
        options.addScopeObserver((IScopeObserver)new NdkScopeObserver((SentryOptions)options));
        options.setDebugImagesLoader((IDebugImagesLoader)new DebugImagesLoader(options, new NativeModuleListLoader()));
    }

    public static void close() {
        SentryNdk.shutdown();
    }

    static {
        System.loadLibrary("log");
        System.loadLibrary("sentry");
        System.loadLibrary("sentry-android");
    }
}

