/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.ndk;

import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.IDebugImagesLoader;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.ndk.NativeModuleListLoader;
import io.sentry.protocol.DebugImage;
import io.sentry.util.Objects;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

final class DebugImagesLoader
implements IDebugImagesLoader {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final NativeModuleListLoader moduleListLoader;
    @Nullable
    private static List<DebugImage> debugImages;
    @NotNull
    private static final Object debugImagesLock;

    DebugImagesLoader(@NotNull SentryAndroidOptions options, @NotNull NativeModuleListLoader moduleListLoader) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"The SentryAndroidOptions is required.");
        this.moduleListLoader = (NativeModuleListLoader)Objects.requireNonNull((Object)moduleListLoader, (String)"The NativeModuleListLoader is required.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<DebugImage> loadDebugImages() {
        Object object = debugImagesLock;
        synchronized (object) {
            if (debugImages == null) {
                try {
                    DebugImage[] debugImagesArr = this.moduleListLoader.loadModuleList();
                    if (debugImagesArr != null) {
                        debugImages = Arrays.asList(debugImagesArr);
                        this.options.getLogger().log(SentryLevel.DEBUG, "Debug images loaded: %d", new Object[]{debugImages.size()});
                    }
                }
                catch (Exception e) {
                    this.options.getLogger().log(SentryLevel.ERROR, (Throwable)e, "Failed to load debug images.", new Object[0]);
                }
            }
        }
        return debugImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDebugImages() {
        Object object = debugImagesLock;
        synchronized (object) {
            try {
                this.moduleListLoader.clearModuleList();
                this.options.getLogger().log(SentryLevel.INFO, "Debug images cleared.", new Object[0]);
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, (Throwable)e, "Failed to clear debug images.", new Object[0]);
            }
            debugImages = null;
        }
    }

    @VisibleForTesting
    @Nullable
    List<DebugImage> getCachedDebugImages() {
        return debugImages;
    }

    static {
        debugImagesLock = new Object();
    }
}

