/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Process;
import android.os.SystemClock;
import io.sentry.IContinuousProfiler;
import io.sentry.ILogger;
import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ITransactionProfiler;
import io.sentry.JsonSerializer;
import io.sentry.SentryAppStartProfilingOptions;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.TracesSampler;
import io.sentry.TracesSamplingDecision;
import io.sentry.android.core.AndroidContinuousProfiler;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidOptionsInitializer;
import io.sentry.android.core.AndroidTransactionProfiler;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.EmptySecureContentProvider;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.util.AutoClosableReentrantLock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryPerformanceProvider
extends EmptySecureContentProvider {
    private static final long sdkInitMillis = SystemClock.uptimeMillis();
    @Nullable
    private Application app;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    @TestOnly
    SentryPerformanceProvider(@NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        this.logger = logger;
        this.buildInfoProvider = buildInfoProvider;
    }

    public SentryPerformanceProvider() {
        this.logger = new AndroidLogger();
        this.buildInfoProvider = new BuildInfoProvider(this.logger);
    }

    public boolean onCreate() {
        @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
        this.onAppLaunched(this.getContext(), appStartMetrics);
        this.launchAppStartProfiler(appStartMetrics);
        return true;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        if (SentryPerformanceProvider.class.getName().equals(info.authority)) {
            throw new IllegalStateException("An applicationId is required to fulfill the manifest placeholder.");
        }
        super.attachInfo(context, info);
    }

    @Nullable
    public String getType(@NotNull Uri uri) {
        return null;
    }

    public void shutdown() {
        try (@NotNull ISentryLifecycleToken ignored = AppStartMetrics.staticLock.acquire();){
            IContinuousProfiler appStartContinuousProfiler;
            @Nullable ITransactionProfiler appStartProfiler = AppStartMetrics.getInstance().getAppStartProfiler();
            if (appStartProfiler != null) {
                appStartProfiler.close();
            }
            if ((appStartContinuousProfiler = AppStartMetrics.getInstance().getAppStartContinuousProfiler()) != null) {
                appStartContinuousProfiler.close();
            }
        }
    }

    private void launchAppStartProfiler(@NotNull AppStartMetrics appStartMetrics) {
        @Nullable Context context = this.getContext();
        if (context == null) {
            this.logger.log(SentryLevel.FATAL, "App. Context from ContentProvider is null", new Object[0]);
            return;
        }
        @NotNull File cacheDir = AndroidOptionsInitializer.getCacheDir(context);
        @NotNull File configFile = new File(cacheDir, "app_start_profiling_config");
        if (!configFile.exists() || !configFile.canRead()) {
            return;
        }
        try (@NotNull BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(configFile)));){
            @Nullable SentryAppStartProfilingOptions profilingOptions = (SentryAppStartProfilingOptions)new JsonSerializer(SentryOptions.empty()).deserialize((Reader)reader, SentryAppStartProfilingOptions.class);
            if (profilingOptions == null) {
                this.logger.log(SentryLevel.WARNING, "Unable to deserialize the SentryAppStartProfilingOptions. App start profiling will not start.", new Object[0]);
                return;
            }
            if (profilingOptions.isContinuousProfilingEnabled() && profilingOptions.isStartProfilerOnAppStart()) {
                this.createAndStartContinuousProfiler(context, profilingOptions, appStartMetrics);
                return;
            }
            if (!profilingOptions.isProfilingEnabled()) {
                this.logger.log(SentryLevel.INFO, "Profiling is not enabled. App start profiling will not start.", new Object[0]);
                return;
            }
            if (profilingOptions.isEnableAppStartProfiling()) {
                this.createAndStartTransactionProfiler(context, profilingOptions, appStartMetrics);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.log(SentryLevel.ERROR, "App start profiling config file not found. ", (Throwable)e);
        }
        catch (Throwable e) {
            this.logger.log(SentryLevel.ERROR, "Error reading app start profiling config file. ", e);
        }
    }

    private void createAndStartContinuousProfiler(@NotNull Context context, @NotNull SentryAppStartProfilingOptions profilingOptions, @NotNull AppStartMetrics appStartMetrics) {
        if (!profilingOptions.isContinuousProfileSampled()) {
            this.logger.log(SentryLevel.DEBUG, "App start profiling was not sampled. It will not start.", new Object[0]);
            return;
        }
        @NotNull AndroidContinuousProfiler appStartContinuousProfiler = new AndroidContinuousProfiler(this.buildInfoProvider, new SentryFrameMetricsCollector(context.getApplicationContext(), this.logger, this.buildInfoProvider), this.logger, profilingOptions.getProfilingTracesDirPath(), profilingOptions.getProfilingTracesHz(), (ISentryExecutorService)new SentryExecutorService());
        appStartMetrics.setAppStartProfiler(null);
        appStartMetrics.setAppStartContinuousProfiler(appStartContinuousProfiler);
        this.logger.log(SentryLevel.DEBUG, "App start continuous profiling started.", new Object[0]);
        SentryOptions sentryOptions = SentryOptions.empty();
        sentryOptions.getExperimental().setProfileSessionSampleRate(Double.valueOf(profilingOptions.isContinuousProfileSampled() ? 1.0 : 0.0));
        appStartContinuousProfiler.startProfiler(profilingOptions.getProfileLifecycle(), new TracesSampler(sentryOptions));
    }

    private void createAndStartTransactionProfiler(@NotNull Context context, @NotNull SentryAppStartProfilingOptions profilingOptions, @NotNull AppStartMetrics appStartMetrics) {
        @NotNull TracesSamplingDecision appStartSamplingDecision = new TracesSamplingDecision(Boolean.valueOf(profilingOptions.isTraceSampled()), profilingOptions.getTraceSampleRate(), Boolean.valueOf(profilingOptions.isProfileSampled()), profilingOptions.getProfileSampleRate());
        appStartMetrics.setAppStartSamplingDecision(appStartSamplingDecision);
        if (!appStartSamplingDecision.getProfileSampled().booleanValue() || !appStartSamplingDecision.getSampled().booleanValue()) {
            this.logger.log(SentryLevel.DEBUG, "App start profiling was not sampled. It will not start.", new Object[0]);
            return;
        }
        @NotNull AndroidTransactionProfiler appStartProfiler = new AndroidTransactionProfiler(context, this.buildInfoProvider, new SentryFrameMetricsCollector(context, this.logger, this.buildInfoProvider), this.logger, profilingOptions.getProfilingTracesDirPath(), profilingOptions.isProfilingEnabled(), profilingOptions.getProfilingTracesHz(), (ISentryExecutorService)new SentryExecutorService());
        appStartMetrics.setAppStartContinuousProfiler(null);
        appStartMetrics.setAppStartProfiler(appStartProfiler);
        this.logger.log(SentryLevel.DEBUG, "App start profiling started.", new Object[0]);
        appStartProfiler.start();
    }

    @SuppressLint(value={"NewApi"})
    private void onAppLaunched(@Nullable Context context, @NotNull AppStartMetrics appStartMetrics) {
        @NotNull TimeSpan sdkInitTimeSpan = appStartMetrics.getSdkInitTimeSpan();
        sdkInitTimeSpan.setStartedAt(sdkInitMillis);
        if (this.buildInfoProvider.getSdkInfoVersion() >= 24) {
            @NotNull TimeSpan appStartTimespan = appStartMetrics.getAppStartTimeSpan();
            appStartTimespan.setStartedAt(Process.getStartUptimeMillis());
        }
        if (context instanceof Application) {
            this.app = (Application)context;
        }
        if (this.app == null) {
            return;
        }
        appStartMetrics.registerLifecycleCallbacks(this.app);
    }
}

