/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.gestures;

import android.content.res.Resources;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ScrollView;
import androidx.core.view.ScrollingView;
import io.sentry.android.core.internal.gestures.ViewUtils;
import io.sentry.android.core.internal.util.ClassUtil;
import io.sentry.internal.gestures.GestureTargetLocator;
import io.sentry.internal.gestures.UiElement;
import io.sentry.util.LazyEvaluator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AndroidViewGestureTargetLocator
implements GestureTargetLocator {
    private static final String ORIGIN = "old_view_system";
    @NotNull
    private final LazyEvaluator<Boolean> isAndroidXAvailable;

    public AndroidViewGestureTargetLocator(@NotNull LazyEvaluator<Boolean> isAndroidXAvailable) {
        this.isAndroidXAvailable = isAndroidXAvailable;
    }

    @Nullable
    public UiElement locate(@Nullable Object root, float x, float y, UiElement.Type targetType) {
        if (!(root instanceof View)) {
            return null;
        }
        View view = (View)root;
        if (targetType == UiElement.Type.CLICKABLE && AndroidViewGestureTargetLocator.isViewTappable(view)) {
            return this.createUiElement(view);
        }
        if (targetType == UiElement.Type.SCROLLABLE && AndroidViewGestureTargetLocator.isViewScrollable(view, (Boolean)this.isAndroidXAvailable.getValue())) {
            return this.createUiElement(view);
        }
        return null;
    }

    private UiElement createUiElement(@NotNull View targetView) {
        try {
            String resourceName = ViewUtils.getResourceId(targetView);
            @Nullable String className = ClassUtil.getClassName(targetView);
            return new UiElement((Object)targetView, className, resourceName, null, ORIGIN);
        }
        catch (Resources.NotFoundException ignored) {
            return null;
        }
    }

    private static boolean isViewTappable(@NotNull View view) {
        return view.isClickable() && view.getVisibility() == 0;
    }

    private static boolean isViewScrollable(@NotNull View view, boolean isAndroidXAvailable) {
        return (AndroidViewGestureTargetLocator.isJetpackScrollingView(view, isAndroidXAvailable) || AbsListView.class.isAssignableFrom(view.getClass()) || ScrollView.class.isAssignableFrom(view.getClass())) && view.getVisibility() == 0;
    }

    private static boolean isJetpackScrollingView(@NotNull View view, boolean isAndroidXAvailable) {
        if (!isAndroidXAvailable) {
            return false;
        }
        return ScrollingView.class.isAssignableFrom(view.getClass());
    }
}

