/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.content.Context;
import androidx.annotation.RequiresApi;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.cache.EnvelopeCache;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.hints.BlockingFlushHint;
import io.sentry.protocol.SentryId;
import io.sentry.transport.ICurrentDateProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class ApplicationExitInfoHistoryDispatcher
implements Runnable {
    static final long NINETY_DAYS_THRESHOLD = TimeUnit.DAYS.toMillis(91L);
    @NotNull
    private final Context context;
    @NotNull
    private final IScopes scopes;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final ApplicationExitInfoPolicy policy;
    private final long threshold;

    ApplicationExitInfoHistoryDispatcher(@NotNull Context context, @NotNull IScopes scopes, @NotNull SentryAndroidOptions options, @NotNull ICurrentDateProvider dateProvider, @NotNull ApplicationExitInfoPolicy policy) {
        this.context = ContextUtils.getApplicationContext(context);
        this.scopes = scopes;
        this.options = options;
        this.policy = policy;
        this.threshold = dateProvider.getCurrentTimeMillis() - NINETY_DAYS_THRESHOLD;
    }

    @Override
    @RequiresApi(api=30)
    public void run() {
        ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
        if (activityManager == null) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to retrieve ActivityManager.", new Object[0]);
            return;
        }
        List applicationExitInfoList = activityManager.getHistoricalProcessExitReasons(null, 0, 0);
        if (applicationExitInfoList.isEmpty()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "No records in historical exit reasons.", new Object[0]);
            return;
        }
        this.waitPreviousSessionFlush();
        ArrayList<ApplicationExitInfo> exitInfos = new ArrayList<ApplicationExitInfo>(applicationExitInfoList);
        @Nullable Long lastReportedTimestamp = this.policy.getLastReportedTimestamp();
        ApplicationExitInfo latest = this.removeLatest(exitInfos);
        if (latest == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "No %ss have been found in the historical exit reasons list.", new Object[]{this.policy.getLabel()});
            return;
        }
        if (latest.getTimestamp() < this.threshold) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Latest %s happened too long ago, returning early.", new Object[]{this.policy.getLabel()});
            return;
        }
        if (lastReportedTimestamp != null && latest.getTimestamp() <= lastReportedTimestamp) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Latest %s has already been reported, returning early.", new Object[]{this.policy.getLabel()});
            return;
        }
        if (this.policy.shouldReportHistorical()) {
            this.reportHistorical(exitInfos, lastReportedTimestamp);
        }
        this.report(latest, true);
    }

    private void waitPreviousSessionFlush() {
        IEnvelopeCache cache = this.options.getEnvelopeDiskCache();
        if (cache instanceof EnvelopeCache && this.options.isEnableAutoSessionTracking() && !((EnvelopeCache)cache).waitPreviousSessionFlush()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Timed out waiting to flush previous session to its own file.", new Object[0]);
            ((EnvelopeCache)cache).flushPreviousSession();
        }
    }

    @RequiresApi(api=30)
    @Nullable
    private ApplicationExitInfo removeLatest(@NotNull List<ApplicationExitInfo> exitInfos) {
        Iterator<ApplicationExitInfo> it = exitInfos.iterator();
        while (it.hasNext()) {
            ApplicationExitInfo applicationExitInfo = it.next();
            if (applicationExitInfo.getReason() != this.policy.getTargetReason()) continue;
            it.remove();
            return applicationExitInfo;
        }
        return null;
    }

    @RequiresApi(api=30)
    private void reportHistorical(@NotNull List<ApplicationExitInfo> exitInfos, @Nullable Long lastReportedTimestamp) {
        Collections.reverse(exitInfos);
        for (ApplicationExitInfo applicationExitInfo : exitInfos) {
            if (applicationExitInfo.getReason() != this.policy.getTargetReason()) continue;
            if (applicationExitInfo.getTimestamp() < this.threshold) {
                this.options.getLogger().log(SentryLevel.DEBUG, "%s happened too long ago %s.", new Object[]{this.policy.getLabel(), applicationExitInfo});
                continue;
            }
            if (lastReportedTimestamp != null && applicationExitInfo.getTimestamp() <= lastReportedTimestamp) {
                this.options.getLogger().log(SentryLevel.DEBUG, "%s has already been reported %s.", new Object[]{this.policy.getLabel(), applicationExitInfo});
                continue;
            }
            this.report(applicationExitInfo, false);
        }
    }

    private void report(@NotNull ApplicationExitInfo exitInfo, boolean enrich) {
        BlockingFlushHint flushHint;
        @Nullable Report report = this.policy.buildReport(exitInfo, enrich);
        if (report == null) {
            return;
        }
        @NotNull SentryId sentryId = this.scopes.captureEvent(report.getEvent(), report.getHint());
        boolean isEventDropped = sentryId.equals((Object)SentryId.EMPTY_ID);
        if (!isEventDropped && (flushHint = report.getFlushHint()) != null && !flushHint.waitFlush()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Timed out waiting to flush %s event to disk. Event: %s", new Object[]{this.policy.getLabel(), report.getEvent().getEventId()});
        }
    }

    static interface ApplicationExitInfoPolicy {
        @NotNull
        public String getLabel();

        public int getTargetReason();

        public boolean shouldReportHistorical();

        @Nullable
        public Long getLastReportedTimestamp();

        @Nullable
        public Report buildReport(@NotNull ApplicationExitInfo var1, boolean var2);
    }

    public static final class Report {
        @NotNull
        private final SentryEvent event;
        @NotNull
        private final Hint hint;
        @Nullable
        private final BlockingFlushHint flushHint;

        Report(@NotNull SentryEvent event, @NotNull Hint hint, @Nullable BlockingFlushHint flushHint) {
            this.event = event;
            this.hint = hint;
            this.flushHint = flushHint;
        }

        @NotNull
        public SentryEvent getEvent() {
            return this.event;
        }

        @NotNull
        public Hint getHint() {
            return this.hint;
        }

        @Nullable
        public BlockingFlushHint getFlushHint() {
            return this.flushHint;
        }
    }
}

