/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.cache;

import io.sentry.Hint;
import io.sentry.SentryEnvelope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.android.core.AnrV2Integration;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidCurrentDateProvider;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.cache.EnvelopeCache;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.FileUtils;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AndroidEnvelopeCache
extends EnvelopeCache {
    public static final String LAST_ANR_REPORT = "last_anr_report";
    @NotNull
    private final ICurrentDateProvider currentDateProvider;

    public AndroidEnvelopeCache(@NotNull SentryAndroidOptions options) {
        this(options, AndroidCurrentDateProvider.getInstance());
    }

    AndroidEnvelopeCache(@NotNull SentryAndroidOptions options, @NotNull ICurrentDateProvider currentDateProvider) {
        super((SentryOptions)options, (String)Objects.requireNonNull((Object)options.getCacheDirPath(), (String)"cacheDirPath must not be null"), options.getMaxCacheItems());
        this.currentDateProvider = currentDateProvider;
    }

    public void store(@NotNull SentryEnvelope envelope, @NotNull Hint hint) {
        this.storeInternalAndroid(envelope, hint);
    }

    public boolean storeEnvelope(@NotNull SentryEnvelope envelope, @NotNull Hint hint) {
        return this.storeInternalAndroid(envelope, hint);
    }

    private boolean storeInternalAndroid(@NotNull SentryEnvelope envelope, @NotNull Hint hint) {
        long timeSinceSdkInit;
        boolean didStore = super.storeEnvelope(envelope, hint);
        SentryAndroidOptions options = (SentryAndroidOptions)this.options;
        TimeSpan sdkInitTimeSpan = AppStartMetrics.getInstance().getSdkInitTimeSpan();
        if (HintUtils.hasType((Hint)hint, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class) && sdkInitTimeSpan.hasStarted() && (timeSinceSdkInit = this.currentDateProvider.getCurrentTimeMillis() - sdkInitTimeSpan.getStartUptimeMs()) <= options.getStartupCrashDurationThresholdMillis()) {
            options.getLogger().log(SentryLevel.DEBUG, "Startup Crash detected %d milliseconds after SDK init. Writing a startup crash marker file to disk.", new Object[]{timeSinceSdkInit});
            this.writeStartupCrashMarkerFile();
        }
        HintUtils.runIfHasType((Hint)hint, AnrV2Integration.AnrV2Hint.class, anrHint -> {
            @Nullable Long timestamp = anrHint.timestamp();
            options.getLogger().log(SentryLevel.DEBUG, "Writing last reported ANR marker with timestamp %d", new Object[]{timestamp});
            this.writeLastReportedAnrMarker(timestamp);
        });
        return didStore;
    }

    @TestOnly
    @NotNull
    public File getDirectory() {
        return this.directory;
    }

    private void writeStartupCrashMarkerFile() {
        String outboxPath = this.options.getOutboxPath();
        if (outboxPath == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Outbox path is null, the startup crash marker file will not be written", new Object[0]);
            return;
        }
        File crashMarkerFile = new File(outboxPath, "startup_crash");
        try {
            crashMarkerFile.createNewFile();
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error writing the startup crash marker file to the disk", e);
        }
    }

    public static boolean hasStartupCrashMarker(@NotNull SentryOptions options) {
        String outboxPath = options.getOutboxPath();
        if (outboxPath == null) {
            options.getLogger().log(SentryLevel.DEBUG, "Outbox path is null, the startup crash marker file does not exist", new Object[0]);
            return false;
        }
        File crashMarkerFile = new File(outboxPath, "startup_crash");
        try {
            boolean exists = crashMarkerFile.exists();
            if (exists && !crashMarkerFile.delete()) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to delete the startup crash marker file. %s.", new Object[]{crashMarkerFile.getAbsolutePath()});
            }
            return exists;
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Error reading/deleting the startup crash marker file on the disk", e);
            return false;
        }
    }

    @Nullable
    public static Long lastReportedAnr(@NotNull SentryOptions options) {
        String cacheDirPath = (String)Objects.requireNonNull((Object)options.getCacheDirPath(), (String)"Cache dir path should be set for getting ANRs reported");
        File lastAnrMarker = new File(cacheDirPath, LAST_ANR_REPORT);
        try {
            String content = FileUtils.readText((File)lastAnrMarker);
            return content.equals("null") ? null : Long.valueOf(Long.parseLong(content.trim()));
        }
        catch (Throwable e) {
            if (e instanceof FileNotFoundException) {
                options.getLogger().log(SentryLevel.DEBUG, "Last ANR marker does not exist. %s.", new Object[]{lastAnrMarker.getAbsolutePath()});
            } else {
                options.getLogger().log(SentryLevel.ERROR, "Error reading last ANR marker", e);
            }
            return null;
        }
    }

    private void writeLastReportedAnrMarker(@Nullable Long timestamp) {
        String cacheDirPath = this.options.getCacheDirPath();
        if (cacheDirPath == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Cache dir path is null, the ANR marker will not be written", new Object[0]);
            return;
        }
        File anrMarker = new File(cacheDirPath, LAST_ANR_REPORT);
        try (FileOutputStream outputStream = new FileOutputStream(anrMarker);){
            ((OutputStream)outputStream).write(String.valueOf(timestamp).getBytes(UTF_8));
            outputStream.flush();
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error writing the ANR marker to the disk", e);
        }
    }
}

