/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.util.Log;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AndroidFatalLogger
implements ILogger {
    @NotNull
    private final String tag;

    public AndroidFatalLogger() {
        this("Sentry");
    }

    public AndroidFatalLogger(@NotNull String tag) {
        this.tag = tag;
    }

    public void log(@NotNull SentryLevel level, @NotNull String message, Object ... args) {
        if (args == null || args.length == 0) {
            Log.println((int)this.toLogcatLevel(level), (String)this.tag, (String)message);
        } else {
            Log.println((int)this.toLogcatLevel(level), (String)this.tag, (String)String.format(message, args));
        }
    }

    public void log(@NotNull SentryLevel level, @Nullable Throwable throwable, @NotNull String message, Object ... args) {
        if (args == null || args.length == 0) {
            this.log(level, message, throwable);
        } else {
            this.log(level, String.format(message, args), throwable);
        }
    }

    public void log(@NotNull SentryLevel level, @NotNull String message, @Nullable Throwable throwable) {
        Log.wtf((String)this.tag, (String)message, (Throwable)throwable);
    }

    public boolean isEnabled(@Nullable SentryLevel level) {
        return true;
    }

    private int toLogcatLevel(@NotNull SentryLevel sentryLevel) {
        return 7;
    }
}

