/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import io.sentry.Sentry;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.EmptySecureContentProvider;
import io.sentry.android.core.ManifestMetadataReader;
import io.sentry.android.core.SentryAndroid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryInitProvider
extends EmptySecureContentProvider {
    public boolean onCreate() {
        AndroidLogger logger = new AndroidLogger();
        Context context = this.getContext();
        if (context == null) {
            logger.log(SentryLevel.FATAL, "App. Context from ContentProvider is null", new Object[0]);
            return false;
        }
        if (ManifestMetadataReader.isAutoInit(context, logger) && !ContextUtils.appIsLibraryForComposePreview(context)) {
            SentryAndroid.init(context, logger);
            SentryIntegrationPackageStorage.getInstance().addIntegration("AutoInit");
        }
        return true;
    }

    public void shutdown() {
        Sentry.close();
    }

    public void attachInfo(@NotNull Context context, @NotNull ProviderInfo info) {
        if (SentryInitProvider.class.getName().equals(info.authority)) {
            throw new IllegalStateException("An applicationId is required to fulfill the manifest placeholder.");
        }
        super.attachInfo(context, info);
    }

    @Nullable
    public String getType(@NotNull Uri uri) {
        return null;
    }
}

