/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.util.Log;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AndroidLogger
implements ILogger {
    @NotNull
    private final String tag;

    public AndroidLogger() {
        this("Sentry");
    }

    public AndroidLogger(@NotNull String tag) {
        this.tag = tag;
    }

    public void log(@NotNull SentryLevel level, @NotNull String message, Object ... args) {
        if (args == null || args.length == 0) {
            Log.println((int)this.toLogcatLevel(level), (String)this.tag, (String)message);
        } else {
            Log.println((int)this.toLogcatLevel(level), (String)this.tag, (String)String.format(message, args));
        }
    }

    public void log(@NotNull SentryLevel level, @Nullable Throwable throwable, @NotNull String message, Object ... args) {
        if (args == null || args.length == 0) {
            this.log(level, message, throwable);
        } else {
            this.log(level, String.format(message, args), throwable);
        }
    }

    public void log(@NotNull SentryLevel level, @NotNull String message, @Nullable Throwable throwable) {
        switch (level) {
            case INFO: {
                Log.i((String)this.tag, (String)message, (Throwable)throwable);
                break;
            }
            case WARNING: {
                Log.w((String)this.tag, (String)message, (Throwable)throwable);
                break;
            }
            case ERROR: {
                Log.e((String)this.tag, (String)message, (Throwable)throwable);
                break;
            }
            case FATAL: {
                Log.wtf((String)this.tag, (String)message, (Throwable)throwable);
                break;
            }
            default: {
                Log.d((String)this.tag, (String)message, (Throwable)throwable);
            }
        }
    }

    public boolean isEnabled(@Nullable SentryLevel level) {
        return true;
    }

    private int toLogcatLevel(@NotNull SentryLevel sentryLevel) {
        switch (sentryLevel) {
            case INFO: {
                return 4;
            }
            case WARNING: {
                return 5;
            }
            case FATAL: {
                return 7;
            }
        }
        return 3;
    }
}

