/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.annotation.NonNull;
import io.sentry.FullyDisplayedReporter;
import io.sentry.IScope;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Instrumenter;
import io.sentry.Integration;
import io.sentry.MeasurementUnit;
import io.sentry.NoOpTransaction;
import io.sentry.SentryDate;
import io.sentry.SentryLevel;
import io.sentry.SentryNanotimeDate;
import io.sentry.SentryOptions;
import io.sentry.SpanOptions;
import io.sentry.SpanStatus;
import io.sentry.TracesSamplingDecision;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.AndroidDateUtils;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.ClassUtil;
import io.sentry.android.core.internal.util.FirstDrawDoneListener;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import io.sentry.util.TracingUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ActivityLifecycleIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    static final String UI_LOAD_OP = "ui.load";
    static final String APP_START_WARM = "app.start.warm";
    static final String APP_START_COLD = "app.start.cold";
    static final String TTID_OP = "ui.load.initial_display";
    static final String TTFD_OP = "ui.load.full_display";
    static final long TTFD_TIMEOUT_MILLIS = 30000L;
    private static final String TRACE_ORIGIN = "auto.ui.activity";
    @NotNull
    private final Application application;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @Nullable
    private IScopes scopes;
    @Nullable
    private SentryAndroidOptions options;
    private boolean performanceEnabled = false;
    private boolean timeToFullDisplaySpanEnabled = false;
    private boolean isAllActivityCallbacksAvailable;
    private boolean firstActivityCreated = false;
    @Nullable
    private FullyDisplayedReporter fullyDisplayedReporter = null;
    @Nullable
    private ISpan appStartSpan;
    @NotNull
    private final WeakHashMap<Activity, ISpan> ttidSpanMap = new WeakHashMap();
    @NotNull
    private final WeakHashMap<Activity, ISpan> ttfdSpanMap = new WeakHashMap();
    @NotNull
    private SentryDate lastPausedTime = new SentryNanotimeDate(new Date(0L), 0L);
    @NotNull
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    @Nullable
    private Future<?> ttfdAutoCloseFuture = null;
    @NotNull
    private final WeakHashMap<Activity, ITransaction> activitiesWithOngoingTransactions = new WeakHashMap();
    @NotNull
    private final ActivityFramesTracker activityFramesTracker;
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    public ActivityLifecycleIntegration(@NotNull Application application, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ActivityFramesTracker activityFramesTracker) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
        this.activityFramesTracker = (ActivityFramesTracker)Objects.requireNonNull((Object)activityFramesTracker, (String)"ActivityFramesTracker is required");
        if (buildInfoProvider.getSdkInfoVersion() >= 29) {
            this.isAllActivityCallbacksAvailable = true;
        }
    }

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.performanceEnabled = this.isPerformanceEnabled(this.options);
        this.fullyDisplayedReporter = this.options.getFullyDisplayedReporter();
        this.timeToFullDisplaySpanEnabled = this.options.isEnableTimeToFullDisplayTracing();
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration installed.", new Object[0]);
        IntegrationUtils.addIntegrationToSdkVersion((String)"ActivityLifecycle");
    }

    private boolean isPerformanceEnabled(@NotNull SentryAndroidOptions options) {
        return options.isTracingEnabled() && options.isEnableAutoActivityLifecycleTracing();
    }

    @Override
    public void close() throws IOException {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration removed.", new Object[0]);
        }
        this.activityFramesTracker.stop();
    }

    @NotNull
    private String getActivityName(@NotNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    private void stopPreviousTransactions() {
        for (Map.Entry<Activity, ITransaction> entry : this.activitiesWithOngoingTransactions.entrySet()) {
            ITransaction transaction = entry.getValue();
            ISpan ttidSpan = this.ttidSpanMap.get(entry.getKey());
            ISpan ttfdSpan = this.ttfdSpanMap.get(entry.getKey());
            this.finishTransaction(transaction, ttidSpan, ttfdSpan);
        }
    }

    private void startTracing(@NotNull Activity activity) {
        WeakReference<Activity> weakActivity = new WeakReference<Activity>(activity);
        if (this.scopes != null && !this.isRunningTransactionOrTrace(activity)) {
            if (!this.performanceEnabled) {
                this.activitiesWithOngoingTransactions.put(activity, (ITransaction)NoOpTransaction.getInstance());
                TracingUtils.startNewTrace((IScopes)this.scopes);
            } else {
                TracesSamplingDecision appStartSamplingDecision;
                SentryDate ttidStartTime;
                Boolean coldStart;
                SentryDate appStartTime;
                this.stopPreviousTransactions();
                String activityName = this.getActivityName(activity);
                @NotNull TimeSpan appStartTimeSpan = AppStartMetrics.getInstance().getAppStartTimeSpanWithFallback(this.options);
                boolean foregroundImportance = ContextUtils.isForegroundImportance();
                if (foregroundImportance && appStartTimeSpan.hasStarted()) {
                    appStartTime = appStartTimeSpan.getStartTimestamp();
                    coldStart = AppStartMetrics.getInstance().getAppStartType() == AppStartMetrics.AppStartType.COLD;
                } else {
                    appStartTime = null;
                    coldStart = null;
                }
                TransactionOptions transactionOptions = new TransactionOptions();
                transactionOptions.setDeadlineTimeout(Long.valueOf(30000L));
                if (this.options.isEnableActivityLifecycleTracingAutoFinish()) {
                    transactionOptions.setIdleTimeout(this.options.getIdleTimeout());
                    transactionOptions.setTrimEnd(true);
                }
                transactionOptions.setWaitForChildren(true);
                transactionOptions.setTransactionFinishedCallback(finishingTransaction -> {
                    @Nullable Activity unwrappedActivity = (Activity)weakActivity.get();
                    if (unwrappedActivity != null) {
                        this.activityFramesTracker.setMetrics(unwrappedActivity, finishingTransaction.getEventId());
                    } else if (this.options != null) {
                        this.options.getLogger().log(SentryLevel.WARNING, "Unable to track activity frames as the Activity %s has been destroyed.", new Object[]{activityName});
                    }
                });
                if (!this.firstActivityCreated && appStartTime != null && coldStart != null) {
                    ttidStartTime = appStartTime;
                    appStartSamplingDecision = AppStartMetrics.getInstance().getAppStartSamplingDecision();
                    AppStartMetrics.getInstance().setAppStartSamplingDecision(null);
                } else {
                    ttidStartTime = this.lastPausedTime;
                    appStartSamplingDecision = null;
                }
                transactionOptions.setStartTimestamp(ttidStartTime);
                transactionOptions.setAppStartTransaction(appStartSamplingDecision != null);
                this.setSpanOrigin((SpanOptions)transactionOptions);
                ITransaction transaction = this.scopes.startTransaction(new TransactionContext(activityName, TransactionNameSource.COMPONENT, UI_LOAD_OP, appStartSamplingDecision), transactionOptions);
                SpanOptions spanOptions = new SpanOptions();
                this.setSpanOrigin(spanOptions);
                if (!this.firstActivityCreated && appStartTime != null && coldStart != null) {
                    this.appStartSpan = transaction.startChild(this.getAppStartOp(coldStart), this.getAppStartDesc(coldStart), appStartTime, Instrumenter.SENTRY, spanOptions);
                    this.finishAppStartSpan();
                }
                @NotNull ISpan ttidSpan = transaction.startChild(TTID_OP, this.getTtidDesc(activityName), ttidStartTime, Instrumenter.SENTRY, spanOptions);
                this.ttidSpanMap.put(activity, ttidSpan);
                if (this.timeToFullDisplaySpanEnabled && this.fullyDisplayedReporter != null && this.options != null) {
                    @NotNull ISpan ttfdSpan = transaction.startChild(TTFD_OP, this.getTtfdDesc(activityName), ttidStartTime, Instrumenter.SENTRY, spanOptions);
                    try {
                        this.ttfdSpanMap.put(activity, ttfdSpan);
                        this.ttfdAutoCloseFuture = this.options.getExecutorService().schedule(() -> this.finishExceededTtfdSpan(ttfdSpan, ttidSpan), 30000L);
                    }
                    catch (RejectedExecutionException e) {
                        this.options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Time to full display span will not be finished automatically. Did you call Sentry.close()?", (Throwable)e);
                    }
                }
                this.scopes.configureScope(scope -> this.applyScope(scope, transaction));
                this.activitiesWithOngoingTransactions.put(activity, transaction);
            }
        }
    }

    private void setSpanOrigin(@NotNull SpanOptions spanOptions) {
        spanOptions.setOrigin(TRACE_ORIGIN);
    }

    @VisibleForTesting
    void applyScope(@NotNull IScope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == null) {
                scope.setTransaction(transaction);
            } else if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction '%s' won't be bound to the Scope since there's one already in there.", new Object[]{transaction.getName()});
            }
        });
    }

    @VisibleForTesting
    void clearScope(@NotNull IScope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == transaction) {
                scope.clearTransaction();
            }
        });
    }

    private boolean isRunningTransactionOrTrace(@NotNull Activity activity) {
        return this.activitiesWithOngoingTransactions.containsKey(activity);
    }

    private void stopTracing(@NotNull Activity activity, boolean shouldFinishTracing) {
        if (this.performanceEnabled && shouldFinishTracing) {
            ITransaction transaction = this.activitiesWithOngoingTransactions.get(activity);
            this.finishTransaction(transaction, null, null);
        }
    }

    private void finishTransaction(@Nullable ITransaction transaction, @Nullable ISpan ttidSpan, @Nullable ISpan ttfdSpan) {
        if (transaction != null) {
            if (transaction.isFinished()) {
                return;
            }
            this.finishSpan(ttidSpan, SpanStatus.DEADLINE_EXCEEDED);
            this.finishExceededTtfdSpan(ttfdSpan, ttidSpan);
            this.cancelTtfdAutoClose();
            SpanStatus status = transaction.getStatus();
            if (status == null) {
                status = SpanStatus.OK;
            }
            transaction.finish(status);
            if (this.scopes != null) {
                this.scopes.configureScope(scope -> this.clearScope(scope, transaction));
            }
        }
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            this.setColdStart(savedInstanceState);
            if (this.scopes != null && this.options != null && this.options.isEnableScreenTracking()) {
                @Nullable String activityClassName = ClassUtil.getClassName(activity);
                this.scopes.configureScope(scope -> scope.setScreen(activityClassName));
            }
            this.startTracing(activity);
            @Nullable ISpan ttfdSpan = this.ttfdSpanMap.get(activity);
            this.firstActivityCreated = true;
            if (this.performanceEnabled && ttfdSpan != null && this.fullyDisplayedReporter != null) {
                this.fullyDisplayedReporter.registerFullyDrawnListener(() -> this.onFullFrameDrawn(ttfdSpan));
            }
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (this.performanceEnabled) {
                this.activityFramesTracker.addActivity(activity);
            }
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (this.performanceEnabled) {
                @Nullable ISpan ttidSpan = this.ttidSpanMap.get(activity);
                @Nullable ISpan ttfdSpan = this.ttfdSpanMap.get(activity);
                View rootView = activity.findViewById(0x1020002);
                if (rootView != null) {
                    FirstDrawDoneListener.registerForNextDraw(rootView, () -> this.onFirstFrameDrawn(ttfdSpan, ttidSpan), this.buildInfoProvider);
                } else {
                    this.mainHandler.post(() -> this.onFirstFrameDrawn(ttfdSpan, ttidSpan));
                }
            }
        }
    }

    public void onActivityPostResumed(@NonNull Activity activity) {
    }

    public void onActivityPrePaused(@NonNull Activity activity) {
        if (this.isAllActivityCallbacksAvailable) {
            this.firstActivityCreated = true;
            this.lastPausedTime = this.scopes == null ? AndroidDateUtils.getCurrentSentryDateTime() : this.scopes.getOptions().getDateProvider().now();
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (!this.isAllActivityCallbacksAvailable) {
                this.firstActivityCreated = true;
                this.lastPausedTime = this.scopes == null ? AndroidDateUtils.getCurrentSentryDateTime() : this.scopes.getOptions().getDateProvider().now();
            }
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (this.performanceEnabled) {
                this.finishSpan(this.appStartSpan, SpanStatus.CANCELLED);
                ISpan ttidSpan = this.ttidSpanMap.get(activity);
                ISpan ttfdSpan = this.ttfdSpanMap.get(activity);
                this.finishSpan(ttidSpan, SpanStatus.DEADLINE_EXCEEDED);
                this.finishExceededTtfdSpan(ttfdSpan, ttidSpan);
                this.cancelTtfdAutoClose();
                this.stopTracing(activity, true);
                this.appStartSpan = null;
                this.ttidSpanMap.remove(activity);
                this.ttfdSpanMap.remove(activity);
            }
            this.activitiesWithOngoingTransactions.remove(activity);
        }
    }

    private void finishSpan(@Nullable ISpan span) {
        if (span != null && !span.isFinished()) {
            span.finish();
        }
    }

    private void finishSpan(@Nullable ISpan span, @NotNull SentryDate endTimestamp) {
        this.finishSpan(span, endTimestamp, null);
    }

    private void finishSpan(@Nullable ISpan span, @NotNull SentryDate endTimestamp, @Nullable SpanStatus spanStatus) {
        if (span != null && !span.isFinished()) {
            @NotNull SpanStatus status = spanStatus != null ? spanStatus : (span.getStatus() != null ? span.getStatus() : SpanStatus.OK);
            span.finish(status, endTimestamp);
        }
    }

    private void finishSpan(@Nullable ISpan span, @NotNull SpanStatus status) {
        if (span != null && !span.isFinished()) {
            span.finish(status);
        }
    }

    private void cancelTtfdAutoClose() {
        if (this.ttfdAutoCloseFuture != null) {
            this.ttfdAutoCloseFuture.cancel(false);
            this.ttfdAutoCloseFuture = null;
        }
    }

    private void onFirstFrameDrawn(@Nullable ISpan ttfdSpan, @Nullable ISpan ttidSpan) {
        @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
        @NotNull TimeSpan appStartTimeSpan = appStartMetrics.getAppStartTimeSpan();
        @NotNull TimeSpan sdkInitTimeSpan = appStartMetrics.getSdkInitTimeSpan();
        if (appStartTimeSpan.hasStarted() && appStartTimeSpan.hasNotStopped()) {
            appStartTimeSpan.stop();
        }
        if (sdkInitTimeSpan.hasStarted() && sdkInitTimeSpan.hasNotStopped()) {
            sdkInitTimeSpan.stop();
        }
        this.finishAppStartSpan();
        if (this.options != null && ttidSpan != null) {
            SentryDate endDate = this.options.getDateProvider().now();
            long durationNanos = endDate.diff(ttidSpan.getStartDate());
            long durationMillis = TimeUnit.NANOSECONDS.toMillis(durationNanos);
            ttidSpan.setMeasurement("time_to_initial_display", (Number)durationMillis, (MeasurementUnit)MeasurementUnit.Duration.MILLISECOND);
            if (ttfdSpan != null && ttfdSpan.isFinished()) {
                ttfdSpan.updateEndDate(endDate);
                ttidSpan.setMeasurement("time_to_full_display", (Number)durationMillis, (MeasurementUnit)MeasurementUnit.Duration.MILLISECOND);
            }
            this.finishSpan(ttidSpan, endDate);
        } else {
            this.finishSpan(ttidSpan);
        }
    }

    private void onFullFrameDrawn(@Nullable ISpan ttfdSpan) {
        if (this.options != null && ttfdSpan != null) {
            SentryDate endDate = this.options.getDateProvider().now();
            long durationNanos = endDate.diff(ttfdSpan.getStartDate());
            long durationMillis = TimeUnit.NANOSECONDS.toMillis(durationNanos);
            ttfdSpan.setMeasurement("time_to_full_display", (Number)durationMillis, (MeasurementUnit)MeasurementUnit.Duration.MILLISECOND);
            this.finishSpan(ttfdSpan, endDate);
        } else {
            this.finishSpan(ttfdSpan);
        }
        this.cancelTtfdAutoClose();
    }

    private void finishExceededTtfdSpan(@Nullable ISpan ttfdSpan, @Nullable ISpan ttidSpan) {
        if (ttfdSpan == null || ttfdSpan.isFinished()) {
            return;
        }
        ttfdSpan.setDescription(this.getExceededTtfdDesc(ttfdSpan));
        @Nullable SentryDate ttidEndDate = ttidSpan != null ? ttidSpan.getFinishDate() : null;
        @NotNull SentryDate ttfdEndDate = ttidEndDate != null ? ttidEndDate : ttfdSpan.getStartDate();
        this.finishSpan(ttfdSpan, ttfdEndDate, SpanStatus.DEADLINE_EXCEEDED);
    }

    @TestOnly
    @NotNull
    WeakHashMap<Activity, ITransaction> getActivitiesWithOngoingTransactions() {
        return this.activitiesWithOngoingTransactions;
    }

    @TestOnly
    @NotNull
    ActivityFramesTracker getActivityFramesTracker() {
        return this.activityFramesTracker;
    }

    @TestOnly
    @Nullable
    ISpan getAppStartSpan() {
        return this.appStartSpan;
    }

    @TestOnly
    @NotNull
    WeakHashMap<Activity, ISpan> getTtidSpanMap() {
        return this.ttidSpanMap;
    }

    @TestOnly
    @NotNull
    WeakHashMap<Activity, ISpan> getTtfdSpanMap() {
        return this.ttfdSpanMap;
    }

    private void setColdStart(@Nullable Bundle savedInstanceState) {
        if (this.scopes != null && this.lastPausedTime.nanoTimestamp() == 0L) {
            this.lastPausedTime = this.scopes.getOptions().getDateProvider().now();
        } else if (this.lastPausedTime.nanoTimestamp() == 0L) {
            this.lastPausedTime = AndroidDateUtils.getCurrentSentryDateTime();
        }
        if (!this.firstActivityCreated) {
            @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
            if (this.options != null && !this.options.isEnablePerformanceV2() || appStartMetrics.getAppStartType() == AppStartMetrics.AppStartType.UNKNOWN) {
                appStartMetrics.setAppStartType(savedInstanceState == null ? AppStartMetrics.AppStartType.COLD : AppStartMetrics.AppStartType.WARM);
            }
        }
    }

    @NotNull
    private String getTtidDesc(@NotNull String activityName) {
        return activityName + " initial display";
    }

    @NotNull
    private String getTtfdDesc(@NotNull String activityName) {
        return activityName + " full display";
    }

    @NotNull
    private String getExceededTtfdDesc(@NotNull ISpan ttfdSpan) {
        @Nullable String ttfdCurrentDescription = ttfdSpan.getDescription();
        if (ttfdCurrentDescription != null && ttfdCurrentDescription.endsWith(" - Deadline Exceeded")) {
            return ttfdCurrentDescription;
        }
        return ttfdSpan.getDescription() + " - Deadline Exceeded";
    }

    @NotNull
    private String getAppStartDesc(boolean coldStart) {
        if (coldStart) {
            return "Cold Start";
        }
        return "Warm Start";
    }

    @NotNull
    private String getAppStartOp(boolean coldStart) {
        if (coldStart) {
            return APP_START_COLD;
        }
        return APP_START_WARM;
    }

    private void finishAppStartSpan() {
        @Nullable SentryDate appStartEndTime = AppStartMetrics.getInstance().getAppStartTimeSpanWithFallback(this.options).getProjectedStopTimestamp();
        if (this.performanceEnabled && appStartEndTime != null) {
            this.finishSpan(this.appStartSpan, appStartEndTime);
        }
    }
}

