/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.DataCategory;
import io.sentry.IConnectionStatusProvider;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.Integration;
import io.sentry.SendCachedEnvelopeFireAndForgetIntegration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.transport.RateLimiter;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SendCachedEnvelopeIntegration
implements Integration,
IConnectionStatusProvider.IConnectionStatusObserver,
Closeable {
    @NotNull
    private final SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory factory;
    @NotNull
    private final LazyEvaluator<Boolean> startupCrashMarkerEvaluator;
    private final AtomicBoolean startupCrashHandled = new AtomicBoolean(false);
    @Nullable
    private IConnectionStatusProvider connectionStatusProvider;
    @Nullable
    private IScopes scopes;
    @Nullable
    private SentryAndroidOptions options;
    @Nullable
    private SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForget sender;
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    public SendCachedEnvelopeIntegration(@NotNull SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory factory, @NotNull LazyEvaluator<Boolean> startupCrashMarkerEvaluator) {
        this.factory = (SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory)Objects.requireNonNull((Object)factory, (String)"SendFireAndForgetFactory is required");
        this.startupCrashMarkerEvaluator = startupCrashMarkerEvaluator;
    }

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        String cachedDir = options.getCacheDirPath();
        if (!this.factory.hasValidPath(cachedDir, options.getLogger())) {
            options.getLogger().log(SentryLevel.ERROR, "No cache dir path is defined in options.", new Object[0]);
            return;
        }
        this.sendCachedEnvelopes(scopes, this.options);
    }

    @Override
    public void close() throws IOException {
        this.isClosed.set(true);
        if (this.connectionStatusProvider != null) {
            this.connectionStatusProvider.removeConnectionStatusObserver((IConnectionStatusProvider.IConnectionStatusObserver)this);
        }
    }

    public void onConnectionStatusChanged(@NotNull IConnectionStatusProvider.ConnectionStatus status) {
        if (this.scopes != null && this.options != null) {
            this.sendCachedEnvelopes(this.scopes, this.options);
        }
    }

    private void sendCachedEnvelopes(@NotNull IScopes scopes, @NotNull SentryAndroidOptions options) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            Future future = options.getExecutorService().submit(() -> {
                try {
                    if (this.isClosed.get()) {
                        options.getLogger().log(SentryLevel.INFO, "SendCachedEnvelopeIntegration, not trying to send after closing.", new Object[0]);
                        return;
                    }
                    if (!this.isInitialized.getAndSet(true)) {
                        this.connectionStatusProvider = options.getConnectionStatusProvider();
                        this.connectionStatusProvider.addConnectionStatusObserver((IConnectionStatusProvider.IConnectionStatusObserver)this);
                        this.sender = this.factory.create(scopes, (SentryOptions)options);
                    }
                    if (this.connectionStatusProvider != null && this.connectionStatusProvider.getConnectionStatus() == IConnectionStatusProvider.ConnectionStatus.DISCONNECTED) {
                        options.getLogger().log(SentryLevel.INFO, "SendCachedEnvelopeIntegration, no connection.", new Object[0]);
                        return;
                    }
                    @Nullable @NotNull RateLimiter rateLimiter = scopes.getRateLimiter();
                    if (rateLimiter != null && rateLimiter.isActiveForCategory(DataCategory.All)) {
                        options.getLogger().log(SentryLevel.INFO, "SendCachedEnvelopeIntegration, rate limiting active.", new Object[0]);
                        return;
                    }
                    if (this.sender == null) {
                        options.getLogger().log(SentryLevel.ERROR, "SendCachedEnvelopeIntegration factory is null.", new Object[0]);
                        return;
                    }
                    this.sender.send();
                }
                catch (Throwable e) {
                    options.getLogger().log(SentryLevel.ERROR, "Failed trying to send cached events.", e);
                }
            });
            if (((Boolean)this.startupCrashMarkerEvaluator.getValue()).booleanValue() && this.startupCrashHandled.compareAndSet(false, true)) {
                options.getLogger().log(SentryLevel.DEBUG, "Startup Crash marker exists, blocking flush.", new Object[0]);
                try {
                    future.get(options.getStartupCrashFlushTimeoutMillis(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    options.getLogger().log(SentryLevel.DEBUG, "Synchronous send timed out, continuing in the background.", new Object[0]);
                }
            }
            options.getLogger().log(SentryLevel.DEBUG, "SendCachedEnvelopeIntegration installed.", new Object[0]);
        }
        catch (RejectedExecutionException e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Cached events will not be sent. Did you call Sentry.close()?", (Throwable)e);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Cached events will not be sent", e);
        }
    }
}

