/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import io.sentry.Breadcrumb;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.Permissions;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PhoneStateBreadcrumbsIntegration
implements Integration,
Closeable {
    @NotNull
    private final Context context;
    @Nullable
    private SentryAndroidOptions options;
    @TestOnly
    @Nullable
    PhoneStateChangeListener listener;
    @Nullable
    private TelephonyManager telephonyManager;
    private boolean isClosed = false;
    @NotNull
    private final AutoClosableReentrantLock startLock = new AutoClosableReentrantLock();

    public PhoneStateBreadcrumbsIntegration(@NotNull Context context) {
        this.context = (Context)Objects.requireNonNull((Object)ContextUtils.getApplicationContext(context), (String)"Context is required");
    }

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "enableSystemEventBreadcrumbs enabled: %s", new Object[]{this.options.isEnableSystemEventBreadcrumbs()});
        if (this.options.isEnableSystemEventBreadcrumbs() && Permissions.hasPermission(this.context, "android.permission.READ_PHONE_STATE")) {
            try {
                options.getExecutorService().submit(() -> {
                    try (@NotNull ISentryLifecycleToken ignored = this.startLock.acquire();){
                        if (!this.isClosed) {
                            this.startTelephonyListener(scopes, options);
                        }
                    }
                });
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.DEBUG, "Failed to start PhoneStateBreadcrumbsIntegration on executor thread.", e);
            }
        }
    }

    private void startTelephonyListener(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        this.telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        if (this.telephonyManager != null) {
            try {
                this.listener = new PhoneStateChangeListener(scopes);
                this.telephonyManager.listen((PhoneStateListener)this.listener, 32);
                options.getLogger().log(SentryLevel.DEBUG, "PhoneStateBreadcrumbsIntegration installed.", new Object[0]);
                IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.INFO, e, "TelephonyManager is not available or ready to use.", new Object[0]);
            }
        } else {
            options.getLogger().log(SentryLevel.INFO, "TelephonyManager is not available", new Object[0]);
        }
    }

    @Override
    public void close() throws IOException {
        try (@NotNull ISentryLifecycleToken ignored = this.startLock.acquire();){
            this.isClosed = true;
        }
        if (this.telephonyManager != null && this.listener != null) {
            this.telephonyManager.listen((PhoneStateListener)this.listener, 0);
            this.listener = null;
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "PhoneStateBreadcrumbsIntegration removed.", new Object[0]);
            }
        }
    }

    static final class PhoneStateChangeListener
    extends PhoneStateListener {
        @NotNull
        private final IScopes scopes;

        PhoneStateChangeListener(@NotNull IScopes scopes) {
            this.scopes = scopes;
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            if (state == 1) {
                Breadcrumb breadcrumb = new Breadcrumb();
                breadcrumb.setType("system");
                breadcrumb.setCategory("device.event");
                breadcrumb.setData("action", (Object)"CALL_STATE_RINGING");
                breadcrumb.setMessage("Device ringing");
                breadcrumb.setLevel(SentryLevel.INFO);
                this.scopes.addBreadcrumb(breadcrumb);
            }
        }
    }
}

