/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.content.Context;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.Integration;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.ANRWatchDog;
import io.sentry.android.core.AppState;
import io.sentry.android.core.ApplicationNotResponding;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.TransactionEnd;
import io.sentry.protocol.Mechanism;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.HintUtils;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class AnrIntegration
implements Integration,
Closeable {
    @NotNull
    private final Context context;
    private boolean isClosed = false;
    @NotNull
    private final AutoClosableReentrantLock startLock = new AutoClosableReentrantLock();
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static ANRWatchDog anrWatchDog;
    @Nullable
    private SentryOptions options;
    @NotNull
    protected static final AutoClosableReentrantLock watchDogLock;

    public AnrIntegration(@NotNull Context context) {
        this.context = ContextUtils.getApplicationContext(context);
    }

    public final void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"SentryOptions is required");
        this.register(scopes, (SentryAndroidOptions)options);
    }

    private void register(@NotNull IScopes scopes, @NotNull SentryAndroidOptions options) {
        options.getLogger().log(SentryLevel.DEBUG, "AnrIntegration enabled: %s", new Object[]{options.isAnrEnabled()});
        if (options.isAnrEnabled()) {
            IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
            try {
                options.getExecutorService().submit(() -> {
                    try (@NotNull ISentryLifecycleToken ignored = this.startLock.acquire();){
                        if (!this.isClosed) {
                            this.startAnrWatchdog(scopes, options);
                        }
                    }
                });
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.DEBUG, "Failed to start AnrIntegration on executor thread.", e);
            }
        }
    }

    private void startAnrWatchdog(@NotNull IScopes scopes, @NotNull SentryAndroidOptions options) {
        try (@NotNull ISentryLifecycleToken ignored = watchDogLock.acquire();){
            if (anrWatchDog == null) {
                options.getLogger().log(SentryLevel.DEBUG, "ANR timeout in milliseconds: %d", new Object[]{options.getAnrTimeoutIntervalMillis()});
                anrWatchDog = new ANRWatchDog(options.getAnrTimeoutIntervalMillis(), options.isAnrReportInDebug(), error -> this.reportANR(scopes, options, error), options.getLogger(), this.context);
                anrWatchDog.start();
                options.getLogger().log(SentryLevel.DEBUG, "AnrIntegration installed.", new Object[0]);
            }
        }
    }

    @TestOnly
    void reportANR(@NotNull IScopes scopes, @NotNull SentryAndroidOptions options, @NotNull ApplicationNotResponding error) {
        options.getLogger().log(SentryLevel.INFO, "ANR triggered with message: %s", new Object[]{error.getMessage()});
        boolean isAppInBackground = Boolean.TRUE.equals(AppState.getInstance().isInBackground());
        Throwable anrThrowable = this.buildAnrThrowable(isAppInBackground, options, error);
        SentryEvent event = new SentryEvent(anrThrowable);
        event.setLevel(SentryLevel.ERROR);
        AnrHint anrHint = new AnrHint(isAppInBackground);
        Hint hint = HintUtils.createWithTypeCheckHint((Object)anrHint);
        scopes.captureEvent(event, hint);
    }

    @NotNull
    private Throwable buildAnrThrowable(boolean isAppInBackground, @NotNull SentryAndroidOptions options, @NotNull ApplicationNotResponding anr) {
        String message = "ANR for at least " + options.getAnrTimeoutIntervalMillis() + " ms.";
        if (isAppInBackground) {
            message = "Background " + message;
        }
        ApplicationNotResponding error = new ApplicationNotResponding(message, anr.getThread());
        Mechanism mechanism = new Mechanism();
        mechanism.setType("ANR");
        return new ExceptionMechanismException(mechanism, (Throwable)error, error.getThread(), true);
    }

    @TestOnly
    @Nullable
    ANRWatchDog getANRWatchDog() {
        return anrWatchDog;
    }

    @Override
    public void close() throws IOException {
        try (@NotNull ISentryLifecycleToken ignored = this.startLock.acquire();){
            this.isClosed = true;
        }
        ignored = watchDogLock.acquire();
        try {
            if (anrWatchDog != null) {
                anrWatchDog.interrupt();
                anrWatchDog = null;
                if (this.options != null) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "AnrIntegration removed.", new Object[0]);
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    static {
        watchDogLock = new AutoClosableReentrantLock();
    }

    static final class AnrHint
    implements AbnormalExit,
    TransactionEnd {
        private final boolean isBackgroundAnr;

        AnrHint(boolean isBackgroundAnr) {
            this.isBackgroundAnr = isBackgroundAnr;
        }

        public String mechanism() {
            return this.isBackgroundAnr ? "anr_background" : "anr_foreground";
        }

        public boolean ignoreCurrentThread() {
            return true;
        }

        @Nullable
        public Long timestamp() {
            return null;
        }
    }
}

