/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.IScopes;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class NdkIntegration
implements Integration,
Closeable {
    public static final String SENTRY_NDK_CLASS_NAME = "io.sentry.android.ndk.SentryNdk";
    @Nullable
    private final Class<?> sentryNdkClass;
    @Nullable
    private SentryAndroidOptions options;

    public NdkIntegration(@Nullable Class<?> sentryNdkClass) {
        this.sentryNdkClass = sentryNdkClass;
    }

    public final void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        boolean enabled = this.options.isEnableNdk();
        this.options.getLogger().log(SentryLevel.DEBUG, "NdkIntegration enabled: %s", new Object[]{enabled});
        if (enabled && this.sentryNdkClass != null) {
            String cachedDir = this.options.getCacheDirPath();
            if (cachedDir == null) {
                this.options.getLogger().log(SentryLevel.ERROR, "No cache dir path is defined in options.", new Object[0]);
                this.disableNdkIntegration(this.options);
                return;
            }
            try {
                Method method = this.sentryNdkClass.getMethod("init", SentryAndroidOptions.class);
                Object[] args = new Object[]{this.options};
                method.invoke(null, args);
                this.options.getLogger().log(SentryLevel.DEBUG, "NdkIntegration installed.", new Object[0]);
                IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
            }
            catch (NoSuchMethodException e) {
                this.disableNdkIntegration(this.options);
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to invoke the SentryNdk.init method.", (Throwable)e);
            }
            catch (Throwable e) {
                this.disableNdkIntegration(this.options);
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to initialize SentryNdk.", e);
            }
        } else {
            this.disableNdkIntegration(this.options);
        }
    }

    private void disableNdkIntegration(@NotNull SentryAndroidOptions options) {
        options.setEnableNdk(false);
        options.setEnableScopeSync(false);
    }

    @TestOnly
    @Nullable
    Class<?> getSentryNdkClass() {
        return this.sentryNdkClass;
    }

    @Override
    public void close() throws IOException {
        if (this.options != null && this.options.isEnableNdk() && this.sentryNdkClass != null) {
            try {
                Method method = this.sentryNdkClass.getMethod("close", new Class[0]);
                method.invoke(null, new Object[0]);
                this.options.getLogger().log(SentryLevel.DEBUG, "NdkIntegration removed.", new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to invoke the SentryNdk.close method.", (Throwable)e);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to close SentryNdk.", e);
            }
            finally {
                this.disableNdkIntegration(this.options);
            }
        }
    }
}

