/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import io.sentry.ILogger;
import io.sentry.IScopes;
import io.sentry.ISentryExecutorService;
import io.sentry.ITransaction;
import io.sentry.ITransactionProfiler;
import io.sentry.PerformanceCollectionData;
import io.sentry.ProfilingTraceData;
import io.sentry.ProfilingTransactionData;
import io.sentry.ScopesAdapter;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.AndroidProfiler;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.CpuInfoUtils;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class AndroidTransactionProfiler
implements ITransactionProfiler {
    @NotNull
    private final Context context;
    @NotNull
    private final ILogger logger;
    @Nullable
    private final String profilingTracesDirPath;
    private final boolean isProfilingEnabled;
    private final int profilingTracesHz;
    @NotNull
    private final ISentryExecutorService executorService;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    private boolean isInitialized = false;
    private int transactionsCounter = 0;
    @NotNull
    private final SentryFrameMetricsCollector frameMetricsCollector;
    @Nullable
    private ProfilingTransactionData currentProfilingTransactionData;
    @Nullable
    private AndroidProfiler profiler = null;
    private long profileStartNanos;
    private long profileStartCpuMillis;

    @Deprecated
    public AndroidTransactionProfiler(@NotNull Context context, @NotNull SentryAndroidOptions sentryAndroidOptions, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector, @NotNull IScopes scopes) {
        this(context, sentryAndroidOptions, buildInfoProvider, frameMetricsCollector);
    }

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull SentryAndroidOptions sentryAndroidOptions, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector) {
        this(context, buildInfoProvider, frameMetricsCollector, sentryAndroidOptions.getLogger(), sentryAndroidOptions.getProfilingTracesDirPath(), sentryAndroidOptions.isProfilingEnabled(), sentryAndroidOptions.getProfilingTracesHz(), sentryAndroidOptions.getExecutorService());
    }

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector, @NotNull ILogger logger, @Nullable String profilingTracesDirPath, boolean isProfilingEnabled, int profilingTracesHz, @NotNull ISentryExecutorService executorService) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"The application context is required");
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"ILogger is required");
        this.frameMetricsCollector = (SentryFrameMetricsCollector)Objects.requireNonNull((Object)frameMetricsCollector, (String)"SentryFrameMetricsCollector is required");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
        this.profilingTracesDirPath = profilingTracesDirPath;
        this.isProfilingEnabled = isProfilingEnabled;
        this.profilingTracesHz = profilingTracesHz;
        this.executorService = (ISentryExecutorService)Objects.requireNonNull((Object)executorService, (String)"The ISentryExecutorService is required.");
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        if (!this.isProfilingEnabled) {
            this.logger.log(SentryLevel.INFO, "Profiling is disabled in options.", new Object[0]);
            return;
        }
        if (this.profilingTracesDirPath == null) {
            this.logger.log(SentryLevel.WARNING, "Disabling profiling because no profiling traces dir path is defined in options.", new Object[0]);
            return;
        }
        if (this.profilingTracesHz <= 0) {
            this.logger.log(SentryLevel.WARNING, "Disabling profiling because trace rate is set to %d", new Object[]{this.profilingTracesHz});
            return;
        }
        this.profiler = new AndroidProfiler(this.profilingTracesDirPath, (int)TimeUnit.SECONDS.toMicros(1L) / this.profilingTracesHz, this.frameMetricsCollector, this.executorService, this.logger, this.buildInfoProvider);
    }

    public synchronized void start() {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return;
        }
        this.init();
        ++this.transactionsCounter;
        if (this.transactionsCounter == 1 && this.onFirstStart()) {
            this.logger.log(SentryLevel.DEBUG, "Profiler started.", new Object[0]);
        } else {
            --this.transactionsCounter;
            this.logger.log(SentryLevel.WARNING, "A profile is already running. This profile will be ignored.", new Object[0]);
        }
    }

    @SuppressLint(value={"NewApi"})
    private boolean onFirstStart() {
        if (this.profiler == null) {
            return false;
        }
        AndroidProfiler.ProfileStartData startData = this.profiler.start();
        if (startData == null) {
            return false;
        }
        this.profileStartNanos = startData.startNanos;
        this.profileStartCpuMillis = startData.startCpuMillis;
        return true;
    }

    public synchronized void bindTransaction(@NotNull ITransaction transaction) {
        if (this.transactionsCounter > 0 && this.currentProfilingTransactionData == null) {
            this.currentProfilingTransactionData = new ProfilingTransactionData(transaction, Long.valueOf(this.profileStartNanos), Long.valueOf(this.profileStartCpuMillis));
        }
    }

    @Nullable
    public synchronized ProfilingTraceData onTransactionFinish(@NotNull ITransaction transaction, @Nullable List<PerformanceCollectionData> performanceCollectionData, @NotNull SentryOptions options) {
        return this.onTransactionFinish(transaction.getName(), transaction.getEventId().toString(), transaction.getSpanContext().getTraceId().toString(), false, performanceCollectionData, options);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    private synchronized ProfilingTraceData onTransactionFinish(@NotNull String transactionName, @NotNull String transactionId, @NotNull String traceId, boolean isTimeout, @Nullable List<PerformanceCollectionData> performanceCollectionData, @NotNull SentryOptions options) {
        if (this.profiler == null) {
            return null;
        }
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return null;
        }
        if (this.currentProfilingTransactionData == null || !this.currentProfilingTransactionData.getId().equals(transactionId)) {
            this.logger.log(SentryLevel.INFO, "Transaction %s (%s) finished, but was not currently being profiled. Skipping", new Object[]{transactionName, traceId});
            return null;
        }
        if (this.transactionsCounter > 0) {
            --this.transactionsCounter;
        }
        this.logger.log(SentryLevel.DEBUG, "Transaction %s (%s) finished.", new Object[]{transactionName, traceId});
        if (this.transactionsCounter != 0) {
            if (this.currentProfilingTransactionData != null) {
                this.currentProfilingTransactionData.notifyFinish(Long.valueOf(SystemClock.elapsedRealtimeNanos()), Long.valueOf(this.profileStartNanos), Long.valueOf(Process.getElapsedCpuTime()), Long.valueOf(this.profileStartCpuMillis));
            }
            return null;
        }
        AndroidProfiler.ProfileEndData endData = this.profiler.endAndCollect(false, performanceCollectionData);
        if (endData == null) {
            return null;
        }
        long transactionDurationNanos = endData.endNanos - this.profileStartNanos;
        ArrayList<ProfilingTransactionData> transactionList = new ArrayList<ProfilingTransactionData>(1);
        ProfilingTransactionData txData = this.currentProfilingTransactionData;
        if (txData != null) {
            transactionList.add(txData);
        }
        this.currentProfilingTransactionData = null;
        this.transactionsCounter = 0;
        String totalMem = "0";
        ActivityManager.MemoryInfo memInfo = this.getMemInfo();
        if (memInfo != null) {
            totalMem = Long.toString(memInfo.totalMem);
        }
        String[] abis = Build.SUPPORTED_ABIS;
        for (ProfilingTransactionData t : transactionList) {
            t.notifyFinish(Long.valueOf(endData.endNanos), Long.valueOf(this.profileStartNanos), Long.valueOf(endData.endCpuMillis), Long.valueOf(this.profileStartCpuMillis));
        }
        return new ProfilingTraceData(endData.traceFile, transactionList, transactionName, transactionId, traceId, Long.toString(transactionDurationNanos), this.buildInfoProvider.getSdkInfoVersion(), abis != null && abis.length > 0 ? abis[0] : "", () -> CpuInfoUtils.getInstance().readMaxFrequencies(), this.buildInfoProvider.getManufacturer(), this.buildInfoProvider.getModel(), this.buildInfoProvider.getVersionRelease(), this.buildInfoProvider.isEmulator(), totalMem, options.getProguardUuid(), options.getRelease(), options.getEnvironment(), endData.didTimeout || isTimeout ? "timeout" : "normal", endData.measurementsMap);
    }

    public boolean isRunning() {
        return this.transactionsCounter != 0;
    }

    public void close() {
        if (this.currentProfilingTransactionData != null) {
            this.onTransactionFinish(this.currentProfilingTransactionData.getName(), this.currentProfilingTransactionData.getId(), this.currentProfilingTransactionData.getTraceId(), true, null, ScopesAdapter.getInstance().getOptions());
        } else if (this.transactionsCounter != 0) {
            --this.transactionsCounter;
        }
        if (this.profiler != null) {
            this.profiler.close();
        }
    }

    @Nullable
    private ActivityManager.MemoryInfo getMemInfo() {
        try {
            ActivityManager actManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            if (actManager != null) {
                actManager.getMemoryInfo(memInfo);
                return memInfo;
            }
            this.logger.log(SentryLevel.INFO, "Error getting MemoryInfo.", new Object[0]);
            return null;
        }
        catch (Throwable e) {
            this.logger.log(SentryLevel.ERROR, "Error getting MemoryInfo.", e);
            return null;
        }
    }

    @TestOnly
    int getTransactionsCounter() {
        return this.transactionsCounter;
    }
}

