/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.performance;

import android.os.SystemClock;
import io.sentry.DateUtils;
import io.sentry.SentryDate;
import io.sentry.SentryLongDate;
import io.sentry.SentryNanotimeDate;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class TimeSpan
implements Comparable<TimeSpan> {
    @Nullable
    private String description;
    private long startSystemNanos;
    private long startUnixTimeMs;
    private long startUptimeMs;
    private long stopUptimeMs;

    public void start() {
        this.startUptimeMs = SystemClock.uptimeMillis();
        this.startUnixTimeMs = System.currentTimeMillis();
        this.startSystemNanos = System.nanoTime();
    }

    public void setStartedAt(long uptimeMs) {
        this.startUptimeMs = uptimeMs;
        long shiftMs = SystemClock.uptimeMillis() - this.startUptimeMs;
        this.startUnixTimeMs = System.currentTimeMillis() - shiftMs;
        this.startSystemNanos = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(shiftMs);
    }

    public void stop() {
        this.stopUptimeMs = SystemClock.uptimeMillis();
    }

    public void setStoppedAt(long uptimeMs) {
        this.stopUptimeMs = uptimeMs;
    }

    public boolean hasStarted() {
        return this.startUptimeMs != 0L;
    }

    public boolean hasNotStarted() {
        return this.startUptimeMs == 0L;
    }

    public boolean hasStopped() {
        return this.stopUptimeMs != 0L;
    }

    public boolean hasNotStopped() {
        return this.stopUptimeMs == 0L;
    }

    public long getStartUptimeMs() {
        return this.startUptimeMs;
    }

    public long getStartTimestampMs() {
        return this.startUnixTimeMs;
    }

    @Nullable
    public SentryDate getStartTimestamp() {
        if (this.hasStarted()) {
            return new SentryNanotimeDate(DateUtils.nanosToDate((long)DateUtils.millisToNanos((long)this.getStartTimestampMs())), this.startSystemNanos);
        }
        return null;
    }

    public double getStartTimestampSecs() {
        return DateUtils.millisToSeconds((double)this.startUnixTimeMs);
    }

    public long getProjectedStopTimestampMs() {
        if (this.hasStarted()) {
            return this.startUnixTimeMs + this.getDurationMs();
        }
        return 0L;
    }

    public double getProjectedStopTimestampSecs() {
        return DateUtils.millisToSeconds((double)this.getProjectedStopTimestampMs());
    }

    @Nullable
    public SentryDate getProjectedStopTimestamp() {
        if (this.hasStopped()) {
            return new SentryLongDate(DateUtils.millisToNanos((long)this.getProjectedStopTimestampMs()));
        }
        return null;
    }

    public long getDurationMs() {
        if (this.hasStopped()) {
            return this.stopUptimeMs - this.startUptimeMs;
        }
        return 0L;
    }

    @TestOnly
    public void setStartUnixTimeMs(long startUnixTimeMs) {
        this.startUnixTimeMs = startUnixTimeMs;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void reset() {
        this.description = null;
        this.startUptimeMs = 0L;
        this.stopUptimeMs = 0L;
        this.startUnixTimeMs = 0L;
        this.startSystemNanos = 0L;
    }

    @Override
    public int compareTo(@NotNull TimeSpan o) {
        return Long.compare(this.startUnixTimeMs, o.startUnixTimeMs);
    }
}

