/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.sentry.Breadcrumb;
import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.Integration;
import io.sentry.SentryDateProvider;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidConnectionStatusProvider;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class NetworkBreadcrumbsIntegration
implements Integration,
Closeable {
    @NotNull
    private final Context context;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final ILogger logger;
    @TestOnly
    @Nullable
    NetworkBreadcrumbsNetworkCallback networkCallback;

    public NetworkBreadcrumbsIntegration(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ILogger logger) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"Context is required");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"ILogger is required");
    }

    @SuppressLint(value={"NewApi"})
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)hub, (String)"Hub is required");
        SentryAndroidOptions androidOptions = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.logger.log(SentryLevel.DEBUG, "NetworkBreadcrumbsIntegration enabled: %s", new Object[]{androidOptions.isEnableNetworkEventBreadcrumbs()});
        if (androidOptions.isEnableNetworkEventBreadcrumbs()) {
            if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
                this.networkCallback = null;
                this.logger.log(SentryLevel.DEBUG, "NetworkBreadcrumbsIntegration requires Android 5+", new Object[0]);
                return;
            }
            this.networkCallback = new NetworkBreadcrumbsNetworkCallback(hub, this.buildInfoProvider, options.getDateProvider());
            boolean registered = AndroidConnectionStatusProvider.registerNetworkCallback(this.context, this.logger, this.buildInfoProvider, this.networkCallback);
            if (!registered) {
                this.networkCallback = null;
                this.logger.log(SentryLevel.DEBUG, "NetworkBreadcrumbsIntegration not installed.", new Object[0]);
                return;
            }
            this.logger.log(SentryLevel.DEBUG, "NetworkBreadcrumbsIntegration installed.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.networkCallback != null) {
            AndroidConnectionStatusProvider.unregisterNetworkCallback(this.context, this.logger, this.buildInfoProvider, this.networkCallback);
            this.logger.log(SentryLevel.DEBUG, "NetworkBreadcrumbsIntegration remove.", new Object[0]);
        }
        this.networkCallback = null;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    @RequiresApi(api=21)
    static final class NetworkBreadcrumbsNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        @NotNull
        final IHub hub;
        @NotNull
        final BuildInfoProvider buildInfoProvider;
        @Nullable
        Network currentNetwork = null;
        @Nullable
        NetworkCapabilities lastCapabilities = null;
        long lastCapabilityNanos = 0L;
        @NotNull
        final SentryDateProvider dateProvider;

        NetworkBreadcrumbsNetworkCallback(@NotNull IHub hub, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryDateProvider dateProvider) {
            this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
            this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
            this.dateProvider = (SentryDateProvider)Objects.requireNonNull((Object)dateProvider, (String)"SentryDateProvider is required");
        }

        public void onAvailable(@NonNull Network network) {
            if (network.equals((Object)this.currentNetwork)) {
                return;
            }
            Breadcrumb breadcrumb = this.createBreadcrumb("NETWORK_AVAILABLE");
            this.hub.addBreadcrumb(breadcrumb);
            this.currentNetwork = network;
            this.lastCapabilities = null;
        }

        public void onCapabilitiesChanged(@NonNull Network network, @NonNull NetworkCapabilities networkCapabilities) {
            if (!network.equals((Object)this.currentNetwork)) {
                return;
            }
            long nowNanos = this.dateProvider.now().nanoTimestamp();
            @Nullable NetworkBreadcrumbConnectionDetail connectionDetail = this.getNewConnectionDetails(this.lastCapabilities, networkCapabilities, this.lastCapabilityNanos, nowNanos);
            if (connectionDetail == null) {
                return;
            }
            this.lastCapabilities = networkCapabilities;
            this.lastCapabilityNanos = nowNanos;
            Breadcrumb breadcrumb = this.createBreadcrumb("NETWORK_CAPABILITIES_CHANGED");
            breadcrumb.setData("download_bandwidth", (Object)connectionDetail.downBandwidth);
            breadcrumb.setData("upload_bandwidth", (Object)connectionDetail.upBandwidth);
            breadcrumb.setData("vpn_active", (Object)connectionDetail.isVpn);
            breadcrumb.setData("network_type", (Object)connectionDetail.type);
            if (connectionDetail.signalStrength != 0) {
                breadcrumb.setData("signal_strength", (Object)connectionDetail.signalStrength);
            }
            Hint hint = new Hint();
            hint.set("android:networkCapabilities", (Object)connectionDetail);
            this.hub.addBreadcrumb(breadcrumb, hint);
        }

        public void onLost(@NonNull Network network) {
            if (!network.equals((Object)this.currentNetwork)) {
                return;
            }
            Breadcrumb breadcrumb = this.createBreadcrumb("NETWORK_LOST");
            this.hub.addBreadcrumb(breadcrumb);
            this.currentNetwork = null;
            this.lastCapabilities = null;
        }

        private Breadcrumb createBreadcrumb(String action) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("system");
            breadcrumb.setCategory("network.event");
            breadcrumb.setData("action", (Object)action);
            breadcrumb.setLevel(SentryLevel.INFO);
            return breadcrumb;
        }

        @Nullable
        private NetworkBreadcrumbConnectionDetail getNewConnectionDetails(@Nullable NetworkCapabilities oldCapabilities, @NotNull NetworkCapabilities newCapabilities, long oldCapabilityNanos, long newCapabilityNanos) {
            if (oldCapabilities == null) {
                return new NetworkBreadcrumbConnectionDetail(newCapabilities, this.buildInfoProvider, newCapabilityNanos);
            }
            NetworkBreadcrumbConnectionDetail oldConnectionDetails = new NetworkBreadcrumbConnectionDetail(oldCapabilities, this.buildInfoProvider, oldCapabilityNanos);
            NetworkBreadcrumbConnectionDetail newConnectionDetails = new NetworkBreadcrumbConnectionDetail(newCapabilities, this.buildInfoProvider, newCapabilityNanos);
            if (oldConnectionDetails.isSimilar(newConnectionDetails)) {
                return null;
            }
            return newConnectionDetails;
        }
    }

    static class NetworkBreadcrumbConnectionDetail {
        final int downBandwidth;
        final int upBandwidth;
        final int signalStrength;
        private long timestampNanos;
        final boolean isVpn;
        @NotNull
        final String type;

        @SuppressLint(value={"NewApi", "ObsoleteSdkInt"})
        @RequiresApi(api=21)
        NetworkBreadcrumbConnectionDetail(@NotNull NetworkCapabilities networkCapabilities, @NotNull BuildInfoProvider buildInfoProvider, long capabilityNanos) {
            Objects.requireNonNull((Object)networkCapabilities, (String)"NetworkCapabilities is required");
            Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
            this.downBandwidth = networkCapabilities.getLinkDownstreamBandwidthKbps();
            this.upBandwidth = networkCapabilities.getLinkUpstreamBandwidthKbps();
            int strength = buildInfoProvider.getSdkInfoVersion() >= 29 ? networkCapabilities.getSignalStrength() : 0;
            this.signalStrength = strength > -100 ? strength : 0;
            this.isVpn = networkCapabilities.hasTransport(4);
            String connectionType = AndroidConnectionStatusProvider.getConnectionType(networkCapabilities, buildInfoProvider);
            this.type = connectionType != null ? connectionType : "";
            this.timestampNanos = capabilityNanos;
        }

        boolean isSimilar(@NotNull NetworkBreadcrumbConnectionDetail other) {
            int signalDiff = Math.abs(this.signalStrength - other.signalStrength);
            int downBandwidthDiff = Math.abs(this.downBandwidth - other.downBandwidth);
            int upBandwidthDiff = Math.abs(this.upBandwidth - other.upBandwidth);
            boolean isTimestampSimilar = DateUtils.nanosToMillis((double)Math.abs(this.timestampNanos - other.timestampNanos)) < 5000.0;
            boolean isSignalSimilar = isTimestampSimilar || signalDiff <= 5;
            boolean isDownBandwidthSimilar = isTimestampSimilar || (double)downBandwidthDiff <= Math.max(1000.0, (double)Math.abs(this.downBandwidth) * 0.1);
            boolean isUpBandwidthSimilar = isTimestampSimilar || (double)upBandwidthDiff <= Math.max(1000.0, (double)Math.abs(this.upBandwidth) * 0.1);
            return this.isVpn == other.isVpn && this.type.equals(other.type) && isSignalSimilar && isDownBandwidthSimilar && isUpBandwidthSimilar;
        }
    }
}

