/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.IPerformanceContinuousCollector;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.NoOpSpan;
import io.sentry.NoOpTransaction;
import io.sentry.SentryDate;
import io.sentry.SpanId;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.SentryFrameMetrics;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SpanFrameMetricsCollector
implements IPerformanceContinuousCollector,
SentryFrameMetricsCollector.FrameMetricsCollectorListener {
    @NotNull
    private final Object lock = new Object();
    @Nullable
    private final SentryFrameMetricsCollector frameMetricsCollector;
    @Nullable
    private volatile String listenerId;
    @NotNull
    private final Map<SpanId, SentryFrameMetrics> metricsAtSpanStart;
    @NotNull
    private final SentryFrameMetrics currentFrameMetrics;
    private final boolean enabled;
    private float lastRefreshRate = 60.0f;

    public SpanFrameMetricsCollector(@NotNull SentryAndroidOptions options) {
        this.frameMetricsCollector = options.getFrameMetricsCollector();
        this.enabled = options.isEnablePerformanceV2() && options.isEnableFramesTracking();
        this.metricsAtSpanStart = new HashMap<SpanId, SentryFrameMetrics>();
        this.currentFrameMetrics = new SentryFrameMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSpanStarted(@NotNull ISpan span) {
        if (!this.enabled) {
            return;
        }
        if (span instanceof NoOpSpan) {
            return;
        }
        if (span instanceof NoOpTransaction) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.metricsAtSpanStart.put(span.getSpanContext().getSpanId(), this.currentFrameMetrics.duplicate());
            if (this.listenerId == null && this.frameMetricsCollector != null) {
                this.listenerId = this.frameMetricsCollector.startCollection(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSpanFinished(@NotNull ISpan span) {
        if (!this.enabled) {
            return;
        }
        if (span instanceof NoOpSpan) {
            return;
        }
        if (span instanceof NoOpTransaction) {
            return;
        }
        @Nullable SentryFrameMetrics diff = null;
        Object object = this.lock;
        synchronized (object) {
            @Nullable SentryFrameMetrics metricsAtStart = this.metricsAtSpanStart.remove(span.getSpanContext().getSpanId());
            if (metricsAtStart != null) {
                diff = this.currentFrameMetrics.diffTo(metricsAtStart);
            }
        }
        if (diff != null && diff.containsValidData()) {
            int nonRenderedFrameCount = 0;
            @Nullable SentryDate spanFinishDate = span.getFinishDate();
            if (spanFinishDate != null) {
                long spanDurationNanos = spanFinishDate.diff(span.getStartDate());
                long frameMetricsDurationNanos = diff.getTotalDurationNanos();
                long nonRenderedDuration = spanDurationNanos - frameMetricsDurationNanos;
                double refreshRate = this.lastRefreshRate;
                if (nonRenderedDuration > 0L && refreshRate > 0.0) {
                    long normalFrameDurationNanos = (long)((double)TimeUnit.SECONDS.toNanos(1L) / refreshRate);
                    nonRenderedFrameCount = (int)(nonRenderedDuration / normalFrameDurationNanos);
                }
            }
            int totalFrameCount = diff.getTotalFrameCount() + nonRenderedFrameCount;
            span.setData("frames.total", (Object)totalFrameCount);
            span.setData("frames.slow", (Object)diff.getSlowFrameCount());
            span.setData("frames.frozen", (Object)diff.getFrozenFrameCount());
            if (span instanceof ITransaction) {
                span.setMeasurement("frames_total", (Number)totalFrameCount);
                span.setMeasurement("frames_slow", (Number)diff.getSlowFrameCount());
                span.setMeasurement("frames_frozen", (Number)diff.getFrozenFrameCount());
            }
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.metricsAtSpanStart.isEmpty()) {
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (this.listenerId != null) {
                if (this.frameMetricsCollector != null) {
                    this.frameMetricsCollector.stopCollection(this.listenerId);
                }
                this.listenerId = null;
            }
            this.metricsAtSpanStart.clear();
            this.currentFrameMetrics.clear();
        }
    }

    @Override
    public void onFrameMetricCollected(long frameStartNanos, long frameEndNanos, long durationNanos, long delayNanos, boolean isSlow, boolean isFrozen, float refreshRate) {
        if (isFrozen) {
            this.currentFrameMetrics.addFrozenFrame(durationNanos, delayNanos);
        } else if (isSlow) {
            this.currentFrameMetrics.addSlowFrame(durationNanos, delayNanos);
        } else {
            this.currentFrameMetrics.addNormalFrame(durationNanos);
        }
        this.lastRefreshRate = refreshRate;
    }
}

