/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.os.SystemClock;
import android.system.Os;
import android.system.OsConstants;
import io.sentry.CpuCollectionData;
import io.sentry.ILogger;
import io.sentry.IPerformanceSnapshotCollector;
import io.sentry.PerformanceCollectionData;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.util.FileUtils;
import io.sentry.util.Objects;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AndroidCpuCollector
implements IPerformanceSnapshotCollector {
    private long lastRealtimeNanos = 0L;
    private long lastCpuNanos = 0L;
    private long clockSpeedHz = 1L;
    private long numCores = 1L;
    private final long NANOSECOND_PER_SECOND = 1000000000L;
    private double nanosecondsPerClockTick = 1.0E9 / (double)this.clockSpeedHz;
    @NotNull
    private final File selfStat = new File("/proc/self/stat");
    @NotNull
    private final ILogger logger;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    private boolean isEnabled = false;

    public AndroidCpuCollector(@NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"Logger is required.");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required.");
    }

    @SuppressLint(value={"NewApi"})
    public void setup() {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            this.isEnabled = false;
            return;
        }
        this.isEnabled = true;
        this.clockSpeedHz = Os.sysconf((int)OsConstants._SC_CLK_TCK);
        this.numCores = Os.sysconf((int)OsConstants._SC_NPROCESSORS_CONF);
        this.nanosecondsPerClockTick = 1.0E9 / (double)this.clockSpeedHz;
        this.lastCpuNanos = this.readTotalCpuNanos();
    }

    @SuppressLint(value={"NewApi"})
    public void collect(@NotNull PerformanceCollectionData performanceCollectionData) {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21 || !this.isEnabled) {
            return;
        }
        long nowNanos = SystemClock.elapsedRealtimeNanos();
        long realTimeNanosDiff = nowNanos - this.lastRealtimeNanos;
        this.lastRealtimeNanos = nowNanos;
        long cpuNanos = this.readTotalCpuNanos();
        long cpuNanosDiff = cpuNanos - this.lastCpuNanos;
        this.lastCpuNanos = cpuNanos;
        double cpuUsagePercentage = (double)cpuNanosDiff / (double)realTimeNanosDiff;
        CpuCollectionData cpuData = new CpuCollectionData(System.currentTimeMillis(), cpuUsagePercentage / (double)this.numCores * 100.0);
        performanceCollectionData.addCpuData(cpuData);
    }

    private long readTotalCpuNanos() {
        String stat = null;
        try {
            stat = FileUtils.readText((File)this.selfStat);
        }
        catch (IOException e) {
            this.isEnabled = false;
            this.logger.log(SentryLevel.WARNING, "Unable to read /proc/self/stat file. Disabling cpu collection.", (Throwable)e);
        }
        if (stat != null) {
            stat = stat.trim();
            String[] stats = stat.split("[\n\t\r ]");
            try {
                long uTime = Long.parseLong(stats[13]);
                long sTime = Long.parseLong(stats[14]);
                long cuTime = Long.parseLong(stats[15]);
                long csTime = Long.parseLong(stats[16]);
                return (long)((double)(uTime + sTime + cuTime + csTime) * this.nanosecondsPerClockTick);
            }
            catch (NumberFormatException e) {
                this.logger.log(SentryLevel.ERROR, "Error parsing /proc/self/stat file.", (Throwable)e);
                return 0L;
            }
        }
        return 0L;
    }
}

