/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import io.sentry.ILogger;
import io.sentry.NoOpLogger;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.EmptySecureContentProvider;
import io.sentry.android.core.internal.util.FirstDrawDoneListener;
import io.sentry.android.core.performance.ActivityLifecycleCallbacksAdapter;
import io.sentry.android.core.performance.ActivityLifecycleTimeSpan;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryPerformanceProvider
extends EmptySecureContentProvider {
    private static final long sdkInitMillis = SystemClock.uptimeMillis();
    @Nullable
    private Application app;
    @Nullable
    private Application.ActivityLifecycleCallbacks activityCallback;

    public boolean onCreate() {
        this.onAppLaunched(this.getContext());
        return true;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        if (SentryPerformanceProvider.class.getName().equals(info.authority)) {
            throw new IllegalStateException("An applicationId is required to fulfill the manifest placeholder.");
        }
        super.attachInfo(context, info);
    }

    @Nullable
    public String getType(@NotNull Uri uri) {
        return null;
    }

    private void onAppLaunched(@Nullable Context context) {
        final @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
        @NotNull TimeSpan sdkInitTimeSpan = appStartMetrics.getSdkInitTimeSpan();
        sdkInitTimeSpan.setStartedAt(sdkInitMillis);
        if (Build.VERSION.SDK_INT < 24) {
            return;
        }
        if (context instanceof Application) {
            this.app = (Application)context;
        }
        if (this.app == null) {
            return;
        }
        @NotNull TimeSpan appStartTimespan = appStartMetrics.getAppStartTimeSpan();
        appStartTimespan.setStartedAt(Process.getStartUptimeMillis());
        final AtomicBoolean firstDrawDone = new AtomicBoolean(false);
        this.activityCallback = new ActivityLifecycleCallbacksAdapter(){
            final WeakHashMap<Activity, ActivityLifecycleTimeSpan> activityLifecycleMap = new WeakHashMap();

            public void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                long now = SystemClock.uptimeMillis();
                if (appStartMetrics.getAppStartTimeSpan().hasStopped()) {
                    return;
                }
                ActivityLifecycleTimeSpan timeSpan = new ActivityLifecycleTimeSpan();
                timeSpan.getOnCreate().setStartedAt(now);
                this.activityLifecycleMap.put(activity, timeSpan);
            }

            @Override
            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                if (appStartMetrics.getAppStartType() == AppStartMetrics.AppStartType.UNKNOWN) {
                    appStartMetrics.setAppStartType(savedInstanceState == null ? AppStartMetrics.AppStartType.COLD : AppStartMetrics.AppStartType.WARM);
                }
            }

            public void onActivityPostCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                if (appStartMetrics.getAppStartTimeSpan().hasStopped()) {
                    return;
                }
                @Nullable ActivityLifecycleTimeSpan timeSpan = this.activityLifecycleMap.get(activity);
                if (timeSpan != null) {
                    timeSpan.getOnCreate().stop();
                    timeSpan.getOnCreate().setDescription(activity.getClass().getName() + ".onCreate");
                }
            }

            public void onActivityPreStarted(@NonNull Activity activity) {
                long now = SystemClock.uptimeMillis();
                if (appStartMetrics.getAppStartTimeSpan().hasStopped()) {
                    return;
                }
                @Nullable ActivityLifecycleTimeSpan timeSpan = this.activityLifecycleMap.get(activity);
                if (timeSpan != null) {
                    timeSpan.getOnStart().setStartedAt(now);
                }
            }

            @Override
            public void onActivityStarted(@NonNull Activity activity) {
                if (firstDrawDone.get()) {
                    return;
                }
                FirstDrawDoneListener.registerForNextDraw(activity, () -> {
                    if (firstDrawDone.compareAndSet(false, true)) {
                        SentryPerformanceProvider.this.onAppStartDone();
                    }
                }, new BuildInfoProvider((ILogger)NoOpLogger.getInstance()));
            }

            public void onActivityPostStarted(@NonNull Activity activity) {
                @Nullable ActivityLifecycleTimeSpan timeSpan = this.activityLifecycleMap.remove(activity);
                if (appStartMetrics.getAppStartTimeSpan().hasStopped()) {
                    return;
                }
                if (timeSpan != null) {
                    timeSpan.getOnStart().stop();
                    timeSpan.getOnStart().setDescription(activity.getClass().getName() + ".onStart");
                    appStartMetrics.addActivityLifecycleTimeSpans(timeSpan);
                }
            }

            @Override
            public void onActivityDestroyed(@NonNull Activity activity) {
                this.activityLifecycleMap.remove(activity);
            }
        };
        this.app.registerActivityLifecycleCallbacks(this.activityCallback);
    }

    @TestOnly
    synchronized void onAppStartDone() {
        @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
        appStartMetrics.getSdkInitTimeSpan().stop();
        appStartMetrics.getAppStartTimeSpan().stop();
        if (this.app != null && this.activityCallback != null) {
            this.app.unregisterActivityLifecycleCallbacks(this.activityCallback);
        }
    }

    @TestOnly
    @Nullable
    Application.ActivityLifecycleCallbacks getActivityCallback() {
        return this.activityCallback;
    }
}

