/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.os.Debug;
import android.os.Process;
import android.os.SystemClock;
import io.sentry.CpuCollectionData;
import io.sentry.ILogger;
import io.sentry.ISentryExecutorService;
import io.sentry.MemoryCollectionData;
import io.sentry.PerformanceCollectionData;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.profilemeasurements.ProfileMeasurement;
import io.sentry.profilemeasurements.ProfileMeasurementValue;
import io.sentry.util.Objects;
import java.io.File;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AndroidProfiler {
    private static final int BUFFER_SIZE_BYTES = 3000000;
    private static final int PROFILING_TIMEOUT_MILLIS = 30000;
    private long transactionStartNanos = 0L;
    @NotNull
    private final File traceFilesDir;
    private final int intervalUs;
    @Nullable
    private Future<?> scheduledFinish = null;
    @Nullable
    private File traceFile = null;
    @Nullable
    private String frameMetricsCollectorId;
    @Nullable
    private volatile ProfileEndData timedOutProfilingData = null;
    @NotNull
    private final SentryFrameMetricsCollector frameMetricsCollector;
    @NotNull
    private final ArrayDeque<ProfileMeasurementValue> screenFrameRateMeasurements = new ArrayDeque();
    @NotNull
    private final ArrayDeque<ProfileMeasurementValue> slowFrameRenderMeasurements = new ArrayDeque();
    @NotNull
    private final ArrayDeque<ProfileMeasurementValue> frozenFrameRenderMeasurements = new ArrayDeque();
    @NotNull
    private final Map<String, ProfileMeasurement> measurementsMap = new HashMap<String, ProfileMeasurement>();
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final ISentryExecutorService executorService;
    @NotNull
    private final ILogger logger;
    private boolean isRunning = false;

    public AndroidProfiler(@NotNull String tracesFilesDirPath, int intervalUs, @NotNull SentryFrameMetricsCollector frameMetricsCollector, @NotNull ISentryExecutorService executorService, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        this.traceFilesDir = new File((String)Objects.requireNonNull((Object)tracesFilesDirPath, (String)"TracesFilesDirPath is required"));
        this.intervalUs = intervalUs;
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"Logger is required");
        this.executorService = (ISentryExecutorService)Objects.requireNonNull((Object)executorService, (String)"ExecutorService is required.");
        this.frameMetricsCollector = (SentryFrameMetricsCollector)Objects.requireNonNull((Object)frameMetricsCollector, (String)"SentryFrameMetricsCollector is required");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public synchronized ProfileStartData start() {
        if (this.intervalUs == 0) {
            this.logger.log(SentryLevel.WARNING, "Disabling profiling because intervaUs is set to %d", new Object[]{this.intervalUs});
            return null;
        }
        if (this.isRunning) {
            this.logger.log(SentryLevel.WARNING, "Profiling has already started...", new Object[0]);
            return null;
        }
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return null;
        }
        this.traceFile = new File(this.traceFilesDir, UUID.randomUUID() + ".trace");
        this.measurementsMap.clear();
        this.screenFrameRateMeasurements.clear();
        this.slowFrameRenderMeasurements.clear();
        this.frozenFrameRenderMeasurements.clear();
        this.frameMetricsCollectorId = this.frameMetricsCollector.startCollection(new SentryFrameMetricsCollector.FrameMetricsCollectorListener(){
            float lastRefreshRate = 0.0f;

            @Override
            public void onFrameMetricCollected(long frameStartNanos, long frameEndNanos, long durationNanos, long delayNanos, boolean isSlow, boolean isFrozen, float refreshRate) {
                long frameTimestampRelativeNanos = frameEndNanos - System.nanoTime() + SystemClock.elapsedRealtimeNanos() - AndroidProfiler.this.transactionStartNanos;
                if (frameTimestampRelativeNanos < 0L) {
                    return;
                }
                if (isFrozen) {
                    AndroidProfiler.this.frozenFrameRenderMeasurements.addLast(new ProfileMeasurementValue(Long.valueOf(frameTimestampRelativeNanos), (Number)durationNanos));
                } else if (isSlow) {
                    AndroidProfiler.this.slowFrameRenderMeasurements.addLast(new ProfileMeasurementValue(Long.valueOf(frameTimestampRelativeNanos), (Number)durationNanos));
                }
                if (refreshRate != this.lastRefreshRate) {
                    this.lastRefreshRate = refreshRate;
                    AndroidProfiler.this.screenFrameRateMeasurements.addLast(new ProfileMeasurementValue(Long.valueOf(frameTimestampRelativeNanos), (Number)Float.valueOf(refreshRate)));
                }
            }
        });
        try {
            this.scheduledFinish = this.executorService.schedule(() -> {
                this.timedOutProfilingData = this.endAndCollect(true, null);
            }, 30000L);
        }
        catch (RejectedExecutionException e) {
            this.logger.log(SentryLevel.ERROR, "Failed to call the executor. Profiling will not be automatically finished. Did you call Sentry.close()?", (Throwable)e);
        }
        this.transactionStartNanos = SystemClock.elapsedRealtimeNanos();
        long profileStartCpuMillis = Process.getElapsedCpuTime();
        try {
            Debug.startMethodTracingSampling((String)this.traceFile.getPath(), (int)3000000, (int)this.intervalUs);
            this.isRunning = true;
            return new ProfileStartData(this.transactionStartNanos, profileStartCpuMillis);
        }
        catch (Throwable e) {
            this.endAndCollect(false, null);
            this.logger.log(SentryLevel.ERROR, "Unable to start a profile: ", e);
            this.isRunning = false;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    @Nullable
    public synchronized ProfileEndData endAndCollect(boolean isTimeout, @Nullable List<PerformanceCollectionData> performanceCollectionData) {
        if (this.timedOutProfilingData != null) {
            return this.timedOutProfilingData;
        }
        if (!this.isRunning) {
            this.logger.log(SentryLevel.WARNING, "Profiler not running", new Object[0]);
            return null;
        }
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return null;
        }
        try {
            Debug.stopMethodTracing();
        }
        catch (Throwable e) {
            this.logger.log(SentryLevel.ERROR, "Error while stopping profiling: ", e);
        }
        finally {
            this.isRunning = false;
        }
        this.frameMetricsCollector.stopCollection(this.frameMetricsCollectorId);
        long transactionEndNanos = SystemClock.elapsedRealtimeNanos();
        long transactionEndCpuMillis = Process.getElapsedCpuTime();
        if (this.traceFile == null) {
            this.logger.log(SentryLevel.ERROR, "Trace file does not exists", new Object[0]);
            return null;
        }
        if (!this.slowFrameRenderMeasurements.isEmpty()) {
            this.measurementsMap.put("slow_frame_renders", new ProfileMeasurement("nanosecond", this.slowFrameRenderMeasurements));
        }
        if (!this.frozenFrameRenderMeasurements.isEmpty()) {
            this.measurementsMap.put("frozen_frame_renders", new ProfileMeasurement("nanosecond", this.frozenFrameRenderMeasurements));
        }
        if (!this.screenFrameRateMeasurements.isEmpty()) {
            this.measurementsMap.put("screen_frame_rates", new ProfileMeasurement("hz", this.screenFrameRateMeasurements));
        }
        this.putPerformanceCollectionDataInMeasurements(performanceCollectionData);
        if (this.scheduledFinish != null) {
            this.scheduledFinish.cancel(true);
            this.scheduledFinish = null;
        }
        return new ProfileEndData(transactionEndNanos, transactionEndCpuMillis, isTimeout, this.traceFile, this.measurementsMap);
    }

    public synchronized void close() {
        if (this.scheduledFinish != null) {
            this.scheduledFinish.cancel(true);
            this.scheduledFinish = null;
        }
        if (this.isRunning) {
            this.endAndCollect(true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void putPerformanceCollectionDataInMeasurements(@Nullable List<PerformanceCollectionData> performanceCollectionData) {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return;
        }
        long timestampDiff = SystemClock.elapsedRealtimeNanos() - this.transactionStartNanos - TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        if (performanceCollectionData != null) {
            @NotNull ArrayDeque<ProfileMeasurementValue> memoryUsageMeasurements = new ArrayDeque<ProfileMeasurementValue>(performanceCollectionData.size());
            @NotNull ArrayDeque<ProfileMeasurementValue> nativeMemoryUsageMeasurements = new ArrayDeque<ProfileMeasurementValue>(performanceCollectionData.size());
            @NotNull ArrayDeque<ProfileMeasurementValue> cpuUsageMeasurements = new ArrayDeque<ProfileMeasurementValue>(performanceCollectionData.size());
            List<PerformanceCollectionData> list = performanceCollectionData;
            synchronized (list) {
                for (PerformanceCollectionData performanceData : performanceCollectionData) {
                    CpuCollectionData cpuData = performanceData.getCpuData();
                    MemoryCollectionData memoryData = performanceData.getMemoryData();
                    if (cpuData != null) {
                        cpuUsageMeasurements.add(new ProfileMeasurementValue(Long.valueOf(TimeUnit.MILLISECONDS.toNanos(cpuData.getTimestampMillis()) + timestampDiff), (Number)cpuData.getCpuUsagePercentage()));
                    }
                    if (memoryData != null && memoryData.getUsedHeapMemory() > -1L) {
                        memoryUsageMeasurements.add(new ProfileMeasurementValue(Long.valueOf(TimeUnit.MILLISECONDS.toNanos(memoryData.getTimestampMillis()) + timestampDiff), (Number)memoryData.getUsedHeapMemory()));
                    }
                    if (memoryData == null || memoryData.getUsedNativeMemory() <= -1L) continue;
                    nativeMemoryUsageMeasurements.add(new ProfileMeasurementValue(Long.valueOf(TimeUnit.MILLISECONDS.toNanos(memoryData.getTimestampMillis()) + timestampDiff), (Number)memoryData.getUsedNativeMemory()));
                }
            }
            if (!cpuUsageMeasurements.isEmpty()) {
                this.measurementsMap.put("cpu_usage", new ProfileMeasurement("percent", cpuUsageMeasurements));
            }
            if (!memoryUsageMeasurements.isEmpty()) {
                this.measurementsMap.put("memory_footprint", new ProfileMeasurement("byte", memoryUsageMeasurements));
            }
            if (!nativeMemoryUsageMeasurements.isEmpty()) {
                this.measurementsMap.put("memory_native_footprint", new ProfileMeasurement("byte", nativeMemoryUsageMeasurements));
            }
        }
    }

    public static class ProfileEndData {
        public final long endNanos;
        public final long endCpuMillis;
        @NotNull
        public final File traceFile;
        @NotNull
        public final Map<String, ProfileMeasurement> measurementsMap;
        public final boolean didTimeout;

        public ProfileEndData(long endNanos, long endCpuMillis, boolean didTimeout, @NotNull File traceFile, @NotNull Map<String, ProfileMeasurement> measurementsMap) {
            this.endNanos = endNanos;
            this.traceFile = traceFile;
            this.endCpuMillis = endCpuMillis;
            this.measurementsMap = measurementsMap;
            this.didTimeout = didTimeout;
        }
    }

    public static class ProfileStartData {
        public final long startNanos;
        public final long startCpuMillis;

        public ProfileStartData(long startNanos, long startCpuMillis) {
            this.startNanos = startNanos;
            this.startCpuMillis = startCpuMillis;
        }
    }
}

