/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import io.sentry.ILogger;
import io.sentry.ISentryExecutorService;
import io.sentry.ITransactionProfiler;
import io.sentry.JsonSerializer;
import io.sentry.NoOpLogger;
import io.sentry.SentryAppStartProfilingOptions;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.TracesSamplingDecision;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidOptionsInitializer;
import io.sentry.android.core.AndroidTransactionProfiler;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.EmptySecureContentProvider;
import io.sentry.android.core.internal.util.FirstDrawDoneListener;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.android.core.performance.ActivityLifecycleCallbacksAdapter;
import io.sentry.android.core.performance.ActivityLifecycleTimeSpan;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryPerformanceProvider
extends EmptySecureContentProvider {
    private static final long sdkInitMillis = SystemClock.uptimeMillis();
    @Nullable
    private Application app;
    @Nullable
    private Application.ActivityLifecycleCallbacks activityCallback;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;

    @TestOnly
    SentryPerformanceProvider(@NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        this.logger = logger;
        this.buildInfoProvider = buildInfoProvider;
    }

    public SentryPerformanceProvider() {
        this.logger = new AndroidLogger();
        this.buildInfoProvider = new BuildInfoProvider(this.logger);
    }

    public boolean onCreate() {
        @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
        this.onAppLaunched(this.getContext(), appStartMetrics);
        this.launchAppStartProfiler(appStartMetrics);
        return true;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        if (SentryPerformanceProvider.class.getName().equals(info.authority)) {
            throw new IllegalStateException("An applicationId is required to fulfill the manifest placeholder.");
        }
        super.attachInfo(context, info);
    }

    @Nullable
    public String getType(@NotNull Uri uri) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
        synchronized (appStartMetrics) {
            @Nullable ITransactionProfiler appStartProfiler = AppStartMetrics.getInstance().getAppStartProfiler();
            if (appStartProfiler != null) {
                appStartProfiler.close();
            }
        }
    }

    private void launchAppStartProfiler(@NotNull AppStartMetrics appStartMetrics) {
        @Nullable Context context = this.getContext();
        if (context == null) {
            this.logger.log(SentryLevel.FATAL, "App. Context from ContentProvider is null", new Object[0]);
            return;
        }
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return;
        }
        @NotNull File cacheDir = AndroidOptionsInitializer.getCacheDir(context);
        @NotNull File configFile = new File(cacheDir, "app_start_profiling_config");
        if (!configFile.exists() || !configFile.canRead()) {
            return;
        }
        try (@NotNull BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(configFile)));){
            @Nullable SentryAppStartProfilingOptions profilingOptions = (SentryAppStartProfilingOptions)new JsonSerializer(SentryOptions.empty()).deserialize((Reader)reader, SentryAppStartProfilingOptions.class);
            if (profilingOptions == null) {
                this.logger.log(SentryLevel.WARNING, "Unable to deserialize the SentryAppStartProfilingOptions. App start profiling will not start.", new Object[0]);
                return;
            }
            if (!profilingOptions.isProfilingEnabled()) {
                this.logger.log(SentryLevel.INFO, "Profiling is not enabled. App start profiling will not start.", new Object[0]);
                return;
            }
            @NotNull TracesSamplingDecision appStartSamplingDecision = new TracesSamplingDecision(Boolean.valueOf(profilingOptions.isTraceSampled()), profilingOptions.getTraceSampleRate(), Boolean.valueOf(profilingOptions.isProfileSampled()), profilingOptions.getProfileSampleRate());
            appStartMetrics.setAppStartSamplingDecision(appStartSamplingDecision);
            if (!appStartSamplingDecision.getProfileSampled().booleanValue() || !appStartSamplingDecision.getSampled().booleanValue()) {
                this.logger.log(SentryLevel.DEBUG, "App start profiling was not sampled. It will not start.", new Object[0]);
                return;
            }
            this.logger.log(SentryLevel.DEBUG, "App start profiling started.", new Object[0]);
            @NotNull AndroidTransactionProfiler appStartProfiler = new AndroidTransactionProfiler(context, this.buildInfoProvider, new SentryFrameMetricsCollector(context, this.logger, this.buildInfoProvider), this.logger, profilingOptions.getProfilingTracesDirPath(), profilingOptions.isProfilingEnabled(), profilingOptions.getProfilingTracesHz(), (ISentryExecutorService)new SentryExecutorService());
            appStartMetrics.setAppStartProfiler(appStartProfiler);
            appStartProfiler.start();
        }
        catch (FileNotFoundException e) {
            this.logger.log(SentryLevel.ERROR, "App start profiling config file not found. ", (Throwable)e);
        }
        catch (Throwable e) {
            this.logger.log(SentryLevel.ERROR, "Error reading app start profiling config file. ", e);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void onAppLaunched(@Nullable Context context, final @NotNull AppStartMetrics appStartMetrics) {
        @NotNull TimeSpan sdkInitTimeSpan = appStartMetrics.getSdkInitTimeSpan();
        sdkInitTimeSpan.setStartedAt(sdkInitMillis);
        if (this.buildInfoProvider.getSdkInfoVersion() < 24) {
            return;
        }
        if (context instanceof Application) {
            this.app = (Application)context;
        }
        if (this.app == null) {
            return;
        }
        @NotNull TimeSpan appStartTimespan = appStartMetrics.getAppStartTimeSpan();
        appStartTimespan.setStartedAt(Process.getStartUptimeMillis());
        appStartMetrics.registerApplicationForegroundCheck(this.app);
        final AtomicBoolean firstDrawDone = new AtomicBoolean(false);
        this.activityCallback = new ActivityLifecycleCallbacksAdapter(){
            final WeakHashMap<Activity, ActivityLifecycleTimeSpan> activityLifecycleMap = new WeakHashMap();

            public void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                long now = SystemClock.uptimeMillis();
                if (appStartMetrics.getAppStartTimeSpan().hasStopped()) {
                    return;
                }
                ActivityLifecycleTimeSpan timeSpan = new ActivityLifecycleTimeSpan();
                timeSpan.getOnCreate().setStartedAt(now);
                this.activityLifecycleMap.put(activity, timeSpan);
            }

            @Override
            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                if (appStartMetrics.getAppStartType() == AppStartMetrics.AppStartType.UNKNOWN) {
                    appStartMetrics.setAppStartType(savedInstanceState == null ? AppStartMetrics.AppStartType.COLD : AppStartMetrics.AppStartType.WARM);
                }
            }

            public void onActivityPostCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                if (appStartMetrics.getAppStartTimeSpan().hasStopped()) {
                    return;
                }
                @Nullable ActivityLifecycleTimeSpan timeSpan = this.activityLifecycleMap.get(activity);
                if (timeSpan != null) {
                    timeSpan.getOnCreate().stop();
                    timeSpan.getOnCreate().setDescription(activity.getClass().getName() + ".onCreate");
                }
            }

            public void onActivityPreStarted(@NonNull Activity activity) {
                long now = SystemClock.uptimeMillis();
                if (appStartMetrics.getAppStartTimeSpan().hasStopped()) {
                    return;
                }
                @Nullable ActivityLifecycleTimeSpan timeSpan = this.activityLifecycleMap.get(activity);
                if (timeSpan != null) {
                    timeSpan.getOnStart().setStartedAt(now);
                }
            }

            @Override
            public void onActivityStarted(@NonNull Activity activity) {
                if (firstDrawDone.get()) {
                    return;
                }
                FirstDrawDoneListener.registerForNextDraw(activity, () -> {
                    if (firstDrawDone.compareAndSet(false, true)) {
                        SentryPerformanceProvider.this.onAppStartDone();
                    }
                }, new BuildInfoProvider((ILogger)NoOpLogger.getInstance()));
            }

            public void onActivityPostStarted(@NonNull Activity activity) {
                @Nullable ActivityLifecycleTimeSpan timeSpan = this.activityLifecycleMap.remove(activity);
                if (appStartMetrics.getAppStartTimeSpan().hasStopped()) {
                    return;
                }
                if (timeSpan != null) {
                    timeSpan.getOnStart().stop();
                    timeSpan.getOnStart().setDescription(activity.getClass().getName() + ".onStart");
                    appStartMetrics.addActivityLifecycleTimeSpans(timeSpan);
                }
            }

            @Override
            public void onActivityDestroyed(@NonNull Activity activity) {
                this.activityLifecycleMap.remove(activity);
            }
        };
        this.app.registerActivityLifecycleCallbacks(this.activityCallback);
    }

    @TestOnly
    synchronized void onAppStartDone() {
        @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
        appStartMetrics.getSdkInitTimeSpan().stop();
        appStartMetrics.getAppStartTimeSpan().stop();
        if (this.app != null && this.activityCallback != null) {
            this.app.unregisterActivityLifecycleCallbacks(this.activityCallback);
        }
    }

    @TestOnly
    @Nullable
    Application.ActivityLifecycleCallbacks getActivityCallback() {
        return this.activityCallback;
    }
}

