/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TempSensorBreadcrumbsIntegration
implements Integration,
Closeable,
SensorEventListener {
    @NotNull
    private final Context context;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;
    @TestOnly
    @Nullable
    SensorManager sensorManager;
    private boolean isClosed = false;
    @NotNull
    private final Object startLock = new Object();

    public TempSensorBreadcrumbsIntegration(@NotNull Context context) {
        this.context = (Context)Objects.requireNonNull((Object)ContextUtils.getApplicationContext(context), (String)"Context is required");
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "enableSystemEventsBreadcrumbs enabled: %s", new Object[]{this.options.isEnableSystemEventBreadcrumbs()});
        if (this.options.isEnableSystemEventBreadcrumbs()) {
            try {
                options.getExecutorService().submit(() -> {
                    Object object = this.startLock;
                    synchronized (object) {
                        if (!this.isClosed) {
                            this.startSensorListener(options);
                        }
                    }
                });
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.DEBUG, "Failed to start TempSensorBreadcrumbsIntegration on executor thread.", e);
            }
        }
    }

    private void startSensorListener(@NotNull SentryOptions options) {
        try {
            this.sensorManager = (SensorManager)this.context.getSystemService("sensor");
            if (this.sensorManager != null) {
                Sensor defaultSensor = this.sensorManager.getDefaultSensor(13);
                if (defaultSensor != null) {
                    this.sensorManager.registerListener((SensorEventListener)this, defaultSensor, 3);
                    options.getLogger().log(SentryLevel.DEBUG, "TempSensorBreadcrumbsIntegration installed.", new Object[0]);
                    IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
                } else {
                    options.getLogger().log(SentryLevel.INFO, "TYPE_AMBIENT_TEMPERATURE is not available.", new Object[0]);
                }
            } else {
                options.getLogger().log(SentryLevel.INFO, "SENSOR_SERVICE is not available.", new Object[0]);
            }
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, e, "Failed to init. the SENSOR_SERVICE.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.startLock;
        synchronized (object) {
            this.isClosed = true;
        }
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
            this.sensorManager = null;
            if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "TempSensorBreadcrumbsIntegration removed.", new Object[0]);
            }
        }
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        float[] values = event.values;
        if (values == null || values.length == 0 || values[0] == 0.0f) {
            return;
        }
        if (this.hub != null) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("system");
            breadcrumb.setCategory("device.event");
            breadcrumb.setData("action", (Object)"TYPE_AMBIENT_TEMPERATURE");
            breadcrumb.setData("accuracy", (Object)event.accuracy);
            breadcrumb.setData("timestamp", (Object)event.timestamp);
            breadcrumb.setLevel(SentryLevel.INFO);
            breadcrumb.setData("degree", (Object)Float.valueOf(event.values[0]));
            Hint hint = new Hint();
            hint.set("android:sensorEvent", (Object)event);
            this.hub.addBreadcrumb(breadcrumb, hint);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

