/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActivityBreadcrumbsIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    @NotNull
    private final Application application;
    @Nullable
    private IHub hub;
    private boolean enabled;

    public ActivityBreadcrumbsIntegration(@NotNull Application application) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        SentryAndroidOptions androidOptions = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.enabled = androidOptions.isEnableActivityLifecycleBreadcrumbs();
        options.getLogger().log(SentryLevel.DEBUG, "ActivityBreadcrumbsIntegration enabled: %s", new Object[]{this.enabled});
        if (this.enabled) {
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            options.getLogger().log(SentryLevel.DEBUG, "ActivityBreadcrumbIntegration installed.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.enabled) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            if (this.hub != null) {
                this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "ActivityBreadcrumbsIntegration removed.", new Object[0]);
            }
        }
    }

    public synchronized void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        this.addBreadcrumb(activity, "created");
    }

    public synchronized void onActivityStarted(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "started");
    }

    public synchronized void onActivityResumed(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "resumed");
    }

    public synchronized void onActivityPaused(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "paused");
    }

    public synchronized void onActivityStopped(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "stopped");
    }

    public synchronized void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        this.addBreadcrumb(activity, "saveInstanceState");
    }

    public synchronized void onActivityDestroyed(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "destroyed");
    }

    private void addBreadcrumb(@NotNull Activity activity, @NotNull String state) {
        if (this.hub == null) {
            return;
        }
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("navigation");
        breadcrumb.setData("state", (Object)state);
        breadcrumb.setData("screen", (Object)this.getActivityName(activity));
        breadcrumb.setCategory("ui.lifecycle");
        breadcrumb.setLevel(SentryLevel.INFO);
        Hint hint = new Hint();
        hint.set("android:activity", (Object)activity);
        this.hub.addBreadcrumb(breadcrumb, hint);
    }

    @NotNull
    private String getActivityName(@NotNull Activity activity) {
        return activity.getClass().getSimpleName();
    }
}

