/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.ITransactionProfiler;
import io.sentry.PerformanceCollectionData;
import io.sentry.ProfilingTraceData;
import io.sentry.ProfilingTransactionData;
import io.sentry.SentryLevel;
import io.sentry.android.core.AndroidProfiler;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.CpuInfoUtils;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class AndroidTransactionProfiler
implements ITransactionProfiler {
    @NotNull
    private final Context context;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final IHub hub;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    private boolean isInitialized = false;
    private int transactionsCounter = 0;
    @NotNull
    private final SentryFrameMetricsCollector frameMetricsCollector;
    @Nullable
    private ProfilingTransactionData currentProfilingTransactionData;
    @Nullable
    private ITransaction currentTransaction = null;
    @Nullable
    private AndroidProfiler profiler = null;
    private long transactionStartNanos;
    private long profileStartCpuMillis;

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull SentryAndroidOptions sentryAndroidOptions, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector) {
        this(context, sentryAndroidOptions, buildInfoProvider, frameMetricsCollector, (IHub)HubAdapter.getInstance());
    }

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull SentryAndroidOptions sentryAndroidOptions, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector, @NotNull IHub hub) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"The application context is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)sentryAndroidOptions), (String)"SentryAndroidOptions is required"));
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.frameMetricsCollector = (SentryFrameMetricsCollector)Objects.requireNonNull((Object)frameMetricsCollector, (String)"SentryFrameMetricsCollector is required");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        String tracesFilesDirPath = this.options.getProfilingTracesDirPath();
        if (!this.options.isProfilingEnabled()) {
            this.options.getLogger().log(SentryLevel.INFO, "Profiling is disabled in options.", new Object[0]);
            return;
        }
        if (tracesFilesDirPath == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabling profiling because no profiling traces dir path is defined in options.", new Object[0]);
            return;
        }
        int intervalHz = this.options.getProfilingTracesHz();
        if (intervalHz <= 0) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabling profiling because trace rate is set to %d", new Object[]{intervalHz});
            return;
        }
        this.profiler = new AndroidProfiler(tracesFilesDirPath, (int)TimeUnit.SECONDS.toMicros(1L) / intervalHz, this.frameMetricsCollector, this.options.getExecutorService(), this.options.getLogger(), this.buildInfoProvider);
    }

    public synchronized void onTransactionStart(@NotNull ITransaction transaction) {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return;
        }
        this.init();
        ++this.transactionsCounter;
        if (this.transactionsCounter == 1) {
            if (this.onFirstTransactionStarted(transaction)) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction %s (%s) started and being profiled.", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
            }
        } else {
            --this.transactionsCounter;
            this.options.getLogger().log(SentryLevel.WARNING, "A transaction is already being profiled. Transaction %s (%s) will be ignored.", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
        }
    }

    @SuppressLint(value={"NewApi"})
    private boolean onFirstTransactionStarted(@NotNull ITransaction transaction) {
        if (this.profiler == null) {
            return false;
        }
        AndroidProfiler.ProfileStartData startData = this.profiler.start();
        if (startData == null) {
            return false;
        }
        this.transactionStartNanos = startData.startNanos;
        this.profileStartCpuMillis = startData.startCpuMillis;
        this.currentTransaction = transaction;
        this.currentProfilingTransactionData = new ProfilingTransactionData(transaction, Long.valueOf(this.transactionStartNanos), Long.valueOf(this.profileStartCpuMillis));
        return true;
    }

    @Nullable
    public synchronized ProfilingTraceData onTransactionFinish(@NotNull ITransaction transaction, @Nullable List<PerformanceCollectionData> performanceCollectionData) {
        return this.onTransactionFinish(transaction, false, performanceCollectionData);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    private synchronized ProfilingTraceData onTransactionFinish(@NotNull ITransaction transaction, boolean isTimeout, @Nullable List<PerformanceCollectionData> performanceCollectionData) {
        if (this.profiler == null) {
            return null;
        }
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return null;
        }
        if (this.currentProfilingTransactionData == null || !this.currentProfilingTransactionData.getId().equals(transaction.getEventId().toString())) {
            this.options.getLogger().log(SentryLevel.INFO, "Transaction %s (%s) finished, but was not currently being profiled. Skipping", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
            return null;
        }
        if (this.transactionsCounter > 0) {
            --this.transactionsCounter;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Transaction %s (%s) finished.", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
        if (this.transactionsCounter != 0) {
            if (this.currentProfilingTransactionData != null) {
                this.currentProfilingTransactionData.notifyFinish(Long.valueOf(SystemClock.elapsedRealtimeNanos()), Long.valueOf(this.transactionStartNanos), Long.valueOf(Process.getElapsedCpuTime()), Long.valueOf(this.profileStartCpuMillis));
            }
            return null;
        }
        AndroidProfiler.ProfileEndData endData = this.profiler.endAndCollect(false, performanceCollectionData);
        if (endData == null) {
            return null;
        }
        long transactionDurationNanos = endData.endNanos - this.transactionStartNanos;
        ArrayList<ProfilingTransactionData> transactionList = new ArrayList<ProfilingTransactionData>(1);
        ProfilingTransactionData txData = this.currentProfilingTransactionData;
        if (txData != null) {
            transactionList.add(txData);
        }
        this.currentProfilingTransactionData = null;
        this.transactionsCounter = 0;
        this.currentTransaction = null;
        String totalMem = "0";
        ActivityManager.MemoryInfo memInfo = this.getMemInfo();
        if (memInfo != null) {
            totalMem = Long.toString(memInfo.totalMem);
        }
        String[] abis = Build.SUPPORTED_ABIS;
        for (ProfilingTransactionData t : transactionList) {
            t.notifyFinish(Long.valueOf(endData.endNanos), Long.valueOf(this.transactionStartNanos), Long.valueOf(endData.endCpuMillis), Long.valueOf(this.profileStartCpuMillis));
        }
        return new ProfilingTraceData(endData.traceFile, transactionList, transaction, Long.toString(transactionDurationNanos), this.buildInfoProvider.getSdkInfoVersion(), abis != null && abis.length > 0 ? abis[0] : "", () -> CpuInfoUtils.getInstance().readMaxFrequencies(), this.buildInfoProvider.getManufacturer(), this.buildInfoProvider.getModel(), this.buildInfoProvider.getVersionRelease(), this.buildInfoProvider.isEmulator(), totalMem, this.options.getProguardUuid(), this.options.getRelease(), this.options.getEnvironment(), endData.didTimeout || isTimeout ? "timeout" : "normal", endData.measurementsMap);
    }

    public void close() {
        if (this.currentTransaction != null) {
            this.onTransactionFinish(this.currentTransaction, true, null);
        }
        if (this.profiler != null) {
            this.profiler.close();
        }
    }

    @Nullable
    private ActivityManager.MemoryInfo getMemInfo() {
        try {
            ActivityManager actManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            if (actManager != null) {
                actManager.getMemoryInfo(memInfo);
                return memInfo;
            }
            this.options.getLogger().log(SentryLevel.INFO, "Error getting MemoryInfo.", new Object[0]);
            return null;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting MemoryInfo.", e);
            return null;
        }
    }

    @TestOnly
    @Nullable
    ITransaction getCurrentTransaction() {
        return this.currentTransaction;
    }
}

