/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import io.sentry.transport.ICurrentDateProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class Debouncer {
    private final long waitTimeMs;
    @NotNull
    private final ICurrentDateProvider timeProvider;
    private Long lastExecutionTime = null;

    public Debouncer(@NotNull ICurrentDateProvider timeProvider, long waitTimeMs) {
        this.timeProvider = timeProvider;
        this.waitTimeMs = waitTimeMs;
    }

    public boolean checkForDebounce() {
        long now = this.timeProvider.getCurrentTimeMillis();
        if (this.lastExecutionTime == null || this.lastExecutionTime + this.waitTimeMs <= now) {
            this.lastExecutionTime = now;
            return false;
        }
        return true;
    }
}

