/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.View;
import io.sentry.ILogger;
import io.sentry.NoOpLogger;
import io.sentry.SentryDate;
import io.sentry.android.core.AndroidDateUtils;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.EmptySecureContentProvider;
import io.sentry.android.core.MainLooperHandler;
import io.sentry.android.core.internal.util.FirstDrawDoneListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryPerformanceProvider
extends EmptySecureContentProvider
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    private static SentryDate appStartTime = AndroidDateUtils.getCurrentSentryDateTime();
    private static long appStartMillis = SystemClock.uptimeMillis();
    private boolean firstActivityCreated = false;
    private boolean firstActivityResumed = false;
    @Nullable
    private Application application;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final MainLooperHandler mainHandler;

    public SentryPerformanceProvider() {
        AppStartState.getInstance().setAppStartTime(appStartMillis, appStartTime);
        this.buildInfoProvider = new BuildInfoProvider((ILogger)NoOpLogger.getInstance());
        this.mainHandler = new MainLooperHandler();
    }

    SentryPerformanceProvider(@NotNull BuildInfoProvider buildInfoProvider, @NotNull MainLooperHandler mainHandler) {
        AppStartState.getInstance().setAppStartTime(appStartMillis, appStartTime);
        this.buildInfoProvider = buildInfoProvider;
        this.mainHandler = mainHandler;
    }

    public boolean onCreate() {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        if (context instanceof Application) {
            this.application = (Application)context;
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        return true;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        if (SentryPerformanceProvider.class.getName().equals(info.authority)) {
            throw new IllegalStateException("An applicationId is required to fulfill the manifest placeholder.");
        }
        super.attachInfo(context, info);
    }

    @Nullable
    public String getType(@NotNull Uri uri) {
        return null;
    }

    @TestOnly
    static void setAppStartTime(long appStartMillisLong, @NotNull SentryDate appStartTimeDate) {
        appStartMillis = appStartMillisLong;
        appStartTime = appStartTimeDate;
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        if (!this.firstActivityCreated) {
            boolean coldStart = savedInstanceState == null;
            AppStartState.getInstance().setColdStart(coldStart);
            this.firstActivityCreated = true;
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
    }

    @SuppressLint(value={"NewApi"})
    public void onActivityResumed(@NotNull Activity activity) {
        if (!this.firstActivityResumed) {
            this.firstActivityResumed = true;
            View rootView = activity.findViewById(0x1020002);
            if (rootView != null) {
                FirstDrawDoneListener.registerForNextDraw(rootView, () -> AppStartState.getInstance().setAppStartEnd(), this.buildInfoProvider);
            } else {
                this.mainHandler.post(() -> AppStartState.getInstance().setAppStartEnd());
            }
        }
        if (this.application != null) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
    }

    public void onActivityStopped(@NotNull Activity activity) {
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
    }
}

