/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.sentry.Attachment;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.CurrentActivityHolder;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.ScreenshotUtils;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ScreenshotEventProcessor
implements EventProcessor,
Application.ActivityLifecycleCallbacks,
Closeable {
    @NotNull
    private final Application application;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    private boolean lifecycleCallbackInstalled = true;

    public ScreenshotEventProcessor(@NotNull Application application, @NotNull SentryAndroidOptions options, @NotNull BuildInfoProvider buildInfoProvider) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)options), (String)"SentryAndroidOptions is required"));
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        if (!this.lifecycleCallbackInstalled || !event.isErrored()) {
            return event;
        }
        if (!this.options.isAttachScreenshot()) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.lifecycleCallbackInstalled = false;
            this.options.getLogger().log(SentryLevel.DEBUG, "attachScreenshot is disabled, ScreenshotEventProcessor isn't installed.", new Object[0]);
            return event;
        }
        Activity activity = CurrentActivityHolder.getInstance().getActivity();
        if (activity == null || HintUtils.isFromHybridSdk((Hint)hint)) {
            return event;
        }
        byte[] screenshot = ScreenshotUtils.takeScreenshot(activity, this.options.getLogger(), this.buildInfoProvider);
        if (screenshot == null) {
            return event;
        }
        hint.setScreenshot(Attachment.fromScreenshot((byte[])screenshot));
        hint.set("android:activity", (Object)activity);
        return event;
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        CurrentActivityHolder.getInstance().setActivity(activity);
    }

    public void onActivityStarted(@NonNull Activity activity) {
        this.setCurrentActivity(activity);
    }

    public void onActivityResumed(@NonNull Activity activity) {
        this.setCurrentActivity(activity);
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.cleanCurrentActivity(activity);
    }

    public void onActivityStopped(@NonNull Activity activity) {
        this.cleanCurrentActivity(activity);
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.cleanCurrentActivity(activity);
    }

    @Override
    public void close() throws IOException {
        if (this.options.isAttachScreenshot()) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            CurrentActivityHolder.getInstance().clearActivity();
        }
    }

    private void cleanCurrentActivity(@NonNull Activity activity) {
        if (CurrentActivityHolder.getInstance().getActivity() == activity) {
            CurrentActivityHolder.getInstance().clearActivity();
        }
    }

    private void setCurrentActivity(@NonNull Activity activity) {
        CurrentActivityHolder.getInstance().setActivity(activity);
    }
}

