/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ContextUtils {
    private ContextUtils() {
    }

    @Nullable
    static PackageInfo getPackageInfo(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        return ContextUtils.getPackageInfo(context, 0, logger, buildInfoProvider);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    static PackageInfo getPackageInfo(@NotNull Context context, int flags, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        try {
            if (buildInfoProvider.getSdkInfoVersion() >= 33) {
                return context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.PackageInfoFlags.of((long)flags));
            }
            return context.getPackageManager().getPackageInfo(context.getPackageName(), flags);
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Error getting package info.", e);
            return null;
        }
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    static ApplicationInfo getApplicationInfo(@NotNull Context context, long flag, @NotNull BuildInfoProvider buildInfoProvider) throws PackageManager.NameNotFoundException {
        if (buildInfoProvider.getSdkInfoVersion() >= 33) {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.ApplicationInfoFlags.of((long)flag));
        }
        return context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    static String getVersionCode(@NotNull PackageInfo packageInfo, @NotNull BuildInfoProvider buildInfoProvider) {
        if (buildInfoProvider.getSdkInfoVersion() >= 28) {
            return Long.toString(packageInfo.getLongVersionCode());
        }
        return ContextUtils.getVersionCodeDep(packageInfo);
    }

    @Nullable
    static String getVersionName(@NotNull PackageInfo packageInfo) {
        return packageInfo.versionName;
    }

    @NotNull
    private static String getVersionCodeDep(@NotNull PackageInfo packageInfo) {
        return Integer.toString(packageInfo.versionCode);
    }
}

