/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.util.SparseIntArray;
import androidx.core.app.FrameMetricsAggregator;
import io.sentry.ILogger;
import io.sentry.android.core.LoadClass;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentryId;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ActivityFramesTracker {
    @Nullable
    private FrameMetricsAggregator frameMetricsAggregator = null;
    private boolean androidXAvailable = true;
    @NotNull
    private final @NotNull Map<SentryId, Map<String, @NotNull MeasurementValue>> activityMeasurements = new ConcurrentHashMap<SentryId, Map<String, MeasurementValue>>();
    @NotNull
    private final Map<Activity, FrameCounts> frameCountAtStartSnapshots = new WeakHashMap<Activity, FrameCounts>();

    public ActivityFramesTracker(@NotNull LoadClass loadClass, @Nullable ILogger logger) {
        this.androidXAvailable = loadClass.isClassAvailable("androidx.core.app.FrameMetricsAggregator", logger);
        if (this.androidXAvailable) {
            this.frameMetricsAggregator = new FrameMetricsAggregator();
        }
    }

    public ActivityFramesTracker(@NotNull LoadClass loadClass) {
        this(loadClass, null);
    }

    @TestOnly
    ActivityFramesTracker(@Nullable FrameMetricsAggregator frameMetricsAggregator) {
        this.frameMetricsAggregator = frameMetricsAggregator;
    }

    private boolean isFrameMetricsAggregatorAvailable() {
        return this.androidXAvailable && this.frameMetricsAggregator != null;
    }

    public synchronized void addActivity(@NotNull Activity activity) {
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return;
        }
        this.frameMetricsAggregator.add(activity);
        this.snapshotFrameCountsAtStart(activity);
    }

    private void snapshotFrameCountsAtStart(@NotNull Activity activity) {
        FrameCounts frameCounts = this.calculateCurrentFrameCounts();
        if (frameCounts != null) {
            this.frameCountAtStartSnapshots.put(activity, frameCounts);
        }
    }

    @Nullable
    private FrameCounts calculateCurrentFrameCounts() {
        SparseIntArray totalIndexArray;
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return null;
        }
        if (this.frameMetricsAggregator == null) {
            return null;
        }
        @Nullable SparseIntArray[] framesRates = this.frameMetricsAggregator.getMetrics();
        int totalFrames = 0;
        int slowFrames = 0;
        int frozenFrames = 0;
        if (framesRates != null && framesRates.length > 0 && (totalIndexArray = framesRates[0]) != null) {
            for (int i = 0; i < totalIndexArray.size(); ++i) {
                int frameTime = totalIndexArray.keyAt(i);
                int numFrames = totalIndexArray.valueAt(i);
                totalFrames += numFrames;
                if (frameTime > 700) {
                    frozenFrames += numFrames;
                    continue;
                }
                if (frameTime <= 16) continue;
                slowFrames += numFrames;
            }
        }
        return new FrameCounts(totalFrames, slowFrames, frozenFrames);
    }

    public synchronized void setMetrics(@NotNull Activity activity, @NotNull SentryId transactionId) {
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return;
        }
        try {
            this.frameMetricsAggregator.remove(activity);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        @Nullable FrameCounts frameCounts = this.diffFrameCountsAtEnd(activity);
        if (frameCounts == null || frameCounts.totalFrames == 0 && frameCounts.slowFrames == 0 && frameCounts.frozenFrames == 0) {
            return;
        }
        MeasurementValue tfValues = new MeasurementValue((Number)frameCounts.totalFrames, "none");
        MeasurementValue sfValues = new MeasurementValue((Number)frameCounts.slowFrames, "none");
        MeasurementValue ffValues = new MeasurementValue((Number)frameCounts.frozenFrames, "none");
        HashMap<String, @NotNull MeasurementValue> measurements = new HashMap<String, MeasurementValue>();
        measurements.put("frames_total", tfValues);
        measurements.put("frames_slow", sfValues);
        measurements.put("frames_frozen", ffValues);
        this.activityMeasurements.put(transactionId, measurements);
    }

    @Nullable
    private FrameCounts diffFrameCountsAtEnd(@NotNull Activity activity) {
        @Nullable FrameCounts frameCountsAtStart = this.frameCountAtStartSnapshots.remove(activity);
        if (frameCountsAtStart == null) {
            return null;
        }
        @Nullable FrameCounts frameCountsAtEnd = this.calculateCurrentFrameCounts();
        if (frameCountsAtEnd == null) {
            return null;
        }
        int diffTotalFrames = frameCountsAtEnd.totalFrames - frameCountsAtStart.totalFrames;
        int diffSlowFrames = frameCountsAtEnd.slowFrames - frameCountsAtStart.slowFrames;
        int diffFrozenFrames = frameCountsAtEnd.frozenFrames - frameCountsAtStart.frozenFrames;
        return new FrameCounts(diffTotalFrames, diffSlowFrames, diffFrozenFrames);
    }

    public synchronized @Nullable Map<String, @NotNull MeasurementValue> takeMetrics(@NotNull SentryId transactionId) {
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return null;
        }
        Map<String, @NotNull MeasurementValue> stringMeasurementValueMap = this.activityMeasurements.get(transactionId);
        this.activityMeasurements.remove(transactionId);
        return stringMeasurementValueMap;
    }

    public synchronized void stop() {
        if (this.isFrameMetricsAggregatorAvailable()) {
            this.frameMetricsAggregator.stop();
            this.frameMetricsAggregator.reset();
        }
        this.activityMeasurements.clear();
    }

    private static final class FrameCounts {
        private final int totalFrames;
        private final int slowFrames;
        private final int frozenFrames;

        private FrameCounts(int totalFrames, int slowFrames, int frozenFrames) {
            this.totalFrames = totalFrames;
            this.slowFrames = slowFrames;
            this.frozenFrames = frozenFrames;
        }
    }
}

