/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import android.os.SystemClock;
import io.sentry.ITransaction;
import io.sentry.ITransactionProfiler;
import io.sentry.ProfilingTraceData;
import io.sentry.ProfilingTransactionData;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.CpuInfoUtils;
import io.sentry.util.CollectionUtils;
import io.sentry.util.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AndroidTransactionProfiler
implements ITransactionProfiler {
    private static final int BUFFER_SIZE_BYTES = 3000000;
    private static final int PROFILING_TIMEOUT_MILLIS = 30000;
    private int intervalUs;
    @Nullable
    private File traceFile = null;
    @Nullable
    private File traceFilesDir = null;
    @Nullable
    private Future<?> scheduledFinish = null;
    @Nullable
    private volatile ProfilingTraceData timedOutProfilingData = null;
    @NotNull
    private final Context context;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @Nullable
    private final PackageInfo packageInfo;
    private long transactionStartNanos = 0L;
    private long profileStartCpuMillis = 0L;
    private boolean isInitialized = false;
    private int transactionsCounter = 0;
    @NotNull
    private final Map<String, ProfilingTransactionData> transactionMap = new HashMap<String, ProfilingTransactionData>();

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull SentryAndroidOptions sentryAndroidOptions, @NotNull BuildInfoProvider buildInfoProvider) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"The application context is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)sentryAndroidOptions), (String)"SentryAndroidOptions is required"));
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
        this.packageInfo = ContextUtils.getPackageInfo(context, this.options.getLogger(), buildInfoProvider);
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        String tracesFilesDirPath = this.options.getProfilingTracesDirPath();
        if (!this.options.isProfilingEnabled()) {
            this.options.getLogger().log(SentryLevel.INFO, "Profiling is disabled in options.", new Object[0]);
            return;
        }
        if (tracesFilesDirPath == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabling profiling because no profiling traces dir path is defined in options.", new Object[0]);
            return;
        }
        int intervalHz = this.options.getProfilingTracesHz();
        if (intervalHz <= 0) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabling profiling because trace rate is set to %d", new Object[]{intervalHz});
            return;
        }
        this.intervalUs = (int)TimeUnit.SECONDS.toMicros(1L) / intervalHz;
        this.traceFilesDir = new File(tracesFilesDirPath);
    }

    @SuppressLint(value={"NewApi"})
    public synchronized void onTransactionStart(@NotNull ITransaction transaction) {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return;
        }
        this.init();
        if (this.traceFilesDir == null || this.intervalUs == 0 || !this.traceFilesDir.exists()) {
            return;
        }
        ++this.transactionsCounter;
        if (this.transactionsCounter == 1) {
            this.traceFile = new File(this.traceFilesDir, UUID.randomUUID() + ".trace");
            if (this.traceFile.exists()) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Trace file already exists: %s", new Object[]{this.traceFile.getPath()});
                --this.transactionsCounter;
                return;
            }
            this.scheduledFinish = this.options.getExecutorService().schedule(() -> {
                this.timedOutProfilingData = this.onTransactionFinish(transaction, true);
            }, 30000L);
            this.transactionStartNanos = SystemClock.elapsedRealtimeNanos();
            this.profileStartCpuMillis = Process.getElapsedCpuTime();
            ProfilingTransactionData transactionData = new ProfilingTransactionData(transaction, Long.valueOf(this.transactionStartNanos), Long.valueOf(this.profileStartCpuMillis));
            this.transactionMap.put(transaction.getEventId().toString(), transactionData);
            Debug.startMethodTracingSampling((String)this.traceFile.getPath(), (int)3000000, (int)this.intervalUs);
        } else {
            ProfilingTransactionData transactionData = new ProfilingTransactionData(transaction, Long.valueOf(SystemClock.elapsedRealtimeNanos()), Long.valueOf(Process.getElapsedCpuTime()));
            this.transactionMap.put(transaction.getEventId().toString(), transactionData);
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Transaction %s (%s) started. Transactions being profiled: %d", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString(), this.transactionsCounter});
    }

    @Nullable
    public synchronized ProfilingTraceData onTransactionFinish(@NotNull ITransaction transaction) {
        return this.onTransactionFinish(transaction, false);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    private synchronized ProfilingTraceData onTransactionFinish(@NotNull ITransaction transaction, boolean isTimeout) {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return null;
        }
        ProfilingTraceData profilingData = this.timedOutProfilingData;
        if (!this.transactionMap.containsKey(transaction.getEventId().toString())) {
            if (profilingData != null) {
                List ids = CollectionUtils.map((List)profilingData.getTransactions(), data -> data.getId());
                if (ids.contains(transaction.getEventId().toString())) {
                    this.timedOutProfilingData = null;
                    return profilingData;
                }
                this.options.getLogger().log(SentryLevel.INFO, "A timed out profiling data exists, but the finishing transaction %s (%s) is not part of it", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
                return null;
            }
            this.options.getLogger().log(SentryLevel.INFO, "Transaction %s (%s) finished, but was not currently being profiled. Skipping", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
            return null;
        }
        if (this.transactionsCounter > 0) {
            --this.transactionsCounter;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Transaction %s (%s) finished. Transactions to be profiled: %d", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString(), this.transactionsCounter});
        if (this.transactionsCounter != 0 && !isTimeout) {
            ProfilingTransactionData transactionData = this.transactionMap.get(transaction.getEventId().toString());
            if (transactionData != null) {
                transactionData.notifyFinish(Long.valueOf(SystemClock.elapsedRealtimeNanos()), Long.valueOf(this.transactionStartNanos), Long.valueOf(Process.getElapsedCpuTime()), Long.valueOf(this.profileStartCpuMillis));
            }
            return null;
        }
        Debug.stopMethodTracing();
        long transactionEndNanos = SystemClock.elapsedRealtimeNanos();
        long transactionEndCpuMillis = Process.getElapsedCpuTime();
        long transactionDurationNanos = transactionEndNanos - this.transactionStartNanos;
        ArrayList<ProfilingTransactionData> transactionList = new ArrayList<ProfilingTransactionData>(this.transactionMap.values());
        this.transactionMap.clear();
        this.transactionsCounter = 0;
        if (this.scheduledFinish != null) {
            this.scheduledFinish.cancel(true);
            this.scheduledFinish = null;
        }
        if (this.traceFile == null) {
            this.options.getLogger().log(SentryLevel.ERROR, "Trace file does not exists", new Object[0]);
            return null;
        }
        String versionName = "";
        String versionCode = "";
        String totalMem = "0";
        ActivityManager.MemoryInfo memInfo = this.getMemInfo();
        if (this.packageInfo != null) {
            versionName = ContextUtils.getVersionName(this.packageInfo);
            versionCode = ContextUtils.getVersionCode(this.packageInfo, this.buildInfoProvider);
        }
        if (memInfo != null) {
            totalMem = Long.toString(memInfo.totalMem);
        }
        String[] abis = Build.SUPPORTED_ABIS;
        for (ProfilingTransactionData t : transactionList) {
            t.notifyFinish(Long.valueOf(transactionEndNanos), Long.valueOf(this.transactionStartNanos), Long.valueOf(transactionEndCpuMillis), Long.valueOf(this.profileStartCpuMillis));
        }
        return new ProfilingTraceData(this.traceFile, transactionList, transaction, Long.toString(transactionDurationNanos), this.buildInfoProvider.getSdkInfoVersion(), abis != null && abis.length > 0 ? abis[0] : "", () -> CpuInfoUtils.getInstance().readMaxFrequencies(), this.buildInfoProvider.getManufacturer(), this.buildInfoProvider.getModel(), this.buildInfoProvider.getVersionRelease(), this.buildInfoProvider.isEmulator(), totalMem, this.options.getProguardUuid(), versionName, versionCode, this.options.getEnvironment(), isTimeout ? "timeout" : "normal");
    }

    @Nullable
    private ActivityManager.MemoryInfo getMemInfo() {
        try {
            ActivityManager actManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            if (actManager != null) {
                actManager.getMemoryInfo(memInfo);
                return memInfo;
            }
            this.options.getLogger().log(SentryLevel.INFO, "Error getting MemoryInfo.", new Object[0]);
            return null;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting MemoryInfo.", e);
            return null;
        }
    }
}

