/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryEvent;
import io.sentry.SpanContext;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentrySpan;
import io.sentry.protocol.SentryTransaction;
import io.sentry.util.Objects;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PerformanceAndroidEventProcessor
implements EventProcessor {
    private boolean sentStartMeasurement = false;
    @NotNull
    private final ActivityFramesTracker activityFramesTracker;
    @NotNull
    private final SentryAndroidOptions options;

    PerformanceAndroidEventProcessor(@NotNull SentryAndroidOptions options, @NotNull ActivityFramesTracker activityFramesTracker) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)options), (String)"SentryAndroidOptions is required"));
        this.activityFramesTracker = (ActivityFramesTracker)Objects.requireNonNull((Object)activityFramesTracker, (String)"ActivityFramesTracker is required");
    }

    @Nullable
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        return event;
    }

    @NotNull
    public synchronized SentryTransaction process(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        Map<String, MeasurementValue> framesMetrics;
        Long appStartUpInterval;
        if (!this.options.isTracingEnabled()) {
            return transaction;
        }
        if (!this.sentStartMeasurement && this.hasAppStartSpan(transaction.getSpans()) && (appStartUpInterval = AppStartState.getInstance().getAppStartInterval()) != null) {
            MeasurementValue value = new MeasurementValue((float)appStartUpInterval.longValue(), "millisecond");
            String appStartKey = AppStartState.getInstance().isColdStart() != false ? "app_start_cold" : "app_start_warm";
            transaction.getMeasurements().put(appStartKey, value);
            this.sentStartMeasurement = true;
        }
        SentryId eventId = transaction.getEventId();
        SpanContext spanContext = transaction.getContexts().getTrace();
        if (eventId != null && spanContext != null && spanContext.getOperation().contentEquals("ui.load") && (framesMetrics = this.activityFramesTracker.takeMetrics(eventId)) != null) {
            transaction.getMeasurements().putAll(framesMetrics);
        }
        return transaction;
    }

    private boolean hasAppStartSpan(@NotNull List<SentrySpan> spans) {
        for (SentrySpan span : spans) {
            if (!span.getOp().contentEquals("app.start.cold") && !span.getOp().contentEquals("app.start.warm")) continue;
            return true;
        }
        return false;
    }
}

