/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.gestures;

import android.content.res.Resources;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ScrollView;
import androidx.core.view.ScrollingView;
import io.sentry.android.core.internal.gestures.ViewUtils;
import io.sentry.internal.gestures.GestureTargetLocator;
import io.sentry.internal.gestures.UiElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AndroidViewGestureTargetLocator
implements GestureTargetLocator {
    private static final String ORIGIN = "old_view_system";
    private final boolean isAndroidXAvailable;
    private final int[] coordinates = new int[2];

    public AndroidViewGestureTargetLocator(boolean isAndroidXAvailable) {
        this.isAndroidXAvailable = isAndroidXAvailable;
    }

    @Nullable
    public UiElement locate(@NotNull Object root, float x, float y, UiElement.Type targetType) {
        if (!(root instanceof View)) {
            return null;
        }
        View view = (View)root;
        if (this.touchWithinBounds(view, x, y)) {
            if (targetType == UiElement.Type.CLICKABLE && AndroidViewGestureTargetLocator.isViewTappable(view)) {
                return this.createUiElement(view);
            }
            if (targetType == UiElement.Type.SCROLLABLE && AndroidViewGestureTargetLocator.isViewScrollable(view, this.isAndroidXAvailable)) {
                return this.createUiElement(view);
            }
        }
        return null;
    }

    private UiElement createUiElement(@NotNull View targetView) {
        try {
            String resourceName = ViewUtils.getResourceId(targetView);
            @Nullable String className = targetView.getClass().getCanonicalName();
            if (className == null) {
                className = targetView.getClass().getSimpleName();
            }
            return new UiElement((Object)targetView, className, resourceName, null, ORIGIN);
        }
        catch (Resources.NotFoundException ignored) {
            return null;
        }
    }

    private boolean touchWithinBounds(@NotNull View view, float x, float y) {
        view.getLocationOnScreen(this.coordinates);
        int vx = this.coordinates[0];
        int vy = this.coordinates[1];
        int w = view.getWidth();
        int h = view.getHeight();
        return !(x < (float)vx || x > (float)(vx + w) || y < (float)vy || y > (float)(vy + h));
    }

    private static boolean isViewTappable(@NotNull View view) {
        return view.isClickable() && view.getVisibility() == 0;
    }

    private static boolean isViewScrollable(@NotNull View view, boolean isAndroidXAvailable) {
        return (AndroidViewGestureTargetLocator.isJetpackScrollingView(view, isAndroidXAvailable) || AbsListView.class.isAssignableFrom(view.getClass()) || ScrollView.class.isAssignableFrom(view.getClass())) && view.getVisibility() == 0;
    }

    private static boolean isJetpackScrollingView(@NotNull View view, boolean isAndroidXAvailable) {
        if (!isAndroidXAvailable) {
            return false;
        }
        return ScrollingView.class.isAssignableFrom(view.getClass());
    }
}

