/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.gestures;

import android.app.Activity;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.Scope;
import io.sentry.SentryLevel;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.gestures.ViewUtils;
import io.sentry.internal.gestures.UiElement;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.util.TracingUtils;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class SentryGestureListener
implements GestureDetector.OnGestureListener {
    static final String UI_ACTION = "ui.action";
    @NotNull
    private final WeakReference<Activity> activityRef;
    @NotNull
    private final IHub hub;
    @NotNull
    private final SentryAndroidOptions options;
    @Nullable
    private UiElement activeUiElement = null;
    @Nullable
    private ITransaction activeTransaction = null;
    @Nullable
    private String activeEventType = null;
    private final ScrollState scrollState = new ScrollState();

    public SentryGestureListener(@NotNull Activity currentActivity, @NotNull IHub hub, @NotNull SentryAndroidOptions options) {
        this.activityRef = new WeakReference<Activity>(currentActivity);
        this.hub = hub;
        this.options = options;
    }

    public void onUp(@NotNull MotionEvent motionEvent) {
        View decorView = this.ensureWindowDecorView("onUp");
        UiElement scrollTarget = this.scrollState.target;
        if (decorView == null || scrollTarget == null) {
            return;
        }
        if (this.scrollState.type == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Unable to define scroll type. No breadcrumb captured.", new Object[0]);
            return;
        }
        String direction = this.scrollState.calculateDirection(motionEvent);
        this.addBreadcrumb(scrollTarget, this.scrollState.type, Collections.singletonMap("direction", direction), motionEvent);
        this.startTracing(scrollTarget, this.scrollState.type);
        this.scrollState.reset();
    }

    public boolean onDown(@Nullable MotionEvent motionEvent) {
        if (motionEvent == null) {
            return false;
        }
        this.scrollState.reset();
        this.scrollState.startX = motionEvent.getX();
        this.scrollState.startY = motionEvent.getY();
        return false;
    }

    public boolean onSingleTapUp(@Nullable MotionEvent motionEvent) {
        View decorView = this.ensureWindowDecorView("onSingleTapUp");
        if (decorView == null || motionEvent == null) {
            return false;
        }
        @Nullable UiElement target = ViewUtils.findTarget(this.options, decorView, motionEvent.getX(), motionEvent.getY(), UiElement.Type.CLICKABLE);
        if (target == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Unable to find click target. No breadcrumb captured.", new Object[0]);
            return false;
        }
        this.addBreadcrumb(target, "click", Collections.emptyMap(), motionEvent);
        this.startTracing(target, "click");
        return false;
    }

    public boolean onScroll(@Nullable MotionEvent firstEvent, @Nullable MotionEvent currentEvent, float distX, float distY) {
        View decorView = this.ensureWindowDecorView("onScroll");
        if (decorView == null || firstEvent == null) {
            return false;
        }
        if (this.scrollState.type == null) {
            @Nullable UiElement target = ViewUtils.findTarget(this.options, decorView, firstEvent.getX(), firstEvent.getY(), UiElement.Type.SCROLLABLE);
            if (target == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Unable to find scroll target. No breadcrumb captured.", new Object[0]);
                return false;
            }
            this.options.getLogger().log(SentryLevel.DEBUG, "Scroll target found: " + target.getIdentifier(), new Object[0]);
            this.scrollState.setTarget(target);
            this.scrollState.type = "scroll";
        }
        return false;
    }

    public boolean onFling(@Nullable MotionEvent motionEvent, @Nullable MotionEvent motionEvent1, float v, float v1) {
        this.scrollState.type = "swipe";
        return false;
    }

    public void onShowPress(MotionEvent motionEvent) {
    }

    public void onLongPress(MotionEvent motionEvent) {
    }

    private void addBreadcrumb(@NotNull UiElement target, @NotNull String eventType, @NotNull Map<String, Object> additionalData, @NotNull MotionEvent motionEvent) {
        if (!this.options.isEnableUserInteractionBreadcrumbs()) {
            return;
        }
        Hint hint = new Hint();
        hint.set("android:motionEvent", (Object)motionEvent);
        hint.set("android:view", target.getView());
        this.hub.addBreadcrumb(Breadcrumb.userInteraction((String)eventType, (String)target.getResourceName(), (String)target.getClassName(), (String)target.getTag(), additionalData), hint);
    }

    private void startTracing(@NotNull UiElement target, @NotNull String eventType) {
        UiElement uiElement = this.activeUiElement;
        if (!this.options.isTracingEnabled() || !this.options.isEnableUserInteractionTracing()) {
            if (!target.equals((Object)uiElement) || !eventType.equals(this.activeEventType)) {
                TracingUtils.startNewTrace((IHub)this.hub);
                this.activeUiElement = target;
                this.activeEventType = eventType;
            }
            return;
        }
        Activity activity = (Activity)this.activityRef.get();
        if (activity == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Activity is null, no transaction captured.", new Object[0]);
            return;
        }
        @Nullable String viewIdentifier = target.getIdentifier();
        if (this.activeTransaction != null) {
            if (target.equals((Object)uiElement) && eventType.equals(this.activeEventType) && !this.activeTransaction.isFinished()) {
                this.options.getLogger().log(SentryLevel.DEBUG, "The view with id: " + viewIdentifier + " already has an ongoing transaction assigned. Rescheduling finish", new Object[0]);
                Long idleTimeout = this.options.getIdleTimeout();
                if (idleTimeout != null) {
                    this.activeTransaction.scheduleFinish();
                }
                return;
            }
            this.stopTracing(SpanStatus.OK);
        }
        String name = this.getActivityName(activity) + "." + viewIdentifier;
        String op = "ui.action." + eventType;
        TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setWaitForChildren(true);
        transactionOptions.setIdleTimeout(this.options.getIdleTimeout());
        transactionOptions.setTrimEnd(true);
        ITransaction transaction = this.hub.startTransaction(new TransactionContext(name, TransactionNameSource.COMPONENT, op), transactionOptions);
        this.hub.configureScope(scope -> this.applyScope(scope, transaction));
        this.activeTransaction = transaction;
        this.activeUiElement = target;
        this.activeEventType = eventType;
    }

    void stopTracing(@NotNull SpanStatus status) {
        if (this.activeTransaction != null) {
            this.activeTransaction.finish(status);
        }
        this.hub.configureScope(scope -> this.clearScope(scope));
        this.activeTransaction = null;
        if (this.activeUiElement != null) {
            this.activeUiElement = null;
        }
        this.activeEventType = null;
    }

    @VisibleForTesting
    void clearScope(@NotNull Scope scope) {
        scope.withTransaction(transaction -> {
            if (transaction == this.activeTransaction) {
                scope.clearTransaction();
            }
        });
    }

    @VisibleForTesting
    void applyScope(@NotNull Scope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == null) {
                scope.setTransaction(transaction);
            } else {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction '%s' won't be bound to the Scope since there's one already in there.", new Object[]{transaction.getName()});
            }
        });
    }

    @NotNull
    private String getActivityName(@NotNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    @Nullable
    private View ensureWindowDecorView(@NotNull String caller) {
        Activity activity = (Activity)this.activityRef.get();
        if (activity == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Activity is null in " + caller + ". No breadcrumb captured.", new Object[0]);
            return null;
        }
        Window window = activity.getWindow();
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window is null in " + caller + ". No breadcrumb captured.", new Object[0]);
            return null;
        }
        View decorView = window.getDecorView();
        if (decorView == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "DecorView is null in " + caller + ". No breadcrumb captured.", new Object[0]);
            return null;
        }
        return decorView;
    }

    private static final class ScrollState {
        @Nullable
        private String type = null;
        @Nullable
        private UiElement target;
        private float startX = 0.0f;
        private float startY = 0.0f;

        private ScrollState() {
        }

        private void setTarget(@NotNull UiElement target) {
            this.target = target;
        }

        @NotNull
        private String calculateDirection(MotionEvent endEvent) {
            float diffX = endEvent.getX() - this.startX;
            float diffY = endEvent.getY() - this.startY;
            String direction = Math.abs(diffX) > Math.abs(diffY) ? (diffX > 0.0f ? "right" : "left") : (diffY > 0.0f ? "down" : "up");
            return direction;
        }

        private void reset() {
            this.target = null;
            this.type = null;
            this.startX = 0.0f;
            this.startY = 0.0f;
        }
    }
}

