/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.annotation.WorkerThread;
import io.sentry.BackfillingEventProcessor;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.JsonDeserializer;
import io.sentry.SentryBaseEvent;
import io.sentry.SentryEvent;
import io.sentry.SentryExceptionFactory;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryStackTraceFactory;
import io.sentry.SpanContext;
import io.sentry.android.core.ApplicationNotResponding;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.Installation;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.CpuInfoUtils;
import io.sentry.cache.PersistingOptionsObserver;
import io.sentry.cache.PersistingScopeObserver;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Backfillable;
import io.sentry.protocol.App;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.DebugImage;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.Device;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.OperatingSystem;
import io.sentry.protocol.Request;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.protocol.SentryThread;
import io.sentry.protocol.User;
import io.sentry.util.HintUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@WorkerThread
public final class AnrV2EventProcessor
implements BackfillingEventProcessor {
    static final String DEFAULT_ENVIRONMENT = "production";
    @NotNull
    private final Context context;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @NotNull
    private final SentryExceptionFactory sentryExceptionFactory;

    public AnrV2EventProcessor(@NotNull Context context, @NotNull SentryAndroidOptions options, @NotNull BuildInfoProvider buildInfoProvider) {
        this.context = context;
        this.options = options;
        this.buildInfoProvider = buildInfoProvider;
        SentryStackTraceFactory sentryStackTraceFactory = new SentryStackTraceFactory((SentryOptions)this.options);
        this.sentryExceptionFactory = new SentryExceptionFactory(sentryStackTraceFactory);
    }

    @Nullable
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        Object unwrappedHint = HintUtils.getSentrySdkHint((Hint)hint);
        if (!(unwrappedHint instanceof Backfillable)) {
            this.options.getLogger().log(SentryLevel.WARNING, "The event is not Backfillable, but has been passed to BackfillingEventProcessor, skipping.", new Object[0]);
            return event;
        }
        this.setExceptions(event, unwrappedHint);
        this.setPlatform((SentryBaseEvent)event);
        this.mergeOS((SentryBaseEvent)event);
        this.setDevice((SentryBaseEvent)event);
        if (!((Backfillable)unwrappedHint).shouldEnrich()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "The event is Backfillable, but should not be enriched, skipping.", new Object[0]);
            return event;
        }
        this.backfillScope(event);
        this.backfillOptions(event, unwrappedHint);
        this.setStaticValues(event);
        return event;
    }

    private void backfillScope(@NotNull SentryEvent event) {
        this.setRequest((SentryBaseEvent)event);
        this.setUser((SentryBaseEvent)event);
        this.setScopeTags((SentryBaseEvent)event);
        this.setBreadcrumbs((SentryBaseEvent)event);
        this.setExtras((SentryBaseEvent)event);
        this.setContexts((SentryBaseEvent)event);
        this.setTransaction(event);
        this.setFingerprints(event);
        this.setLevel(event);
        this.setTrace(event);
    }

    private void setTrace(@NotNull SentryEvent event) {
        SpanContext spanContext = (SpanContext)PersistingScopeObserver.read((SentryOptions)this.options, (String)"trace.json", SpanContext.class);
        if (event.getContexts().getTrace() == null && spanContext != null && spanContext.getSpanId() != null && spanContext.getTraceId() != null) {
            event.getContexts().setTrace(spanContext);
        }
    }

    private void setLevel(@NotNull SentryEvent event) {
        SentryLevel level = (SentryLevel)PersistingScopeObserver.read((SentryOptions)this.options, (String)"level.json", SentryLevel.class);
        if (event.getLevel() == null) {
            event.setLevel(level);
        }
    }

    private void setFingerprints(@NotNull SentryEvent event) {
        List fingerprint = (List)PersistingScopeObserver.read((SentryOptions)this.options, (String)"fingerprint.json", List.class);
        if (event.getFingerprints() == null) {
            event.setFingerprints(fingerprint);
        }
    }

    private void setTransaction(@NotNull SentryEvent event) {
        String transaction = (String)PersistingScopeObserver.read((SentryOptions)this.options, (String)"transaction.json", String.class);
        if (event.getTransaction() == null) {
            event.setTransaction(transaction);
        }
    }

    private void setContexts(@NotNull SentryBaseEvent event) {
        Contexts persistedContexts = (Contexts)PersistingScopeObserver.read((SentryOptions)this.options, (String)"contexts.json", Contexts.class);
        if (persistedContexts == null) {
            return;
        }
        Contexts eventContexts = event.getContexts();
        for (Map.Entry entry : new Contexts(persistedContexts).entrySet()) {
            Object value = entry.getValue();
            if ("trace".equals(entry.getKey()) && value instanceof SpanContext || eventContexts.containsKey(entry.getKey())) continue;
            eventContexts.put((Object)((String)entry.getKey()), value);
        }
    }

    private void setExtras(@NotNull SentryBaseEvent event) {
        Map extras = (Map)PersistingScopeObserver.read((SentryOptions)this.options, (String)"extras.json", Map.class);
        if (extras == null) {
            return;
        }
        if (event.getExtras() == null) {
            event.setExtras(new HashMap(extras));
        } else {
            for (Map.Entry item : extras.entrySet()) {
                if (event.getExtras().containsKey(item.getKey())) continue;
                event.getExtras().put((String)item.getKey(), item.getValue());
            }
        }
    }

    private void setBreadcrumbs(@NotNull SentryBaseEvent event) {
        List breadcrumbs = (List)PersistingScopeObserver.read((SentryOptions)this.options, (String)"breadcrumbs.json", List.class, (JsonDeserializer)new Breadcrumb.Deserializer());
        if (breadcrumbs == null) {
            return;
        }
        if (event.getBreadcrumbs() == null) {
            event.setBreadcrumbs(new ArrayList(breadcrumbs));
        } else {
            event.getBreadcrumbs().addAll(breadcrumbs);
        }
    }

    private void setScopeTags(@NotNull SentryBaseEvent event) {
        Map tags = (Map)PersistingScopeObserver.read((SentryOptions)this.options, (String)"tags.json", Map.class);
        if (tags == null) {
            return;
        }
        if (event.getTags() == null) {
            event.setTags(new HashMap(tags));
        } else {
            for (Map.Entry item : tags.entrySet()) {
                if (event.getTags().containsKey(item.getKey())) continue;
                event.setTag((String)item.getKey(), (String)item.getValue());
            }
        }
    }

    private void setUser(@NotNull SentryBaseEvent event) {
        if (event.getUser() == null) {
            User user = (User)PersistingScopeObserver.read((SentryOptions)this.options, (String)"user.json", User.class);
            event.setUser(user);
        }
    }

    private void setRequest(@NotNull SentryBaseEvent event) {
        if (event.getRequest() == null) {
            Request request = (Request)PersistingScopeObserver.read((SentryOptions)this.options, (String)"request.json", Request.class);
            event.setRequest(request);
        }
    }

    private void backfillOptions(@NotNull SentryEvent event, @NotNull Object hint) {
        this.setRelease((SentryBaseEvent)event);
        this.setEnvironment((SentryBaseEvent)event);
        this.setDist((SentryBaseEvent)event);
        this.setDebugMeta((SentryBaseEvent)event);
        this.setSdk((SentryBaseEvent)event);
        this.setApp((SentryBaseEvent)event, hint);
        this.setOptionsTags((SentryBaseEvent)event);
    }

    private void setApp(@NotNull SentryBaseEvent event, @NotNull Object hint) {
        String release;
        App app = event.getContexts().getApp();
        if (app == null) {
            app = new App();
        }
        app.setAppName(ContextUtils.getApplicationName(this.context, this.options.getLogger()));
        app.setInForeground(Boolean.valueOf(!this.isBackgroundAnr(hint)));
        PackageInfo packageInfo = ContextUtils.getPackageInfo(this.context, this.options.getLogger(), this.buildInfoProvider);
        if (packageInfo != null) {
            app.setAppIdentifier(packageInfo.packageName);
        }
        String string = release = event.getRelease() != null ? event.getRelease() : (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"release.json", String.class);
        if (release != null) {
            try {
                String versionName = release.substring(release.indexOf(64) + 1, release.indexOf(43));
                String versionCode = release.substring(release.indexOf(43) + 1);
                app.setAppVersion(versionName);
                app.setAppBuild(versionCode);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to parse release from scope cache: %s", new Object[]{release});
            }
        }
        event.getContexts().setApp(app);
    }

    private void setRelease(@NotNull SentryBaseEvent event) {
        if (event.getRelease() == null) {
            String release = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"release.json", String.class);
            event.setRelease(release);
        }
    }

    private void setEnvironment(@NotNull SentryBaseEvent event) {
        if (event.getEnvironment() == null) {
            String environment = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"environment.json", String.class);
            event.setEnvironment(environment != null ? environment : DEFAULT_ENVIRONMENT);
        }
    }

    private void setDebugMeta(@NotNull SentryBaseEvent event) {
        List images;
        DebugMeta debugMeta = event.getDebugMeta();
        if (debugMeta == null) {
            debugMeta = new DebugMeta();
        }
        if (debugMeta.getImages() == null) {
            debugMeta.setImages(new ArrayList());
        }
        if ((images = debugMeta.getImages()) != null) {
            String proguardUuid = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"proguard-uuid.json", String.class);
            if (proguardUuid != null) {
                DebugImage debugImage = new DebugImage();
                debugImage.setType("proguard");
                debugImage.setUuid(proguardUuid);
                images.add(debugImage);
            }
            event.setDebugMeta(debugMeta);
        }
    }

    private void setDist(@NotNull SentryBaseEvent event) {
        String release;
        if (event.getDist() == null) {
            String dist = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"dist.json", String.class);
            event.setDist(dist);
        }
        if (event.getDist() == null && (release = (String)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"release.json", String.class)) != null) {
            try {
                String versionCode = release.substring(release.indexOf(43) + 1);
                event.setDist(versionCode);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to parse release from scope cache: %s", new Object[]{release});
            }
        }
    }

    private void setSdk(@NotNull SentryBaseEvent event) {
        if (event.getSdk() == null) {
            SdkVersion sdkVersion = (SdkVersion)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"sdk-version.json", SdkVersion.class);
            event.setSdk(sdkVersion);
        }
    }

    private void setOptionsTags(@NotNull SentryBaseEvent event) {
        Map tags = (Map)PersistingOptionsObserver.read((SentryOptions)this.options, (String)"tags.json", Map.class);
        if (tags == null) {
            return;
        }
        if (event.getTags() == null) {
            event.setTags(new HashMap(tags));
        } else {
            for (Map.Entry item : tags.entrySet()) {
                if (event.getTags().containsKey(item.getKey())) continue;
                event.setTag((String)item.getKey(), (String)item.getValue());
            }
        }
    }

    private void setStaticValues(@NotNull SentryEvent event) {
        this.mergeUser((SentryBaseEvent)event);
        this.setSideLoadedInfo((SentryBaseEvent)event);
    }

    private void setPlatform(@NotNull SentryBaseEvent event) {
        if (event.getPlatform() == null) {
            event.setPlatform("java");
        }
    }

    @Nullable
    private SentryThread findMainThread(@Nullable List<SentryThread> threads) {
        if (threads != null) {
            for (SentryThread thread : threads) {
                String name = thread.getName();
                if (name == null || !name.equals("main")) continue;
                return thread;
            }
        }
        return null;
    }

    private boolean isBackgroundAnr(@NotNull Object hint) {
        if (hint instanceof AbnormalExit) {
            String abnormalMechanism = ((AbnormalExit)hint).mechanism();
            return "anr_background".equals(abnormalMechanism);
        }
        return false;
    }

    private void setExceptions(@NotNull SentryEvent event, @NotNull Object hint) {
        Mechanism mechanism = new Mechanism();
        if (!((Backfillable)hint).shouldEnrich()) {
            mechanism.setType("HistoricalAppExitInfo");
        } else {
            mechanism.setType("AppExitInfo");
        }
        boolean isBackgroundAnr = this.isBackgroundAnr(hint);
        String message = "ANR";
        if (isBackgroundAnr) {
            message = "Background " + message;
        }
        ApplicationNotResponding anr = new ApplicationNotResponding(message, Thread.currentThread());
        SentryThread mainThread = this.findMainThread(event.getThreads());
        if (mainThread == null) {
            mainThread = new SentryThread();
            mainThread.setStacktrace(new SentryStackTrace());
        }
        event.setExceptions(this.sentryExceptionFactory.getSentryExceptionsFromThread(mainThread, mechanism, (Throwable)anr));
    }

    private void mergeUser(@NotNull SentryBaseEvent event) {
        User user;
        if (this.options.isSendDefaultPii()) {
            if (event.getUser() == null) {
                user = new User();
                user.setIpAddress("{{auto}}");
                event.setUser(user);
            } else if (event.getUser().getIpAddress() == null) {
                event.getUser().setIpAddress("{{auto}}");
            }
        }
        if ((user = event.getUser()) == null) {
            event.setUser(this.getDefaultUser());
        } else if (user.getId() == null) {
            user.setId(this.getDeviceId());
        }
    }

    @NotNull
    private User getDefaultUser() {
        User user = new User();
        user.setId(this.getDeviceId());
        return user;
    }

    @Nullable
    private String getDeviceId() {
        try {
            return Installation.id(this.context);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting installationId.", e);
            return null;
        }
    }

    private void setSideLoadedInfo(@NotNull SentryBaseEvent event) {
        try {
            Map<String, String> sideLoadedInfo = ContextUtils.getSideLoadedInfo(this.context, this.options.getLogger(), this.buildInfoProvider);
            if (sideLoadedInfo != null) {
                for (Map.Entry<String, String> entry : sideLoadedInfo.entrySet()) {
                    event.setTag(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting side loaded info.", e);
        }
    }

    private void setDevice(@NotNull SentryBaseEvent event) {
        if (event.getContexts().getDevice() == null) {
            event.getContexts().setDevice(this.getDevice());
        }
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    private Device getDevice() {
        List<Integer> cpuFrequencies;
        Device device = new Device();
        if (this.options.isSendDefaultPii()) {
            device.setName(ContextUtils.getDeviceName(this.context, this.buildInfoProvider));
        }
        device.setManufacturer(Build.MANUFACTURER);
        device.setBrand(Build.BRAND);
        device.setFamily(ContextUtils.getFamily(this.options.getLogger()));
        device.setModel(Build.MODEL);
        device.setModelId(Build.ID);
        device.setArchs(ContextUtils.getArchitectures(this.buildInfoProvider));
        ActivityManager.MemoryInfo memInfo = ContextUtils.getMemInfo(this.context, this.options.getLogger());
        if (memInfo != null) {
            device.setMemorySize(this.getMemorySize(memInfo));
        }
        device.setSimulator(this.buildInfoProvider.isEmulator());
        DisplayMetrics displayMetrics = ContextUtils.getDisplayMetrics(this.context, this.options.getLogger());
        if (displayMetrics != null) {
            device.setScreenWidthPixels(Integer.valueOf(displayMetrics.widthPixels));
            device.setScreenHeightPixels(Integer.valueOf(displayMetrics.heightPixels));
            device.setScreenDensity(Float.valueOf(displayMetrics.density));
            device.setScreenDpi(Integer.valueOf(displayMetrics.densityDpi));
        }
        if (device.getId() == null) {
            device.setId(this.getDeviceId());
        }
        if (!(cpuFrequencies = CpuInfoUtils.getInstance().readMaxFrequencies()).isEmpty()) {
            device.setProcessorFrequency(Double.valueOf(Collections.max(cpuFrequencies).doubleValue()));
            device.setProcessorCount(Integer.valueOf(cpuFrequencies.size()));
        }
        return device;
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    private Long getMemorySize(@NotNull ActivityManager.MemoryInfo memInfo) {
        if (this.buildInfoProvider.getSdkInfoVersion() >= 16) {
            return memInfo.totalMem;
        }
        return Runtime.getRuntime().totalMemory();
    }

    private void mergeOS(@NotNull SentryBaseEvent event) {
        OperatingSystem currentOS = event.getContexts().getOperatingSystem();
        OperatingSystem androidOS = this.getOperatingSystem();
        event.getContexts().setOperatingSystem(androidOS);
        if (currentOS != null) {
            String osNameKey = currentOS.getName();
            osNameKey = osNameKey != null && !osNameKey.isEmpty() ? "os_" + osNameKey.trim().toLowerCase(Locale.ROOT) : "os_1";
            event.getContexts().put((Object)osNameKey, (Object)currentOS);
        }
    }

    @NotNull
    private OperatingSystem getOperatingSystem() {
        OperatingSystem os = new OperatingSystem();
        os.setName("Android");
        os.setVersion(Build.VERSION.RELEASE);
        os.setBuild(Build.DISPLAY);
        try {
            os.setKernelVersion(ContextUtils.getKernelVersion(this.options.getLogger()));
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting OperatingSystem.", e);
        }
        return os;
    }
}

