/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.content.Context;
import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.Integration;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.cache.AndroidEnvelopeCache;
import io.sentry.android.core.internal.threaddump.Lines;
import io.sentry.android.core.internal.threaddump.ThreadDumpParser;
import io.sentry.cache.EnvelopeCache;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.hints.AbnormalExit;
import io.sentry.hints.Backfillable;
import io.sentry.hints.BlockingFlushHint;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryThread;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressLint(value={"NewApi"})
public class AnrV2Integration
implements Integration,
Closeable {
    static final long NINETY_DAYS_THRESHOLD = TimeUnit.DAYS.toMillis(91L);
    @NotNull
    private final Context context;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @Nullable
    private SentryAndroidOptions options;

    public AnrV2Integration(@NotNull Context context) {
        this(context, CurrentDateProvider.getInstance());
    }

    AnrV2Integration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider) {
        this.context = context;
        this.dateProvider = dateProvider;
    }

    @SuppressLint(value={"NewApi"})
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "AnrIntegration enabled: %s", new Object[]{this.options.isAnrEnabled()});
        if (this.options.getCacheDirPath() == null) {
            this.options.getLogger().log(SentryLevel.INFO, "Cache dir is not set, unable to process ANRs", new Object[0]);
            return;
        }
        if (this.options.isAnrEnabled()) {
            try {
                options.getExecutorService().submit((Runnable)new AnrProcessor(this.context, hub, this.options, this.dateProvider));
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.DEBUG, "Failed to start AnrProcessor.", e);
            }
            options.getLogger().log(SentryLevel.DEBUG, "AnrV2Integration installed.", new Object[0]);
            this.addIntegrationToSdkVersion();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "AnrV2Integration removed.", new Object[0]);
        }
    }

    static class AnrProcessor
    implements Runnable {
        @NotNull
        private final Context context;
        @NotNull
        private final IHub hub;
        @NotNull
        private final SentryAndroidOptions options;
        private final long threshold;

        AnrProcessor(@NotNull Context context, @NotNull IHub hub, @NotNull SentryAndroidOptions options, @NotNull ICurrentDateProvider dateProvider) {
            this.context = context;
            this.hub = hub;
            this.options = options;
            this.threshold = dateProvider.getCurrentTimeMillis() - NINETY_DAYS_THRESHOLD;
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public void run() {
            ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
            List applicationExitInfoList = activityManager.getHistoricalProcessExitReasons(null, 0, 0);
            if (applicationExitInfoList.size() == 0) {
                this.options.getLogger().log(SentryLevel.DEBUG, "No records in historical exit reasons.", new Object[0]);
                return;
            }
            IEnvelopeCache cache = this.options.getEnvelopeDiskCache();
            if (cache instanceof EnvelopeCache && this.options.isEnableAutoSessionTracking() && !((EnvelopeCache)cache).waitPreviousSessionFlush()) {
                this.options.getLogger().log(SentryLevel.WARNING, "Timed out waiting to flush previous session to its own file.", new Object[0]);
                ((EnvelopeCache)cache).flushPreviousSession();
            }
            ArrayList<ApplicationExitInfo> exitInfos = new ArrayList<ApplicationExitInfo>(applicationExitInfoList);
            @Nullable Long lastReportedAnrTimestamp = AndroidEnvelopeCache.lastReportedAnr(this.options);
            ApplicationExitInfo latestAnr = null;
            for (ApplicationExitInfo applicationExitInfo : exitInfos) {
                if (applicationExitInfo.getReason() != 6) continue;
                latestAnr = applicationExitInfo;
                exitInfos.remove(applicationExitInfo);
                break;
            }
            if (latestAnr == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "No ANRs have been found in the historical exit reasons list.", new Object[0]);
                return;
            }
            if (latestAnr.getTimestamp() < this.threshold) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Latest ANR happened too long ago, returning early.", new Object[0]);
                return;
            }
            if (lastReportedAnrTimestamp != null && latestAnr.getTimestamp() <= lastReportedAnrTimestamp) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Latest ANR has already been reported, returning early.", new Object[0]);
                return;
            }
            this.reportNonEnrichedHistoricalAnrs(exitInfos, lastReportedAnrTimestamp);
            this.reportAsSentryEvent(latestAnr, true);
        }

        private void reportNonEnrichedHistoricalAnrs(@NotNull List<ApplicationExitInfo> exitInfos, @Nullable Long lastReportedAnr) {
            Collections.reverse(exitInfos);
            for (ApplicationExitInfo applicationExitInfo : exitInfos) {
                if (applicationExitInfo.getReason() != 6) continue;
                if (applicationExitInfo.getTimestamp() < this.threshold) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "ANR happened too long ago %s.", new Object[]{applicationExitInfo});
                    continue;
                }
                if (lastReportedAnr != null && applicationExitInfo.getTimestamp() <= lastReportedAnr) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "ANR has already been reported %s.", new Object[]{applicationExitInfo});
                    continue;
                }
                this.reportAsSentryEvent(applicationExitInfo, false);
            }
        }

        private void reportAsSentryEvent(@NotNull ApplicationExitInfo exitInfo, boolean shouldEnrich) {
            long anrTimestamp = exitInfo.getTimestamp();
            boolean isBackground = exitInfo.getImportance() != 100;
            List<SentryThread> threads = this.parseThreadDump(exitInfo, isBackground);
            AnrV2Hint anrHint = new AnrV2Hint(this.options.getFlushTimeoutMillis(), this.options.getLogger(), anrTimestamp, shouldEnrich, isBackground);
            Hint hint = HintUtils.createWithTypeCheckHint((Object)((Object)anrHint));
            SentryEvent event = new SentryEvent();
            event.setThreads(threads);
            event.setTimestamp(DateUtils.getDateTime((long)anrTimestamp));
            event.setLevel(SentryLevel.FATAL);
            @NotNull SentryId sentryId = this.hub.captureEvent(event, hint);
            boolean isEventDropped = sentryId.equals((Object)SentryId.EMPTY_ID);
            if (!isEventDropped && !anrHint.waitFlush()) {
                this.options.getLogger().log(SentryLevel.WARNING, "Timed out waiting to flush ANR event to disk. Event: %s", new Object[]{event.getEventId()});
            }
        }

        @Nullable
        private List<SentryThread> parseThreadDump(@NotNull ApplicationExitInfo exitInfo, boolean isBackground) {
            List<SentryThread> threads = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(exitInfo.getTraceInputStream()));){
                Lines lines = Lines.readLines(reader);
                ThreadDumpParser threadDumpParser = new ThreadDumpParser(this.options, isBackground);
                threads = threadDumpParser.parse(lines);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to parse ANR thread dump", e);
            }
            return threads;
        }
    }

    @ApiStatus.Internal
    public static final class AnrV2Hint
    extends BlockingFlushHint
    implements Backfillable,
    AbnormalExit {
        private final long timestamp;
        private final boolean shouldEnrich;
        private final boolean isBackgroundAnr;

        public AnrV2Hint(long flushTimeoutMillis, @NotNull ILogger logger, long timestamp, boolean shouldEnrich, boolean isBackgroundAnr) {
            super(flushTimeoutMillis, logger);
            this.timestamp = timestamp;
            this.shouldEnrich = shouldEnrich;
            this.isBackgroundAnr = isBackgroundAnr;
        }

        public Long timestamp() {
            return this.timestamp;
        }

        public boolean shouldEnrich() {
            return this.shouldEnrich;
        }

        public String mechanism() {
            return this.isBackgroundAnr ? "anr_background" : "anr_foreground";
        }
    }
}

