/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import io.sentry.Attachment;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.ILogger;
import io.sentry.ISerializer;
import io.sentry.IntegrationName;
import io.sentry.JsonSerializable;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.android.core.CurrentActivityHolder;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.gestures.ViewUtils;
import io.sentry.android.core.internal.util.AndroidMainThreadChecker;
import io.sentry.protocol.ViewHierarchy;
import io.sentry.protocol.ViewHierarchyNode;
import io.sentry.util.HintUtils;
import io.sentry.util.JsonSerializationUtils;
import io.sentry.util.Objects;
import io.sentry.util.thread.IMainThreadChecker;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ViewHierarchyEventProcessor
implements EventProcessor,
IntegrationName {
    @NotNull
    private final SentryAndroidOptions options;
    private static final long CAPTURE_TIMEOUT_MS = 1000L;

    public ViewHierarchyEventProcessor(@NotNull SentryAndroidOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)options), (String)"SentryAndroidOptions is required"));
        if (options.isAttachViewHierarchy()) {
            this.addIntegrationToSdkVersion();
        }
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        if (!event.isErrored()) {
            return event;
        }
        if (!this.options.isAttachViewHierarchy()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "attachViewHierarchy is disabled.", new Object[0]);
            return event;
        }
        if (HintUtils.isFromHybridSdk((Hint)hint)) {
            return event;
        }
        @Nullable Activity activity = CurrentActivityHolder.getInstance().getActivity();
        @Nullable ViewHierarchy viewHierarchy = ViewHierarchyEventProcessor.snapshotViewHierarchy(activity, this.options.getMainThreadChecker(), this.options.getLogger());
        if (viewHierarchy != null) {
            hint.setViewHierarchy(Attachment.fromViewHierarchy((ViewHierarchy)viewHierarchy));
        }
        return event;
    }

    public static byte[] snapshotViewHierarchyAsData(@Nullable Activity activity, @NotNull IMainThreadChecker mainThreadChecker, @NotNull ISerializer serializer, @NotNull ILogger logger) {
        @Nullable ViewHierarchy viewHierarchy = ViewHierarchyEventProcessor.snapshotViewHierarchy(activity, mainThreadChecker, logger);
        if (viewHierarchy == null) {
            logger.log(SentryLevel.ERROR, "Could not get ViewHierarchy.", new Object[0]);
            return null;
        }
        @Nullable byte[] bytes = JsonSerializationUtils.bytesFrom((ISerializer)serializer, (ILogger)logger, (JsonSerializable)viewHierarchy);
        if (bytes == null) {
            logger.log(SentryLevel.ERROR, "Could not serialize ViewHierarchy.", new Object[0]);
            return null;
        }
        if (bytes.length < 1) {
            logger.log(SentryLevel.ERROR, "Got empty bytes array after serializing ViewHierarchy.", new Object[0]);
            return null;
        }
        return bytes;
    }

    @Nullable
    public static ViewHierarchy snapshotViewHierarchy(@Nullable Activity activity, @NotNull ILogger logger) {
        return ViewHierarchyEventProcessor.snapshotViewHierarchy(activity, AndroidMainThreadChecker.getInstance(), logger);
    }

    @Nullable
    public static ViewHierarchy snapshotViewHierarchy(@Nullable Activity activity, @NotNull IMainThreadChecker mainThreadChecker, @NotNull ILogger logger) {
        if (activity == null) {
            logger.log(SentryLevel.INFO, "Missing activity for view hierarchy snapshot.", new Object[0]);
            return null;
        }
        @Nullable Window window = activity.getWindow();
        if (window == null) {
            logger.log(SentryLevel.INFO, "Missing window for view hierarchy snapshot.", new Object[0]);
            return null;
        }
        @Nullable View decorView = window.peekDecorView();
        if (decorView == null) {
            logger.log(SentryLevel.INFO, "Missing decor view for view hierarchy snapshot.", new Object[0]);
            return null;
        }
        try {
            if (mainThreadChecker.isMainThread()) {
                return ViewHierarchyEventProcessor.snapshotViewHierarchy(decorView);
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<Object> viewHierarchy = new AtomicReference<Object>(null);
            activity.runOnUiThread(() -> {
                try {
                    viewHierarchy.set(ViewHierarchyEventProcessor.snapshotViewHierarchy(decorView));
                    latch.countDown();
                }
                catch (Throwable t) {
                    logger.log(SentryLevel.ERROR, "Failed to process view hierarchy.", t);
                }
            });
            if (latch.await(1000L, TimeUnit.MILLISECONDS)) {
                return viewHierarchy.get();
            }
        }
        catch (Throwable t) {
            logger.log(SentryLevel.ERROR, "Failed to process view hierarchy.", t);
        }
        return null;
    }

    @NotNull
    public static ViewHierarchy snapshotViewHierarchy(@NotNull View view) {
        ArrayList<ViewHierarchyNode> windows = new ArrayList<ViewHierarchyNode>(1);
        ViewHierarchy viewHierarchy = new ViewHierarchy("android_view_system", windows);
        @NotNull ViewHierarchyNode node = ViewHierarchyEventProcessor.viewToNode(view);
        windows.add(node);
        ViewHierarchyEventProcessor.addChildren(view, node);
        return viewHierarchy;
    }

    private static void addChildren(@NotNull View view, @NotNull ViewHierarchyNode parentNode) {
        if (!(view instanceof ViewGroup)) {
            return;
        }
        @NotNull ViewGroup viewGroup = (ViewGroup)view;
        int childCount = viewGroup.getChildCount();
        if (childCount == 0) {
            return;
        }
        @NotNull ArrayList<ViewHierarchyNode> childNodes = new ArrayList<ViewHierarchyNode>(childCount);
        for (int i = 0; i < childCount; ++i) {
            @Nullable View child = viewGroup.getChildAt(i);
            if (child == null) continue;
            @NotNull ViewHierarchyNode childNode = ViewHierarchyEventProcessor.viewToNode(child);
            childNodes.add(childNode);
            ViewHierarchyEventProcessor.addChildren(child, childNode);
        }
        parentNode.setChildren(childNodes);
    }

    @NotNull
    private static ViewHierarchyNode viewToNode(@NotNull View view) {
        @NotNull ViewHierarchyNode node = new ViewHierarchyNode();
        @Nullable String className = view.getClass().getCanonicalName();
        if (className == null) {
            className = view.getClass().getSimpleName();
        }
        node.setType(className);
        try {
            String identifier = ViewUtils.getResourceId(view);
            node.setIdentifier(identifier);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        node.setX(Double.valueOf(view.getX()));
        node.setY(Double.valueOf(view.getY()));
        node.setWidth(Double.valueOf(view.getWidth()));
        node.setHeight(Double.valueOf(view.getHeight()));
        node.setAlpha(Double.valueOf(view.getAlpha()));
        switch (view.getVisibility()) {
            case 0: {
                node.setVisibility("visible");
                break;
            }
            case 4: {
                node.setVisibility("invisible");
                break;
            }
            case 8: {
                node.setVisibility("gone");
                break;
            }
        }
        return node;
    }
}

