/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import android.util.DisplayMetrics;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ContextUtils {
    private ContextUtils() {
    }

    @Nullable
    static PackageInfo getPackageInfo(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        return ContextUtils.getPackageInfo(context, 0, logger, buildInfoProvider);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    static PackageInfo getPackageInfo(@NotNull Context context, int flags, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        try {
            if (buildInfoProvider.getSdkInfoVersion() >= 33) {
                return context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.PackageInfoFlags.of((long)flags));
            }
            return context.getPackageManager().getPackageInfo(context.getPackageName(), flags);
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Error getting package info.", e);
            return null;
        }
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    static ApplicationInfo getApplicationInfo(@NotNull Context context, long flag, @NotNull BuildInfoProvider buildInfoProvider) throws PackageManager.NameNotFoundException {
        if (buildInfoProvider.getSdkInfoVersion() >= 33) {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.ApplicationInfoFlags.of((long)flag));
        }
        return context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    static String getVersionCode(@NotNull PackageInfo packageInfo, @NotNull BuildInfoProvider buildInfoProvider) {
        if (buildInfoProvider.getSdkInfoVersion() >= 28) {
            return Long.toString(packageInfo.getLongVersionCode());
        }
        return ContextUtils.getVersionCodeDep(packageInfo);
    }

    @Nullable
    static String getVersionName(@NotNull PackageInfo packageInfo) {
        return packageInfo.versionName;
    }

    @NotNull
    private static String getVersionCodeDep(@NotNull PackageInfo packageInfo) {
        return Integer.toString(packageInfo.versionCode);
    }

    static boolean isForegroundImportance(@NotNull Context context) {
        try {
            ActivityManager activityManager;
            List runningAppProcesses;
            Object service = context.getSystemService("activity");
            if (service instanceof ActivityManager && (runningAppProcesses = (activityManager = (ActivityManager)service).getRunningAppProcesses()) != null) {
                int myPid = Process.myPid();
                for (ActivityManager.RunningAppProcessInfo processInfo : runningAppProcesses) {
                    if (processInfo.pid != myPid) continue;
                    if (processInfo.importance != 100) break;
                    return true;
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    static String getKernelVersion(@NotNull ILogger logger) {
        String string;
        String errorMsg = "Exception while attempting to read kernel information";
        String defaultVersion = System.getProperty("os.version");
        File file = new File("/proc/version");
        if (!file.canRead()) {
            return defaultVersion;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            string = br.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.log(SentryLevel.ERROR, "Exception while attempting to read kernel information", (Throwable)e);
                return defaultVersion;
            }
        }
        br.close();
        return string;
    }

    @Nullable
    static Map<String, String> getSideLoadedInfo(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        String packageName = null;
        try {
            PackageInfo packageInfo = ContextUtils.getPackageInfo(context, logger, buildInfoProvider);
            PackageManager packageManager = context.getPackageManager();
            if (packageInfo != null && packageManager != null) {
                packageName = packageInfo.packageName;
                String installerPackageName = packageManager.getInstallerPackageName(packageName);
                HashMap<String, String> sideLoadedInfo = new HashMap<String, String>();
                if (installerPackageName != null) {
                    sideLoadedInfo.put("isSideLoaded", "false");
                    sideLoadedInfo.put("installerStore", installerPackageName);
                } else {
                    sideLoadedInfo.put("isSideLoaded", "true");
                }
                return sideLoadedInfo;
            }
        }
        catch (IllegalArgumentException e) {
            logger.log(SentryLevel.DEBUG, "%s package isn't installed.", new Object[]{packageName});
        }
        return null;
    }

    @Nullable
    static String getApplicationName(@NotNull Context context, @NotNull ILogger logger) {
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            if (stringId == 0) {
                if (applicationInfo.nonLocalizedLabel != null) {
                    return applicationInfo.nonLocalizedLabel.toString();
                }
                return context.getPackageManager().getApplicationLabel(applicationInfo).toString();
            }
            return context.getString(stringId);
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Error getting application name.", e);
            return null;
        }
    }

    @Nullable
    static DisplayMetrics getDisplayMetrics(@NotNull Context context, @NotNull ILogger logger) {
        try {
            return context.getResources().getDisplayMetrics();
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Error getting DisplayMetrics.", e);
            return null;
        }
    }

    @Nullable
    static String getFamily(@NotNull ILogger logger) {
        try {
            return Build.MODEL.split(" ", -1)[0];
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Error getting device family.", e);
            return null;
        }
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    static String getDeviceName(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider) {
        if (buildInfoProvider.getSdkInfoVersion() >= 17) {
            return Settings.Global.getString((ContentResolver)context.getContentResolver(), (String)"device_name");
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    static String[] getArchitectures(@NotNull BuildInfoProvider buildInfoProvider) {
        String[] supportedAbis = buildInfoProvider.getSdkInfoVersion() >= 21 ? Build.SUPPORTED_ABIS : new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        return supportedAbis;
    }

    @Nullable
    static ActivityManager.MemoryInfo getMemInfo(@NotNull Context context, @NotNull ILogger logger) {
        try {
            ActivityManager actManager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            if (actManager != null) {
                actManager.getMemoryInfo(memInfo);
                return memInfo;
            }
            logger.log(SentryLevel.INFO, "Error getting MemoryInfo.", new Object[0]);
            return null;
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Error getting MemoryInfo.", e);
            return null;
        }
    }
}

