/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.SentryOptions;
import io.sentry.android.core.IDebugImagesLoader;
import io.sentry.android.core.NoOpDebugImagesLoader;
import io.sentry.protocol.SdkVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SentryAndroidOptions
extends SentryOptions {
    private boolean anrEnabled = true;
    private long anrTimeoutIntervalMillis = 5000L;
    private boolean anrReportInDebug = false;
    private boolean enableActivityLifecycleBreadcrumbs = true;
    private boolean enableAppLifecycleBreadcrumbs = true;
    private boolean enableSystemEventBreadcrumbs = true;
    private boolean enableAppComponentBreadcrumbs = true;
    private boolean enableNetworkEventBreadcrumbs = true;
    private boolean enableAutoActivityLifecycleTracing = true;
    private boolean enableActivityLifecycleTracingAutoFinish = true;
    private int profilingTracesHz = 101;
    @NotNull
    private IDebugImagesLoader debugImagesLoader = NoOpDebugImagesLoader.getInstance();
    private boolean attachScreenshot;
    private boolean attachViewHierarchy;
    private boolean collectAdditionalContext = true;
    private long startupCrashFlushTimeoutMillis = 5000L;
    private final long startupCrashDurationThresholdMillis = 2000L;
    private boolean enableFramesTracking = true;
    @Nullable
    private String nativeSdkName = null;

    public SentryAndroidOptions() {
        this.setSentryClientName("sentry.java.android/6.19.0");
        this.setSdkVersion(this.createSdkVersion());
        this.setAttachServerName(false);
        this.setEnableScopeSync(true);
    }

    @NotNull
    private SdkVersion createSdkVersion() {
        SdkVersion sdkVersion = this.getSdkVersion();
        String name = "sentry.java.android";
        String version = "6.19.0";
        sdkVersion = SdkVersion.updateSdkVersion((SdkVersion)sdkVersion, (String)"sentry.java.android", (String)"6.19.0");
        sdkVersion.addPackage("maven:io.sentry:sentry-android-core", "6.19.0");
        return sdkVersion;
    }

    public boolean isAnrEnabled() {
        return this.anrEnabled;
    }

    public void setAnrEnabled(boolean anrEnabled) {
        this.anrEnabled = anrEnabled;
    }

    public long getAnrTimeoutIntervalMillis() {
        return this.anrTimeoutIntervalMillis;
    }

    public void setAnrTimeoutIntervalMillis(long anrTimeoutIntervalMillis) {
        this.anrTimeoutIntervalMillis = anrTimeoutIntervalMillis;
    }

    public boolean isAnrReportInDebug() {
        return this.anrReportInDebug;
    }

    public void setAnrReportInDebug(boolean anrReportInDebug) {
        this.anrReportInDebug = anrReportInDebug;
    }

    public boolean isEnableActivityLifecycleBreadcrumbs() {
        return this.enableActivityLifecycleBreadcrumbs;
    }

    public void setEnableActivityLifecycleBreadcrumbs(boolean enableActivityLifecycleBreadcrumbs) {
        this.enableActivityLifecycleBreadcrumbs = enableActivityLifecycleBreadcrumbs;
    }

    public boolean isEnableAppLifecycleBreadcrumbs() {
        return this.enableAppLifecycleBreadcrumbs;
    }

    public void setEnableAppLifecycleBreadcrumbs(boolean enableAppLifecycleBreadcrumbs) {
        this.enableAppLifecycleBreadcrumbs = enableAppLifecycleBreadcrumbs;
    }

    public boolean isEnableSystemEventBreadcrumbs() {
        return this.enableSystemEventBreadcrumbs;
    }

    public void setEnableSystemEventBreadcrumbs(boolean enableSystemEventBreadcrumbs) {
        this.enableSystemEventBreadcrumbs = enableSystemEventBreadcrumbs;
    }

    public boolean isEnableAppComponentBreadcrumbs() {
        return this.enableAppComponentBreadcrumbs;
    }

    public void setEnableAppComponentBreadcrumbs(boolean enableAppComponentBreadcrumbs) {
        this.enableAppComponentBreadcrumbs = enableAppComponentBreadcrumbs;
    }

    public boolean isEnableNetworkEventBreadcrumbs() {
        return this.enableNetworkEventBreadcrumbs;
    }

    public void setEnableNetworkEventBreadcrumbs(boolean enableNetworkEventBreadcrumbs) {
        this.enableNetworkEventBreadcrumbs = enableNetworkEventBreadcrumbs;
    }

    public void enableAllAutoBreadcrumbs(boolean enable) {
        this.enableActivityLifecycleBreadcrumbs = enable;
        this.enableAppComponentBreadcrumbs = enable;
        this.enableSystemEventBreadcrumbs = enable;
        this.enableAppLifecycleBreadcrumbs = enable;
        this.enableNetworkEventBreadcrumbs = enable;
        this.setEnableUserInteractionBreadcrumbs(enable);
    }

    @Deprecated
    public int getProfilingTracesIntervalMillis() {
        return 0;
    }

    @Deprecated
    public void setProfilingTracesIntervalMillis(int profilingTracesIntervalMillis) {
    }

    @ApiStatus.Internal
    public int getProfilingTracesHz() {
        return this.profilingTracesHz;
    }

    @ApiStatus.Internal
    public void setProfilingTracesHz(int profilingTracesHz) {
        this.profilingTracesHz = profilingTracesHz;
    }

    @NotNull
    public IDebugImagesLoader getDebugImagesLoader() {
        return this.debugImagesLoader;
    }

    public void setDebugImagesLoader(@NotNull IDebugImagesLoader debugImagesLoader) {
        this.debugImagesLoader = debugImagesLoader != null ? debugImagesLoader : NoOpDebugImagesLoader.getInstance();
    }

    public boolean isEnableAutoActivityLifecycleTracing() {
        return this.enableAutoActivityLifecycleTracing;
    }

    public void setEnableAutoActivityLifecycleTracing(boolean enableAutoActivityLifecycleTracing) {
        this.enableAutoActivityLifecycleTracing = enableAutoActivityLifecycleTracing;
    }

    public boolean isEnableActivityLifecycleTracingAutoFinish() {
        return this.enableActivityLifecycleTracingAutoFinish;
    }

    public void setEnableActivityLifecycleTracingAutoFinish(boolean enableActivityLifecycleTracingAutoFinish) {
        this.enableActivityLifecycleTracingAutoFinish = enableActivityLifecycleTracingAutoFinish;
    }

    public boolean isAttachScreenshot() {
        return this.attachScreenshot;
    }

    public void setAttachScreenshot(boolean attachScreenshot) {
        this.attachScreenshot = attachScreenshot;
    }

    public boolean isAttachViewHierarchy() {
        return this.attachViewHierarchy;
    }

    public void setAttachViewHierarchy(boolean attachViewHierarchy) {
        this.attachViewHierarchy = attachViewHierarchy;
    }

    public boolean isCollectAdditionalContext() {
        return this.collectAdditionalContext;
    }

    public void setCollectAdditionalContext(boolean collectAdditionalContext) {
        this.collectAdditionalContext = collectAdditionalContext;
    }

    public boolean isEnableFramesTracking() {
        return this.enableFramesTracking;
    }

    public void setEnableFramesTracking(boolean enableFramesTracking) {
        this.enableFramesTracking = enableFramesTracking;
    }

    @ApiStatus.Internal
    long getStartupCrashFlushTimeoutMillis() {
        return this.startupCrashFlushTimeoutMillis;
    }

    @TestOnly
    void setStartupCrashFlushTimeoutMillis(long startupCrashFlushTimeoutMillis) {
        this.startupCrashFlushTimeoutMillis = startupCrashFlushTimeoutMillis;
    }

    @ApiStatus.Internal
    public long getStartupCrashDurationThresholdMillis() {
        return 2000L;
    }

    @ApiStatus.Internal
    public void setNativeSdkName(@Nullable String nativeSdkName) {
        this.nativeSdkName = nativeSdkName;
    }

    @ApiStatus.Internal
    @Nullable
    public String getNativeSdkName() {
        return this.nativeSdkName;
    }
}

