/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import io.sentry.Attachment;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.CurrentActivityHolder;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.ScreenshotUtils;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ScreenshotEventProcessor
implements EventProcessor {
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;

    public ScreenshotEventProcessor(@NotNull SentryAndroidOptions options, @NotNull BuildInfoProvider buildInfoProvider) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)options), (String)"SentryAndroidOptions is required"));
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        if (!event.isErrored()) {
            return event;
        }
        if (!this.options.isAttachScreenshot()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "attachScreenshot is disabled.", new Object[0]);
            return event;
        }
        @Nullable Activity activity = CurrentActivityHolder.getInstance().getActivity();
        if (activity == null || HintUtils.isFromHybridSdk((Hint)hint)) {
            return event;
        }
        byte[] screenshot = ScreenshotUtils.takeScreenshot(activity, this.options.getLogger(), this.buildInfoProvider);
        if (screenshot == null) {
            return event;
        }
        hint.setScreenshot(Attachment.fromScreenshot((byte[])screenshot));
        hint.set("android:activity", (Object)activity);
        return event;
    }
}

