/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.annotation.NonNull;
import io.sentry.Breadcrumb;
import io.sentry.FullyDisplayedReporter;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Instrumenter;
import io.sentry.Integration;
import io.sentry.Scope;
import io.sentry.SentryDate;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.AndroidDateUtils;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.FirstDrawDoneListener;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ActivityLifecycleIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    static final String UI_LOAD_OP = "ui.load";
    static final String APP_START_WARM = "app.start.warm";
    static final String APP_START_COLD = "app.start.cold";
    static final String TTID_OP = "ui.load.initial_display";
    static final String TTFD_OP = "ui.load.full_display";
    static final long TTFD_TIMEOUT_MILLIS = 30000L;
    @NotNull
    private final Application application;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;
    private boolean performanceEnabled = false;
    private boolean timeToFullDisplaySpanEnabled = false;
    private boolean isAllActivityCallbacksAvailable;
    private boolean firstActivityCreated = false;
    private final boolean foregroundImportance;
    @Nullable
    private FullyDisplayedReporter fullyDisplayedReporter = null;
    @Nullable
    private ISpan appStartSpan;
    @NotNull
    private final WeakHashMap<Activity, ISpan> ttidSpanMap = new WeakHashMap();
    @NotNull
    private SentryDate lastPausedTime = AndroidDateUtils.getCurrentSentryDateTime();
    @NotNull
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    @Nullable
    private ISpan ttfdSpan = null;
    @Nullable
    private Future<?> ttfdAutoCloseFuture = null;
    @NotNull
    private final WeakHashMap<Activity, ITransaction> activitiesWithOngoingTransactions = new WeakHashMap();
    @NotNull
    private final ActivityFramesTracker activityFramesTracker;

    public ActivityLifecycleIntegration(@NotNull Application application, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ActivityFramesTracker activityFramesTracker) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
        this.activityFramesTracker = (ActivityFramesTracker)Objects.requireNonNull((Object)activityFramesTracker, (String)"ActivityFramesTracker is required");
        if (buildInfoProvider.getSdkInfoVersion() >= 29) {
            this.isAllActivityCallbacksAvailable = true;
        }
        this.foregroundImportance = ContextUtils.isForegroundImportance((Context)this.application);
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration enabled: %s", new Object[]{this.options.isEnableActivityLifecycleBreadcrumbs()});
        this.performanceEnabled = this.isPerformanceEnabled(this.options);
        this.fullyDisplayedReporter = this.options.getFullyDisplayedReporter();
        this.timeToFullDisplaySpanEnabled = this.options.isEnableTimeToFullDisplayTracing();
        if (this.options.isEnableActivityLifecycleBreadcrumbs() || this.performanceEnabled) {
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration installed.", new Object[0]);
            this.addIntegrationToSdkVersion();
        }
    }

    private boolean isPerformanceEnabled(@NotNull SentryAndroidOptions options) {
        return options.isTracingEnabled() && options.isEnableAutoActivityLifecycleTracing();
    }

    @Override
    public void close() throws IOException {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration removed.", new Object[0]);
        }
        this.activityFramesTracker.stop();
    }

    private void addBreadcrumb(@NotNull Activity activity, @NotNull String state) {
        if (this.options != null && this.hub != null && this.options.isEnableActivityLifecycleBreadcrumbs()) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", (Object)state);
            breadcrumb.setData("screen", (Object)this.getActivityName(activity));
            breadcrumb.setCategory("ui.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            Hint hint = new Hint();
            hint.set("android:activity", (Object)activity);
            this.hub.addBreadcrumb(breadcrumb, hint);
        }
    }

    @NotNull
    private String getActivityName(@NotNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    private void stopPreviousTransactions() {
        for (Map.Entry<Activity, ITransaction> entry : this.activitiesWithOngoingTransactions.entrySet()) {
            ITransaction transaction = entry.getValue();
            ISpan ttidSpan = this.ttidSpanMap.get(entry.getKey());
            this.finishTransaction(transaction, ttidSpan, true);
        }
    }

    private void startTracing(@NotNull Activity activity) {
        WeakReference<Activity> weakActivity = new WeakReference<Activity>(activity);
        if (this.performanceEnabled && !this.isRunningTransaction(activity) && this.hub != null) {
            SentryDate ttidStartTime;
            this.stopPreviousTransactions();
            String activityName = this.getActivityName(activity);
            SentryDate appStartTime = this.foregroundImportance ? AppStartState.getInstance().getAppStartTime() : null;
            Boolean coldStart = AppStartState.getInstance().isColdStart();
            TransactionOptions transactionOptions = new TransactionOptions();
            if (this.options.isEnableActivityLifecycleTracingAutoFinish()) {
                transactionOptions.setIdleTimeout(this.options.getIdleTimeout());
                transactionOptions.setTrimEnd(true);
            }
            transactionOptions.setWaitForChildren(true);
            transactionOptions.setTransactionFinishedCallback(finishingTransaction -> {
                @Nullable Activity unwrappedActivity = (Activity)weakActivity.get();
                if (unwrappedActivity != null) {
                    this.activityFramesTracker.setMetrics(unwrappedActivity, finishingTransaction.getEventId());
                } else if (this.options != null) {
                    this.options.getLogger().log(SentryLevel.WARNING, "Unable to track activity frames as the Activity %s has been destroyed.", new Object[]{activityName});
                }
            });
            if (!this.firstActivityCreated && appStartTime != null && coldStart != null) {
                transactionOptions.setStartTimestamp(appStartTime);
            }
            ITransaction transaction = this.hub.startTransaction(new TransactionContext(activityName, TransactionNameSource.COMPONENT, UI_LOAD_OP), transactionOptions);
            if (!this.firstActivityCreated && appStartTime != null && coldStart != null) {
                this.appStartSpan = transaction.startChild(this.getAppStartOp(coldStart), this.getAppStartDesc(coldStart), appStartTime, Instrumenter.SENTRY);
                this.finishAppStartSpan();
                ttidStartTime = appStartTime;
            } else {
                ttidStartTime = this.lastPausedTime;
            }
            this.ttidSpanMap.put(activity, transaction.startChild(TTID_OP, this.getTtidDesc(activityName), ttidStartTime, Instrumenter.SENTRY));
            if (this.timeToFullDisplaySpanEnabled && this.fullyDisplayedReporter != null && this.options != null) {
                this.ttfdSpan = transaction.startChild(TTFD_OP, this.getTtfdDesc(activityName), ttidStartTime, Instrumenter.SENTRY);
                this.ttfdAutoCloseFuture = this.options.getExecutorService().schedule(() -> this.finishSpan(this.ttfdSpan, SpanStatus.DEADLINE_EXCEEDED), 30000L);
            }
            this.hub.configureScope(scope -> this.applyScope(scope, transaction));
            this.activitiesWithOngoingTransactions.put(activity, transaction);
        }
    }

    @VisibleForTesting
    void applyScope(@NotNull Scope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == null) {
                scope.setTransaction(transaction);
            } else if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction '%s' won't be bound to the Scope since there's one already in there.", new Object[]{transaction.getName()});
            }
        });
    }

    @VisibleForTesting
    void clearScope(@NotNull Scope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == transaction) {
                scope.clearTransaction();
            }
        });
    }

    private boolean isRunningTransaction(@NotNull Activity activity) {
        return this.activitiesWithOngoingTransactions.containsKey(activity);
    }

    private void stopTracing(@NotNull Activity activity, boolean shouldFinishTracing) {
        if (this.performanceEnabled && shouldFinishTracing) {
            ITransaction transaction = this.activitiesWithOngoingTransactions.get(activity);
            this.finishTransaction(transaction, null, false);
        }
    }

    private void finishTransaction(@Nullable ITransaction transaction, @Nullable ISpan ttidSpan, boolean finishTtfd) {
        if (transaction != null) {
            if (transaction.isFinished()) {
                return;
            }
            this.finishSpan(ttidSpan, SpanStatus.DEADLINE_EXCEEDED);
            if (finishTtfd) {
                this.finishSpan(this.ttfdSpan, SpanStatus.DEADLINE_EXCEEDED);
            }
            this.cancelTtfdAutoClose();
            SpanStatus status = transaction.getStatus();
            if (status == null) {
                status = SpanStatus.OK;
            }
            transaction.finish(status);
            if (this.hub != null) {
                this.hub.configureScope(scope -> this.clearScope(scope, transaction));
            }
        }
    }

    public synchronized void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        this.setColdStart(savedInstanceState);
        this.addBreadcrumb(activity, "created");
        this.startTracing(activity);
        this.firstActivityCreated = true;
        if (this.fullyDisplayedReporter != null) {
            this.fullyDisplayedReporter.registerFullyDrawnListener(() -> {
                this.finishSpan(this.ttfdSpan);
                this.cancelTtfdAutoClose();
            });
        }
    }

    public synchronized void onActivityStarted(@NotNull Activity activity) {
        this.activityFramesTracker.addActivity(activity);
        this.addBreadcrumb(activity, "started");
    }

    @SuppressLint(value={"NewApi"})
    public synchronized void onActivityResumed(@NotNull Activity activity) {
        @Nullable SentryDate appStartStartTime = AppStartState.getInstance().getAppStartTime();
        @Nullable SentryDate appStartEndTime = AppStartState.getInstance().getAppStartEndTime();
        if (appStartStartTime != null && appStartEndTime == null) {
            AppStartState.getInstance().setAppStartEnd();
        }
        this.finishAppStartSpan();
        ISpan ttidSpan = this.ttidSpanMap.get(activity);
        View rootView = activity.findViewById(0x1020002);
        if (this.buildInfoProvider.getSdkInfoVersion() >= 16 && rootView != null) {
            FirstDrawDoneListener.registerForNextDraw(rootView, () -> this.onFirstFrameDrawn(ttidSpan), this.buildInfoProvider);
        } else {
            this.mainHandler.post(() -> this.onFirstFrameDrawn(ttidSpan));
        }
        this.addBreadcrumb(activity, "resumed");
    }

    public void onActivityPostResumed(@NonNull Activity activity) {
    }

    public void onActivityPrePaused(@NonNull Activity activity) {
        if (this.isAllActivityCallbacksAvailable) {
            this.lastPausedTime = this.hub == null ? AndroidDateUtils.getCurrentSentryDateTime() : this.hub.getOptions().getDateProvider().now();
        }
    }

    public synchronized void onActivityPaused(@NotNull Activity activity) {
        if (!this.isAllActivityCallbacksAvailable) {
            this.lastPausedTime = this.hub == null ? AndroidDateUtils.getCurrentSentryDateTime() : this.hub.getOptions().getDateProvider().now();
        }
        this.addBreadcrumb(activity, "paused");
    }

    public synchronized void onActivityStopped(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "stopped");
    }

    public synchronized void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        this.addBreadcrumb(activity, "saveInstanceState");
    }

    public synchronized void onActivityDestroyed(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "destroyed");
        this.finishSpan(this.appStartSpan, SpanStatus.CANCELLED);
        ISpan ttidSpan = this.ttidSpanMap.get(activity);
        this.finishSpan(ttidSpan, SpanStatus.DEADLINE_EXCEEDED);
        this.finishSpan(this.ttfdSpan, SpanStatus.DEADLINE_EXCEEDED);
        this.cancelTtfdAutoClose();
        this.stopTracing(activity, true);
        this.appStartSpan = null;
        this.ttidSpanMap.remove(activity);
        this.ttfdSpan = null;
        if (this.performanceEnabled) {
            this.activitiesWithOngoingTransactions.remove(activity);
        }
    }

    private void finishSpan(@Nullable ISpan span) {
        if (span != null && !span.isFinished()) {
            span.finish();
        }
    }

    private void finishSpan(@Nullable ISpan span, @NotNull SentryDate endTimestamp) {
        if (span != null && !span.isFinished()) {
            @NotNull SpanStatus status = span.getStatus() != null ? span.getStatus() : SpanStatus.OK;
            span.finish(status, endTimestamp);
        }
    }

    private void finishSpan(@Nullable ISpan span, @NotNull SpanStatus status) {
        if (span != null && !span.isFinished()) {
            span.finish(status);
        }
    }

    private void cancelTtfdAutoClose() {
        if (this.ttfdAutoCloseFuture != null) {
            this.ttfdAutoCloseFuture.cancel(false);
            this.ttfdAutoCloseFuture = null;
        }
    }

    private void onFirstFrameDrawn(@Nullable ISpan ttidSpan) {
        if (this.options != null && this.ttfdSpan != null && this.ttfdSpan.isFinished()) {
            SentryDate endDate = this.options.getDateProvider().now();
            this.ttfdSpan.updateEndDate(endDate);
            this.finishSpan(ttidSpan, endDate);
        } else {
            this.finishSpan(ttidSpan);
        }
    }

    @TestOnly
    @NotNull
    WeakHashMap<Activity, ITransaction> getActivitiesWithOngoingTransactions() {
        return this.activitiesWithOngoingTransactions;
    }

    @TestOnly
    @NotNull
    ActivityFramesTracker getActivityFramesTracker() {
        return this.activityFramesTracker;
    }

    @TestOnly
    @Nullable
    ISpan getAppStartSpan() {
        return this.appStartSpan;
    }

    @TestOnly
    @NotNull
    WeakHashMap<Activity, ISpan> getTtidSpanMap() {
        return this.ttidSpanMap;
    }

    @TestOnly
    @Nullable
    ISpan getTtfdSpan() {
        return this.ttfdSpan;
    }

    private void setColdStart(@Nullable Bundle savedInstanceState) {
        if (!this.firstActivityCreated) {
            AppStartState.getInstance().setColdStart(savedInstanceState == null);
        }
    }

    @NotNull
    private String getTtidDesc(@NotNull String activityName) {
        return activityName + " initial display";
    }

    @NotNull
    private String getTtfdDesc(@NotNull String activityName) {
        return activityName + " full display";
    }

    @NotNull
    private String getAppStartDesc(boolean coldStart) {
        if (coldStart) {
            return "Cold Start";
        }
        return "Warm Start";
    }

    @NotNull
    private String getAppStartOp(boolean coldStart) {
        if (coldStart) {
            return APP_START_COLD;
        }
        return APP_START_WARM;
    }

    private void finishAppStartSpan() {
        @Nullable SentryDate appStartEndTime = AppStartState.getInstance().getAppStartEndTime();
        if (this.performanceEnabled && appStartEndTime != null) {
            this.finishSpan(this.appStartSpan, appStartEndTime);
        }
    }
}

