/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import androidx.annotation.Nullable;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ScreenshotUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static byte[] takeScreenshot(@NotNull Activity activity, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        if (!ScreenshotUtils.isActivityValid(activity, buildInfoProvider) || activity.getWindow() == null || activity.getWindow().getDecorView() == null || activity.getWindow().getDecorView().getRootView() == null) {
            logger.log(SentryLevel.DEBUG, "Activity isn't valid, not taking screenshot.", new Object[0]);
            return null;
        }
        View view = activity.getWindow().getDecorView().getRootView();
        if (view.getWidth() <= 0 || view.getHeight() <= 0) {
            logger.log(SentryLevel.DEBUG, "View's width and height is zeroed, not taking screenshot.", new Object[0]);
            return null;
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            view.draw(canvas);
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)byteArrayOutputStream);
            if (byteArrayOutputStream.size() <= 0) {
                logger.log(SentryLevel.DEBUG, "Screenshot is 0 bytes, not attaching the image.", new Object[0]);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Taking screenshot failed.", e);
            return null;
        }
    }

    @SuppressLint(value={"NewApi"})
    private static boolean isActivityValid(@NotNull Activity activity, @NotNull BuildInfoProvider buildInfoProvider) {
        if (buildInfoProvider.getSdkInfoVersion() >= 17) {
            return !activity.isFinishing() && !activity.isDestroyed();
        }
        return !activity.isFinishing();
    }
}

