/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.SentryLevel;
import io.sentry.Session;
import io.sentry.android.core.AppState;
import io.sentry.android.core.internal.util.BreadcrumbFactory;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.transport.ICurrentDateProvider;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class LifecycleWatcher
implements DefaultLifecycleObserver {
    private final AtomicLong lastUpdatedSession = new AtomicLong(0L);
    private final long sessionIntervalMillis;
    @Nullable
    private TimerTask timerTask;
    @Nullable
    private final Timer timer;
    @NotNull
    private final Object timerLock = new Object();
    @NotNull
    private final IHub hub;
    private final boolean enableSessionTracking;
    private final boolean enableAppLifecycleBreadcrumbs;
    @NotNull
    private final ICurrentDateProvider currentDateProvider;

    LifecycleWatcher(@NotNull IHub hub, long sessionIntervalMillis, boolean enableSessionTracking, boolean enableAppLifecycleBreadcrumbs) {
        this(hub, sessionIntervalMillis, enableSessionTracking, enableAppLifecycleBreadcrumbs, CurrentDateProvider.getInstance());
    }

    LifecycleWatcher(@NotNull IHub hub, long sessionIntervalMillis, boolean enableSessionTracking, boolean enableAppLifecycleBreadcrumbs, @NotNull ICurrentDateProvider currentDateProvider) {
        this.sessionIntervalMillis = sessionIntervalMillis;
        this.enableSessionTracking = enableSessionTracking;
        this.enableAppLifecycleBreadcrumbs = enableAppLifecycleBreadcrumbs;
        this.hub = hub;
        this.currentDateProvider = currentDateProvider;
        this.timer = enableSessionTracking ? new Timer(true) : null;
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        this.startSession();
        this.addAppBreadcrumb("foreground");
        AppState.getInstance().setInBackground(false);
    }

    private void startSession() {
        if (this.enableSessionTracking) {
            this.cancelTask();
            long currentTimeMillis = this.currentDateProvider.getCurrentTimeMillis();
            this.hub.withScope(scope -> {
                Session currentSession;
                long lastUpdatedSession = this.lastUpdatedSession.get();
                if (lastUpdatedSession == 0L && (currentSession = scope.getSession()) != null && currentSession.getStarted() != null) {
                    lastUpdatedSession = currentSession.getStarted().getTime();
                }
                if (lastUpdatedSession == 0L || lastUpdatedSession + this.sessionIntervalMillis <= currentTimeMillis) {
                    this.addSessionBreadcrumb("start");
                    this.hub.startSession();
                }
                this.lastUpdatedSession.set(currentTimeMillis);
            });
        }
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        if (this.enableSessionTracking) {
            long currentTimeMillis = this.currentDateProvider.getCurrentTimeMillis();
            this.lastUpdatedSession.set(currentTimeMillis);
            this.scheduleEndSession();
        }
        AppState.getInstance().setInBackground(true);
        this.addAppBreadcrumb("background");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleEndSession() {
        Object object = this.timerLock;
        synchronized (object) {
            this.cancelTask();
            if (this.timer != null) {
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        LifecycleWatcher.this.addSessionBreadcrumb("end");
                        LifecycleWatcher.this.hub.endSession();
                    }
                };
                this.timer.schedule(this.timerTask, this.sessionIntervalMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTask() {
        Object object = this.timerLock;
        synchronized (object) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
        }
    }

    private void addAppBreadcrumb(@NotNull String state) {
        if (this.enableAppLifecycleBreadcrumbs) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", (Object)state);
            breadcrumb.setCategory("app.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            this.hub.addBreadcrumb(breadcrumb);
        }
    }

    private void addSessionBreadcrumb(@NotNull String state) {
        Breadcrumb breadcrumb = BreadcrumbFactory.forSession(state);
        this.hub.addBreadcrumb(breadcrumb);
    }

    @TestOnly
    @Nullable
    TimerTask getTimerTask() {
        return this.timerTask;
    }

    @TestOnly
    @Nullable
    Timer getTimer() {
        return this.timer;
    }
}

