/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import android.os.SystemClock;
import android.view.FrameMetrics;
import io.sentry.CpuCollectionData;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.ITransactionProfiler;
import io.sentry.MemoryCollectionData;
import io.sentry.PerformanceCollectionData;
import io.sentry.ProfilingTraceData;
import io.sentry.ProfilingTransactionData;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.CpuInfoUtils;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.profilemeasurements.ProfileMeasurement;
import io.sentry.profilemeasurements.ProfileMeasurementValue;
import io.sentry.util.Objects;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AndroidTransactionProfiler
implements ITransactionProfiler {
    private static final int BUFFER_SIZE_BYTES = 3000000;
    private static final int PROFILING_TIMEOUT_MILLIS = 30000;
    private int intervalUs;
    @Nullable
    private File traceFile = null;
    @Nullable
    private File traceFilesDir = null;
    @Nullable
    private Future<?> scheduledFinish = null;
    @Nullable
    private volatile ProfilingTraceData timedOutProfilingData = null;
    @NotNull
    private final Context context;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final IHub hub;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    private long transactionStartNanos = 0L;
    private long profileStartCpuMillis = 0L;
    private boolean isInitialized = false;
    private int transactionsCounter = 0;
    @Nullable
    private String frameMetricsCollectorId;
    @NotNull
    private final SentryFrameMetricsCollector frameMetricsCollector;
    @Nullable
    private ProfilingTransactionData currentProfilingTransactionData;
    @NotNull
    private final ArrayDeque<ProfileMeasurementValue> screenFrameRateMeasurements = new ArrayDeque();
    @NotNull
    private final ArrayDeque<ProfileMeasurementValue> slowFrameRenderMeasurements = new ArrayDeque();
    @NotNull
    private final ArrayDeque<ProfileMeasurementValue> frozenFrameRenderMeasurements = new ArrayDeque();
    @NotNull
    private final Map<String, ProfileMeasurement> measurementsMap = new HashMap<String, ProfileMeasurement>();

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull SentryAndroidOptions sentryAndroidOptions, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector) {
        this(context, sentryAndroidOptions, buildInfoProvider, frameMetricsCollector, (IHub)HubAdapter.getInstance());
    }

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull SentryAndroidOptions sentryAndroidOptions, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector, @NotNull IHub hub) {
        this.context = (Context)Objects.requireNonNull((Object)context, (String)"The application context is required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)sentryAndroidOptions), (String)"SentryAndroidOptions is required"));
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.frameMetricsCollector = (SentryFrameMetricsCollector)Objects.requireNonNull((Object)frameMetricsCollector, (String)"SentryFrameMetricsCollector is required");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        String tracesFilesDirPath = this.options.getProfilingTracesDirPath();
        if (!this.options.isProfilingEnabled()) {
            this.options.getLogger().log(SentryLevel.INFO, "Profiling is disabled in options.", new Object[0]);
            return;
        }
        if (tracesFilesDirPath == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabling profiling because no profiling traces dir path is defined in options.", new Object[0]);
            return;
        }
        int intervalHz = this.options.getProfilingTracesHz();
        if (intervalHz <= 0) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabling profiling because trace rate is set to %d", new Object[]{intervalHz});
            return;
        }
        this.intervalUs = (int)TimeUnit.SECONDS.toMicros(1L) / intervalHz;
        this.traceFilesDir = new File(tracesFilesDirPath);
    }

    public synchronized void onTransactionStart(@NotNull ITransaction transaction) {
        this.options.getExecutorService().submit(() -> this.onTransactionStartSafe(transaction));
    }

    @SuppressLint(value={"NewApi"})
    private void onTransactionStartSafe(@NotNull ITransaction transaction) {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return;
        }
        this.init();
        if (this.traceFilesDir == null || this.intervalUs == 0 || !this.traceFilesDir.canWrite()) {
            return;
        }
        ++this.transactionsCounter;
        if (this.transactionsCounter == 1) {
            this.onFirstTransactionStarted(transaction);
            this.options.getLogger().log(SentryLevel.DEBUG, "Transaction %s (%s) started and being profiled.", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
        } else {
            --this.transactionsCounter;
            this.options.getLogger().log(SentryLevel.WARNING, "A transaction is already being profiled. Transaction %s (%s) will be ignored.", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
        }
    }

    @SuppressLint(value={"NewApi"})
    private void onFirstTransactionStarted(@NotNull ITransaction transaction) {
        this.traceFile = new File(this.traceFilesDir, UUID.randomUUID() + ".trace");
        this.measurementsMap.clear();
        this.screenFrameRateMeasurements.clear();
        this.slowFrameRenderMeasurements.clear();
        this.frozenFrameRenderMeasurements.clear();
        this.frameMetricsCollectorId = this.frameMetricsCollector.startCollection(new SentryFrameMetricsCollector.FrameMetricsCollectorListener(){
            final long nanosInSecond = TimeUnit.SECONDS.toNanos(1L);
            final long frozenFrameThresholdNanos = TimeUnit.MILLISECONDS.toNanos(700L);
            float lastRefreshRate = 0.0f;

            @Override
            public void onFrameMetricCollected(@NotNull FrameMetrics frameMetrics, float refreshRate) {
                long frameTimestampRelativeNanos = SystemClock.elapsedRealtimeNanos() - AndroidTransactionProfiler.this.transactionStartNanos;
                if (frameTimestampRelativeNanos < 0L) {
                    return;
                }
                long durationNanos = frameMetrics.getMetric(8);
                boolean isSlow = (float)durationNanos > (float)this.nanosInSecond / (refreshRate - 1.0f);
                float newRefreshRate = (float)((int)(refreshRate * 100.0f)) / 100.0f;
                if (durationNanos > this.frozenFrameThresholdNanos) {
                    AndroidTransactionProfiler.this.frozenFrameRenderMeasurements.addLast(new ProfileMeasurementValue(Long.valueOf(frameTimestampRelativeNanos), (Number)durationNanos));
                } else if (isSlow) {
                    AndroidTransactionProfiler.this.slowFrameRenderMeasurements.addLast(new ProfileMeasurementValue(Long.valueOf(frameTimestampRelativeNanos), (Number)durationNanos));
                }
                if (newRefreshRate != this.lastRefreshRate) {
                    this.lastRefreshRate = newRefreshRate;
                    AndroidTransactionProfiler.this.screenFrameRateMeasurements.addLast(new ProfileMeasurementValue(Long.valueOf(frameTimestampRelativeNanos), (Number)Float.valueOf(newRefreshRate)));
                }
            }
        });
        this.scheduledFinish = this.options.getExecutorService().schedule(() -> {
            this.timedOutProfilingData = this.onTransactionFinish(transaction, true, null);
        }, 30000L);
        this.transactionStartNanos = SystemClock.elapsedRealtimeNanos();
        this.profileStartCpuMillis = Process.getElapsedCpuTime();
        this.currentProfilingTransactionData = new ProfilingTransactionData(transaction, Long.valueOf(this.transactionStartNanos), Long.valueOf(this.profileStartCpuMillis));
        Debug.startMethodTracingSampling((String)this.traceFile.getPath(), (int)3000000, (int)this.intervalUs);
    }

    @Nullable
    public synchronized ProfilingTraceData onTransactionFinish(@NotNull ITransaction transaction, @Nullable PerformanceCollectionData performanceCollectionData) {
        try {
            return (ProfilingTraceData)this.options.getExecutorService().submit(() -> this.onTransactionFinish(transaction, false, performanceCollectionData)).get();
        }
        catch (ExecutionException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error finishing profiling: ", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error finishing profiling: ", (Throwable)e);
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    private ProfilingTraceData onTransactionFinish(@NotNull ITransaction transaction, boolean isTimeout, @Nullable PerformanceCollectionData performanceCollectionData) {
        if (this.buildInfoProvider.getSdkInfoVersion() < 21) {
            return null;
        }
        ProfilingTraceData profilingData = this.timedOutProfilingData;
        if (this.currentProfilingTransactionData == null || !this.currentProfilingTransactionData.getId().equals(transaction.getEventId().toString())) {
            if (profilingData != null) {
                if (profilingData.getTransactionId().equals(transaction.getEventId().toString())) {
                    this.timedOutProfilingData = null;
                    return profilingData;
                }
                this.options.getLogger().log(SentryLevel.INFO, "A timed out profiling data exists, but the finishing transaction %s (%s) is not part of it", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
                return null;
            }
            this.options.getLogger().log(SentryLevel.INFO, "Transaction %s (%s) finished, but was not currently being profiled. Skipping", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
            return null;
        }
        if (this.transactionsCounter > 0) {
            --this.transactionsCounter;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Transaction %s (%s) finished.", new Object[]{transaction.getName(), transaction.getSpanContext().getTraceId().toString()});
        if (this.transactionsCounter != 0 && !isTimeout) {
            if (this.currentProfilingTransactionData != null) {
                this.currentProfilingTransactionData.notifyFinish(Long.valueOf(SystemClock.elapsedRealtimeNanos()), Long.valueOf(this.transactionStartNanos), Long.valueOf(Process.getElapsedCpuTime()), Long.valueOf(this.profileStartCpuMillis));
            }
            return null;
        }
        Debug.stopMethodTracing();
        this.frameMetricsCollector.stopCollection(this.frameMetricsCollectorId);
        long transactionEndNanos = SystemClock.elapsedRealtimeNanos();
        long transactionEndCpuMillis = Process.getElapsedCpuTime();
        long transactionDurationNanos = transactionEndNanos - this.transactionStartNanos;
        ArrayList<ProfilingTransactionData> transactionList = new ArrayList<ProfilingTransactionData>(1);
        transactionList.add(this.currentProfilingTransactionData);
        this.currentProfilingTransactionData = null;
        this.transactionsCounter = 0;
        if (this.scheduledFinish != null) {
            this.scheduledFinish.cancel(true);
            this.scheduledFinish = null;
        }
        if (this.traceFile == null) {
            this.options.getLogger().log(SentryLevel.ERROR, "Trace file does not exists", new Object[0]);
            return null;
        }
        String totalMem = "0";
        ActivityManager.MemoryInfo memInfo = this.getMemInfo();
        if (memInfo != null) {
            totalMem = Long.toString(memInfo.totalMem);
        }
        String[] abis = Build.SUPPORTED_ABIS;
        for (ProfilingTransactionData t : transactionList) {
            t.notifyFinish(Long.valueOf(transactionEndNanos), Long.valueOf(this.transactionStartNanos), Long.valueOf(transactionEndCpuMillis), Long.valueOf(this.profileStartCpuMillis));
        }
        if (!this.slowFrameRenderMeasurements.isEmpty()) {
            this.measurementsMap.put("slow_frame_renders", new ProfileMeasurement("nanosecond", this.slowFrameRenderMeasurements));
        }
        if (!this.frozenFrameRenderMeasurements.isEmpty()) {
            this.measurementsMap.put("frozen_frame_renders", new ProfileMeasurement("nanosecond", this.frozenFrameRenderMeasurements));
        }
        if (!this.screenFrameRateMeasurements.isEmpty()) {
            this.measurementsMap.put("screen_frame_rates", new ProfileMeasurement("hz", this.screenFrameRateMeasurements));
        }
        this.putPerformanceCollectionDataInMeasurements(performanceCollectionData);
        return new ProfilingTraceData(this.traceFile, transactionList, transaction, Long.toString(transactionDurationNanos), this.buildInfoProvider.getSdkInfoVersion(), abis != null && abis.length > 0 ? abis[0] : "", () -> CpuInfoUtils.getInstance().readMaxFrequencies(), this.buildInfoProvider.getManufacturer(), this.buildInfoProvider.getModel(), this.buildInfoProvider.getVersionRelease(), this.buildInfoProvider.isEmulator(), totalMem, this.options.getProguardUuid(), this.options.getRelease(), this.options.getEnvironment(), isTimeout ? "timeout" : "normal", this.measurementsMap);
    }

    private void putPerformanceCollectionDataInMeasurements(@Nullable PerformanceCollectionData performanceCollectionData) {
        if (performanceCollectionData != null) {
            @NotNull ArrayDeque<ProfileMeasurementValue> memoryUsageMeasurements = new ArrayDeque<ProfileMeasurementValue>();
            @NotNull ArrayDeque<ProfileMeasurementValue> nativeMemoryUsageMeasurements = new ArrayDeque<ProfileMeasurementValue>();
            @NotNull ArrayDeque<ProfileMeasurementValue> cpuUsageMeasurements = new ArrayDeque<ProfileMeasurementValue>();
            for (CpuCollectionData cpuData : performanceCollectionData.getCpuData()) {
                cpuUsageMeasurements.add(new ProfileMeasurementValue(Long.valueOf(TimeUnit.MILLISECONDS.toNanos(cpuData.getTimestampMillis()) - this.transactionStartNanos), (Number)cpuData.getCpuUsagePercentage()));
            }
            for (MemoryCollectionData memoryData : performanceCollectionData.getMemoryData()) {
                if (memoryData.getUsedHeapMemory() > -1L) {
                    memoryUsageMeasurements.add(new ProfileMeasurementValue(Long.valueOf(TimeUnit.MILLISECONDS.toNanos(memoryData.getTimestampMillis()) - this.transactionStartNanos), (Number)memoryData.getUsedHeapMemory()));
                }
                if (memoryData.getUsedNativeMemory() <= -1L) continue;
                nativeMemoryUsageMeasurements.add(new ProfileMeasurementValue(Long.valueOf(TimeUnit.MILLISECONDS.toNanos(memoryData.getTimestampMillis()) - this.transactionStartNanos), (Number)memoryData.getUsedNativeMemory()));
            }
            if (!cpuUsageMeasurements.isEmpty()) {
                this.measurementsMap.put("cpu_usage", new ProfileMeasurement("percent", cpuUsageMeasurements));
            }
            if (!memoryUsageMeasurements.isEmpty()) {
                this.measurementsMap.put("memory_footprint", new ProfileMeasurement("byte", memoryUsageMeasurements));
            }
            if (!nativeMemoryUsageMeasurements.isEmpty()) {
                this.measurementsMap.put("memory_native_footprint", new ProfileMeasurement("byte", nativeMemoryUsageMeasurements));
            }
        }
    }

    @Nullable
    private ActivityManager.MemoryInfo getMemInfo() {
        try {
            ActivityManager actManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            if (actManager != null) {
                actManager.getMemoryInfo(memInfo);
                return memInfo;
            }
            this.options.getLogger().log(SentryLevel.INFO, "Error getting MemoryInfo.", new Object[0]);
            return null;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting MemoryInfo.", e);
            return null;
        }
    }
}

