/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.annotation.NonNull;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Instrumenter;
import io.sentry.Integration;
import io.sentry.Scope;
import io.sentry.SentryDate;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.AndroidDateUtils;
import io.sentry.android.core.AppStartState;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.FirstDrawDoneListener;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ActivityLifecycleIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    static final String UI_LOAD_OP = "ui.load";
    static final String APP_START_WARM = "app.start.warm";
    static final String APP_START_COLD = "app.start.cold";
    static final String TTID_OP = "ui.load.initial_display";
    @NotNull
    private final Application application;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @Nullable
    private IHub hub;
    @Nullable
    private SentryAndroidOptions options;
    private boolean performanceEnabled = false;
    private boolean isAllActivityCallbacksAvailable;
    private boolean firstActivityCreated = false;
    private boolean firstActivityResumed = false;
    private boolean foregroundImportance = false;
    @Nullable
    private ISpan appStartSpan;
    @NotNull
    private final WeakHashMap<Activity, ISpan> ttidSpanMap = new WeakHashMap();
    @NotNull
    private SentryDate lastPausedTime = AndroidDateUtils.getCurrentSentryDateTime();
    @NotNull
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    @NotNull
    private final WeakHashMap<Activity, ITransaction> activitiesWithOngoingTransactions = new WeakHashMap();
    @NotNull
    private final ActivityFramesTracker activityFramesTracker;

    public ActivityLifecycleIntegration(@NotNull Application application, @NotNull BuildInfoProvider buildInfoProvider, @NotNull ActivityFramesTracker activityFramesTracker) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"BuildInfoProvider is required");
        this.activityFramesTracker = (ActivityFramesTracker)Objects.requireNonNull((Object)activityFramesTracker, (String)"ActivityFramesTracker is required");
        if (buildInfoProvider.getSdkInfoVersion() >= 29) {
            this.isAllActivityCallbacksAvailable = true;
        }
        this.foregroundImportance = ContextUtils.isForegroundImportance((Context)this.application);
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"Hub is required");
        this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration enabled: %s", new Object[]{this.options.isEnableActivityLifecycleBreadcrumbs()});
        this.performanceEnabled = this.isPerformanceEnabled(this.options);
        if (this.options.isEnableActivityLifecycleBreadcrumbs() || this.performanceEnabled) {
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration installed.", new Object[0]);
        }
    }

    private boolean isPerformanceEnabled(@NotNull SentryAndroidOptions options) {
        return options.isTracingEnabled() && options.isEnableAutoActivityLifecycleTracing();
    }

    @Override
    public void close() throws IOException {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "ActivityLifecycleIntegration removed.", new Object[0]);
        }
        this.activityFramesTracker.stop();
    }

    private void addBreadcrumb(@NotNull Activity activity, @NotNull String state) {
        if (this.options != null && this.hub != null && this.options.isEnableActivityLifecycleBreadcrumbs()) {
            Breadcrumb breadcrumb = new Breadcrumb();
            breadcrumb.setType("navigation");
            breadcrumb.setData("state", (Object)state);
            breadcrumb.setData("screen", (Object)this.getActivityName(activity));
            breadcrumb.setCategory("ui.lifecycle");
            breadcrumb.setLevel(SentryLevel.INFO);
            Hint hint = new Hint();
            hint.set("android:activity", (Object)activity);
            this.hub.addBreadcrumb(breadcrumb, hint);
        }
    }

    @NotNull
    private String getActivityName(@NotNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    private void stopPreviousTransactions() {
        for (Map.Entry<Activity, ITransaction> entry : this.activitiesWithOngoingTransactions.entrySet()) {
            ITransaction transaction = entry.getValue();
            ISpan ttidSpan = this.ttidSpanMap.get(entry.getKey());
            this.finishTransaction(transaction, ttidSpan);
        }
    }

    private void startTracing(@NotNull Activity activity) {
        WeakReference<Activity> weakActivity = new WeakReference<Activity>(activity);
        if (this.performanceEnabled && !this.isRunningTransaction(activity) && this.hub != null) {
            this.stopPreviousTransactions();
            String activityName = this.getActivityName(activity);
            SentryDate appStartTime = this.foregroundImportance ? AppStartState.getInstance().getAppStartTime() : null;
            Boolean coldStart = AppStartState.getInstance().isColdStart();
            TransactionOptions transactionOptions = new TransactionOptions();
            transactionOptions.setWaitForChildren(true);
            transactionOptions.setTransactionFinishedCallback(finishingTransaction -> {
                @Nullable Activity unwrappedActivity = (Activity)weakActivity.get();
                if (unwrappedActivity != null) {
                    this.activityFramesTracker.setMetrics(unwrappedActivity, finishingTransaction.getEventId());
                } else if (this.options != null) {
                    this.options.getLogger().log(SentryLevel.WARNING, "Unable to track activity frames as the Activity %s has been destroyed.", new Object[]{activityName});
                }
            });
            if (!this.firstActivityCreated && appStartTime != null && coldStart != null) {
                transactionOptions.setStartTimestamp(appStartTime);
            }
            ITransaction transaction = this.hub.startTransaction(new TransactionContext(activityName, TransactionNameSource.COMPONENT, UI_LOAD_OP), transactionOptions);
            if (!this.firstActivityCreated && appStartTime != null && coldStart != null) {
                this.appStartSpan = transaction.startChild(this.getAppStartOp(coldStart), this.getAppStartDesc(coldStart), appStartTime, Instrumenter.SENTRY);
                this.ttidSpanMap.put(activity, transaction.startChild(TTID_OP, this.getTtidDesc(activityName), appStartTime, Instrumenter.SENTRY));
            } else {
                this.ttidSpanMap.put(activity, transaction.startChild(TTID_OP, this.getTtidDesc(activityName), this.lastPausedTime, Instrumenter.SENTRY));
            }
            this.hub.configureScope(scope -> this.applyScope(scope, transaction));
            this.activitiesWithOngoingTransactions.put(activity, transaction);
        }
    }

    @VisibleForTesting
    void applyScope(@NotNull Scope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == null) {
                scope.setTransaction(transaction);
            } else if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction '%s' won't be bound to the Scope since there's one already in there.", new Object[]{transaction.getName()});
            }
        });
    }

    @VisibleForTesting
    void clearScope(@NotNull Scope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == transaction) {
                scope.clearTransaction();
            }
        });
    }

    private boolean isRunningTransaction(@NotNull Activity activity) {
        return this.activitiesWithOngoingTransactions.containsKey(activity);
    }

    private void stopTracing(@NotNull Activity activity, boolean shouldFinishTracing) {
        if (this.performanceEnabled && shouldFinishTracing) {
            ITransaction transaction = this.activitiesWithOngoingTransactions.get(activity);
            this.finishTransaction(transaction, null);
        }
    }

    private void finishTransaction(@Nullable ITransaction transaction, @Nullable ISpan ttidSpan) {
        if (transaction != null) {
            if (transaction.isFinished()) {
                return;
            }
            this.finishSpan(ttidSpan, SpanStatus.CANCELLED);
            SpanStatus status = transaction.getStatus();
            if (status == null) {
                status = SpanStatus.OK;
            }
            transaction.finish(status);
            if (this.hub != null) {
                this.hub.configureScope(scope -> this.clearScope(scope, transaction));
            }
        }
    }

    public synchronized void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        this.setColdStart(savedInstanceState);
        this.addBreadcrumb(activity, "created");
        this.startTracing(activity);
        this.firstActivityCreated = true;
    }

    public synchronized void onActivityStarted(@NotNull Activity activity) {
        this.activityFramesTracker.addActivity(activity);
        this.addBreadcrumb(activity, "started");
    }

    @SuppressLint(value={"NewApi"})
    public synchronized void onActivityResumed(@NotNull Activity activity) {
        if (!this.firstActivityResumed) {
            if (this.foregroundImportance) {
                AppStartState.getInstance().setAppStartEnd();
            } else if (this.options != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "App Start won't be reported because Process wasn't of foregroundImportance.", new Object[0]);
            }
            if (this.performanceEnabled && this.appStartSpan != null) {
                this.appStartSpan.finish();
            }
            this.firstActivityResumed = true;
        }
        ISpan ttidSpan = this.ttidSpanMap.get(activity);
        View rootView = activity.findViewById(0x1020002);
        if (this.buildInfoProvider.getSdkInfoVersion() >= 16 && rootView != null) {
            FirstDrawDoneListener.registerForNextDraw(rootView, () -> this.finishSpan(ttidSpan), this.buildInfoProvider);
        } else {
            this.mainHandler.post(() -> this.finishSpan(ttidSpan));
        }
        this.addBreadcrumb(activity, "resumed");
        if (!this.isAllActivityCallbacksAvailable && this.options != null) {
            this.stopTracing(activity, this.options.isEnableActivityLifecycleTracingAutoFinish());
        }
    }

    public synchronized void onActivityPostResumed(@NotNull Activity activity) {
        if (this.isAllActivityCallbacksAvailable && this.options != null) {
            this.stopTracing(activity, this.options.isEnableActivityLifecycleTracingAutoFinish());
        }
    }

    public void onActivityPrePaused(@NonNull Activity activity) {
        if (this.isAllActivityCallbacksAvailable) {
            this.lastPausedTime = this.hub == null ? AndroidDateUtils.getCurrentSentryDateTime() : this.hub.getOptions().getDateProvider().now();
        }
    }

    public synchronized void onActivityPaused(@NotNull Activity activity) {
        if (!this.isAllActivityCallbacksAvailable) {
            this.lastPausedTime = this.hub == null ? AndroidDateUtils.getCurrentSentryDateTime() : this.hub.getOptions().getDateProvider().now();
        }
        this.addBreadcrumb(activity, "paused");
    }

    public synchronized void onActivityStopped(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "stopped");
    }

    public synchronized void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        this.addBreadcrumb(activity, "saveInstanceState");
    }

    public synchronized void onActivityDestroyed(@NotNull Activity activity) {
        this.addBreadcrumb(activity, "destroyed");
        this.finishSpan(this.appStartSpan, SpanStatus.CANCELLED);
        ISpan ttidSpan = this.ttidSpanMap.get(activity);
        this.finishSpan(ttidSpan, SpanStatus.CANCELLED);
        this.stopTracing(activity, true);
        this.appStartSpan = null;
        this.ttidSpanMap.remove(activity);
        if (this.performanceEnabled) {
            this.activitiesWithOngoingTransactions.remove(activity);
        }
    }

    private void finishSpan(@Nullable ISpan span) {
        if (span != null && !span.isFinished()) {
            span.finish();
        }
    }

    private void finishSpan(@Nullable ISpan span, @NotNull SpanStatus status) {
        if (span != null && !span.isFinished()) {
            span.finish(status);
        }
    }

    @TestOnly
    @NotNull
    WeakHashMap<Activity, ITransaction> getActivitiesWithOngoingTransactions() {
        return this.activitiesWithOngoingTransactions;
    }

    @TestOnly
    @NotNull
    ActivityFramesTracker getActivityFramesTracker() {
        return this.activityFramesTracker;
    }

    @TestOnly
    @Nullable
    ISpan getAppStartSpan() {
        return this.appStartSpan;
    }

    @TestOnly
    @NotNull
    WeakHashMap<Activity, ISpan> getTtidSpanMap() {
        return this.ttidSpanMap;
    }

    private void setColdStart(@Nullable Bundle savedInstanceState) {
        if (!this.firstActivityCreated) {
            AppStartState.getInstance().setColdStart(savedInstanceState == null);
        }
    }

    @NotNull
    private String getTtidDesc(@NotNull String activityName) {
        return activityName + " initial display";
    }

    @NotNull
    private String getAppStartDesc(boolean coldStart) {
        if (coldStart) {
            return "Cold Start";
        }
        return "Warm Start";
    }

    @NotNull
    private String getAppStartOp(boolean coldStart) {
        if (coldStart) {
            return APP_START_COLD;
        }
        return APP_START_WARM;
    }
}

